/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.list;

import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.filter.IIntFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.entry.TIntEntry;
import edu.sysu.pmglab.container.entry.TObjectIntEntry;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.TCollections;
import gnu.trove.function.TIntFunction;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.function.IntFunction;

public class IntList {
    int[] cache;
    int start = 0;
    int end = 0;

    public IntList() {
        this(4);
    }

    public IntList(int initialCapacity) {
        if (initialCapacity == 0) {
            this.cache = EmptyArray.INT;
        } else {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
            }
            this.cache = new int[initialCapacity];
        }
    }

    public IntList(int[] values2) {
        this(values2, 0, values2.length);
    }

    public IntList(int[] values2, int offset, int length) {
        this.cache = new int[values2.length];
        System.arraycopy(values2, offset, this.cache, 0, length);
        this.end = length;
    }

    public IntList(Integer[] values2) {
        this.cache = new int[values2.length];
        for (Integer value : values2) {
            if (value == null) continue;
            this.cache[this.end++] = value;
        }
    }

    public IntList(Iterable<Integer> values2) {
        this.cache = new int[4];
        for (Integer value : values2) {
            if (value == null) continue;
            this.add(value);
        }
    }

    public IntList(TIntIterator values2) {
        this.cache = new int[4];
        while (values2.hasNext()) {
            this.add(values2.next());
        }
    }

    public static IntList range(int start, int end) {
        if (start > end) {
            return new IntList(0);
        }
        IntList list = new IntList(end - start + 1);
        for (int i = start; i <= end; ++i) {
            list.add(i);
        }
        return list;
    }

    public static IntList wrap(int ... src) {
        if (src == null || src.length == 0) {
            return new IntList(0);
        }
        return IntList.wrap(src, 0, src.length);
    }

    public static IntList wrap(int[] src, int offset, int length) {
        Assert.that(src != null);
        Assert.that(offset >= 0 && offset <= src.length);
        Assert.that(length >= 0 && offset + length <= src.length);
        IntList array = new IntList(0);
        array.cache = src;
        array.start = offset;
        array.end = offset + length;
        return array;
    }

    public int popFirst() {
        if (this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Empty queue");
        }
        try {
            int n = this.fastGet(0);
            return n;
        }
        finally {
            ++this.start;
        }
    }

    public int popLast() {
        if (this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Empty queue");
        }
        try {
            int n = this.fastLastGet(0);
            return n;
        }
        finally {
            --this.end;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntList popFirst(int size, boolean requireReturns) {
        if (size < 0 || this.start + size > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        try {
            if (requireReturns) {
                IntList returns = new IntList(size);
                for (int i = 0; i < size; ++i) {
                    returns.add(this.fastGet(i));
                }
                IntList intList = returns;
                return intList;
            }
            IntList intList = null;
            return intList;
        }
        finally {
            this.start += size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntList popLast(int size, boolean requireReturns) {
        if (size < 0 || this.start + size > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        try {
            if (requireReturns) {
                IntList returns = new IntList(size);
                for (int i = size - 1; i >= 0; --i) {
                    returns.add(this.fastLastGet(i));
                }
                IntList intList = returns;
                return intList;
            }
            IntList intList = null;
            return intList;
        }
        finally {
            this.end -= size;
        }
    }

    private void checkCapacity(int writeSize) {
        this.expansion(writeSize - (this.cache.length - this.end));
    }

    private void expansion(long requestSize) {
        if (requestSize > 0L) {
            long newSize = requestSize + (long)(this.cache.length - this.start);
            if (newSize <= (long)this.cache.length) {
                int index = 0;
                int l = this.size();
                for (int i = 0; i < l; ++i) {
                    this.cache[index++] = this.fastGet(i);
                }
                this.start = 0;
                this.end = index;
                return;
            }
            if (newSize >= 0x7FFFFFFDL) {
                throw new OutOfMemoryError("Requested array size exceeds VM limit");
            }
            newSize = newSize < 16L ? 16L : (newSize <= 0x7FFFFFFL ? (newSize <<= 1) : ValueUtils.valueOf(newSize + (newSize >> 1), 0L, 0x7FFFFFFDL));
            int[] newCache = new int[(int)newSize];
            System.arraycopy(this.cache, this.start, newCache, 0, this.size());
            this.end -= this.start;
            this.start = 0;
            this.cache = newCache;
        }
    }

    public int[] toArray() {
        if (this.size() == 0) {
            return EmptyArray.INT;
        }
        return Arrays.copyOfRange(this.cache, this.start, this.end);
    }

    public int[] toArray(int[] dest) {
        if (dest.length < this.size()) {
            return Arrays.copyOfRange(this.cache, this.start, this.end);
        }
        System.arraycopy(this.cache, 0, dest, 0, this.size());
        if (dest.length > this.size()) {
            dest[this.size()] = 0;
        }
        return dest;
    }

    public int size() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(int element) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (element != this.fastGet(i)) continue;
            return true;
        }
        return false;
    }

    public TIntIterator iterator() {
        return new TIntIterator(){
            final int size;
            int pointer;
            {
                this.size = IntList.this.size();
                this.pointer = 0;
            }

            @Override
            public int next() {
                return IntList.this.fastGet(this.pointer++);
            }

            @Override
            public boolean hasNext() {
                return this.pointer < this.size;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean add(int element) {
        this.checkCapacity(1);
        this.cache[this.end++] = element;
        return true;
    }

    public boolean remove(int element) {
        boolean anyRemove = false;
        if (this.size() > 0) {
            int index = 0;
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                int value = this.fastGet(i);
                if (element != value) {
                    this.cache[index++] = value;
                    continue;
                }
                anyRemove = true;
            }
            this.start = 0;
            this.end = index;
        }
        return anyRemove;
    }

    public void clear() {
        this.start = 0;
        this.end = 0;
    }

    public int removeByIndex(int index) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        int size = this.size();
        int value = this.fastGet(index);
        if (index == 0) {
            ++this.start;
        } else if (index == size - 1) {
            --this.end;
        } else if (index < size / 2) {
            for (int ind = this.start + index; ind >= this.start + 1; --ind) {
                this.cache[ind] = this.cache[ind - 1];
            }
            ++this.start;
        } else {
            for (int ind = this.start + index; ind < this.end - 1; ++ind) {
                this.cache[ind] = this.cache[ind + 1];
            }
            --this.end;
        }
        return value;
    }

    public boolean insert(int index, int value) {
        if (index < 0 || this.start + index > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        this.checkCapacity(1);
        if (this.start > 0) {
            int l = this.start + index;
            for (int i = this.start; i < l; ++i) {
                this.cache[i - 1] = this.fastGet(i);
            }
            --this.start;
        } else {
            int l = this.start + index;
            for (int i = this.end - 1; i >= l; --i) {
                this.cache[i + 1] = this.fastGet(i);
            }
            ++this.end;
        }
        this.cache[this.start + index] = value;
        return true;
    }

    public boolean addAll(int[] elements) {
        return this.addAll(elements, 0, elements.length);
    }

    public boolean addAll(int[] elements, int offset, int length) {
        Assert.that(elements != null);
        Assert.that(offset >= 0 && offset <= elements.length);
        Assert.that(length >= 0 && offset + length <= elements.length);
        this.checkCapacity(length);
        for (int i = offset; i < offset + length; ++i) {
            this.cache[this.end++] = elements[i];
        }
        return true;
    }

    public boolean addAll(IntList values2) {
        Assert.that(values2 != null);
        this.checkCapacity(values2.size());
        boolean addAnyValue = false;
        int l = values2.size();
        for (int i = 0; i < l; ++i) {
            this.cache[this.end++] = values2.fastGet(i);
            addAnyValue = true;
        }
        return addAnyValue;
    }

    public IntList subList(int fromIndex, int toIndex) {
        Assert.that(fromIndex >= 0 && fromIndex <= this.size());
        Assert.that(toIndex >= 0 && toIndex <= this.size());
        Assert.that(fromIndex <= toIndex);
        return IntList.wrap(this.cache, this.start + fromIndex, toIndex - fromIndex);
    }

    public boolean removeIf(IIntFilter condition) {
        int index = 0;
        boolean change = false;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            int value = this.fastGet(i);
            if (condition.filter(value)) {
                change = true;
                continue;
            }
            this.cache[index++] = value;
        }
        this.start = 0;
        this.end = index;
        return change;
    }

    public boolean retainIf(IIntFilter condition) {
        int index = 0;
        boolean change = false;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            int value = this.fastGet(i);
            if (condition.filter(value)) {
                this.cache[index++] = value;
                continue;
            }
            change = true;
        }
        this.start = 0;
        this.end = index;
        return change;
    }

    public int fastGet(int index) {
        return this.cache[this.start + index];
    }

    public int fastLastGet(int index) {
        return this.cache[this.end - index - 1];
    }

    public int fastSet(int index, int newValue) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        this.cache[this.start + index] = newValue;
        return newValue;
    }

    public int get(int index) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        return this.fastGet(index);
    }

    public int lastGet(int index) {
        return this.get(this.size() - 1 - index);
    }

    public int set(int index, int newValue) {
        if (index == this.size()) {
            this.add(newValue);
        } else {
            if (index < 0 || this.start + index >= this.end) {
                throw new ArrayIndexOutOfBoundsException("Index out of bounds");
            }
            this.cache[this.start + index] = newValue;
        }
        return newValue;
    }

    public int lastSet(int index, int newValue) {
        return this.set(this.end - index - 1, newValue);
    }

    public int hashCode() {
        int hashCode = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            hashCode = 31 * hashCode + Integer.hashCode(this.fastGet(i));
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntList)) {
            return false;
        }
        IntList array = (IntList)o;
        if (this.cache == array.cache && this.start == array.start && this.end == array.end) {
            return true;
        }
        if (array.size() != this.size()) {
            return false;
        }
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (this.fastGet(i) == array.fastGet(i)) continue;
            return false;
        }
        return true;
    }

    public IntList clone() {
        return new IntList(this.cache, this.start, this.size());
    }

    public String toString() {
        TIntIterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            int e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public void dropDuplicates() {
        if (this.size() <= 1) {
            return;
        }
        TIntHashSet existsElements = new TIntHashSet();
        int index = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            int element = this.fastGet(i);
            if (existsElements.contains(element)) continue;
            existsElements.add(element);
            this.cache[index++] = element;
        }
        existsElements.clear();
        this.start = 0;
        this.end = index;
    }

    public void fill(int value, int size) {
        if (size > 0) {
            this.checkCapacity(size);
            for (int i = 0; i < size; ++i) {
                this.cache[this.end++] = value;
            }
        }
    }

    public void close() {
        this.start = 0;
        this.end = 0;
        this.cache = EmptyArray.INT;
    }

    public int binarySearch(int key) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this.cache[this.start + mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int argmax() {
        if (this.size() == 0) {
            return -1;
        }
        int element = this.fastGet(0);
        int index = 0;
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (element >= this.fastGet(i)) continue;
            index = i;
        }
        return index;
    }

    public int argmin() {
        if (this.size() == 0) {
            return -1;
        }
        int element = this.fastGet(0);
        int index = 0;
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (element <= this.fastGet(i)) continue;
            index = i;
        }
        return index;
    }

    public int max() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        int maxValue = this.fastGet(0);
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (maxValue >= this.fastGet(i)) continue;
            maxValue = this.fastGet(i);
        }
        return maxValue;
    }

    public int min() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        int minValue = this.fastGet(0);
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (minValue <= this.fastGet(i)) continue;
            minValue = this.fastGet(i);
        }
        return minValue;
    }

    public long sum() {
        long sum = 0L;
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            sum += (long)this.fastGet(i);
        }
        return sum;
    }

    public boolean all(IIntFilter rule) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (rule.filter(this.fastGet(i))) continue;
            return false;
        }
        return true;
    }

    public boolean any(IIntFilter rule) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!rule.filter(this.fastGet(i))) continue;
            return true;
        }
        return false;
    }

    public int count(IIntFilter rule) {
        int count = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!rule.filter(this.fastGet(i))) continue;
            ++count;
        }
        return count;
    }

    public TIntSet toSet() {
        TIntHashSet container = new TIntHashSet(this.size());
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            container.add(this.fastGet(i));
        }
        return container;
    }

    public TIntSet toUnmodifiableSet() {
        return TCollections.unmodifiableSet(this.toSet());
    }

    public IndexIterator where(IIntFilter function) {
        return new IndexIterator(this.size(), function == null ? null : index -> function.filter(this.fastGet(index)));
    }

    public IntList apply(TIntFunction function) {
        return this.apply(function, null);
    }

    public IntList apply(TIntFunction function, IIntFilter filter) {
        IntList result = new IntList(this.size());
        if (filter != null) {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                int value = function.execute(this.fastGet(i));
                if (!filter.filter(value)) continue;
                result.add(value);
            }
        } else {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                result.add(function.execute(this.fastGet(i)));
            }
        }
        return result;
    }

    public <V> List<V> apply(IntFunction<V> function) {
        return this.apply(function, null);
    }

    public <V> List<V> apply(IntFunction<V> function, IFilter<V> filter) {
        List<V> result = new List<V>(this.size());
        if (filter != null) {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                V value = function.apply(this.fastGet(i));
                if (!filter.filter(value)) continue;
                result.add(value);
            }
        } else {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                result.add(function.apply(this.fastGet(i)));
            }
        }
        return result;
    }

    public void applyInplace(TIntFunction function) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            this.cache[i] = function.execute(this.fastGet(i));
        }
        this.end = l;
        this.start = 0;
    }

    public IntList filter(IIntFilter filter) {
        IntList result = new IntList(1);
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            int c = this.fastGet(i);
            if (!filter.filter(c)) continue;
            result.add(c);
        }
        return result;
    }

    public void sort(int beginIndex, int endIndex) {
        Assert.that(beginIndex >= 0 && beginIndex <= this.size());
        Assert.that(endIndex >= beginIndex && endIndex <= this.size());
        Arrays.sort(this.cache, this.start + beginIndex, this.start + endIndex);
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public <V extends Comparable<V>> void sortWith(TIntObjectMap<V> values2) {
        if (this.size() > 0) {
            TObjectIntEntry[] indices = new TObjectIntEntry[this.size()];
            for (int i = 0; i < indices.length; ++i) {
                int element = this.fastGet(i);
                indices[i] = new TObjectIntEntry<V>(values2.get(element), element);
            }
            Arrays.sort(indices, Comparator.comparing(TObjectIntEntry::getKey));
            this.start = 0;
            this.end = 0;
            for (TObjectIntEntry index : indices) {
                this.cache[this.end++] = index.getValue();
            }
        }
    }

    public <V extends Comparable<V>> void sortWith(List<V> values2) {
        if (this.size() > 0) {
            TObjectIntEntry[] indices = new TObjectIntEntry[this.size()];
            for (int i = 0; i < indices.length; ++i) {
                int element = this.fastGet(i);
                indices[i] = new TObjectIntEntry<V>(values2.get(element), element);
            }
            Arrays.sort(indices, Comparator.comparing(TObjectIntEntry::getKey));
            this.start = 0;
            this.end = 0;
            for (TObjectIntEntry index : indices) {
                this.cache[this.end++] = index.getValue();
            }
        }
    }

    public <V extends Comparable<V>> void sortWith(IntList values2) {
        if (this.size() > 0) {
            TIntEntry[] indices = new TIntEntry[this.size()];
            for (int i = 0; i < indices.length; ++i) {
                int element = this.fastGet(i);
                indices[i] = new TIntEntry(values2.get(element), element);
            }
            Arrays.sort(indices, Comparator.comparingInt(TIntEntry::getKey));
            this.start = 0;
            this.end = 0;
            for (TIntEntry index : indices) {
                this.cache[this.end++] = index.getValue();
            }
        }
    }

    public <V extends Comparable<V>> void sortWith(int[] values2) {
        if (this.size() > 0) {
            TIntEntry[] indices = new TIntEntry[this.size()];
            for (int i = 0; i < indices.length; ++i) {
                int element = this.fastGet(i);
                indices[i] = new TIntEntry(values2[element], element);
            }
            Arrays.sort(indices, Comparator.comparingInt(TIntEntry::getKey));
            this.start = 0;
            this.end = 0;
            for (TIntEntry index : indices) {
                this.cache[this.end++] = index.getValue();
            }
        }
    }

    public IntList argsort() {
        IntList indices = IntList.range(0, this.size() - 1);
        indices.sortWith(this);
        return indices;
    }

    public int indexOf(int element) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (element != this.fastGet(i)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIf(IIntFilter condition) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!condition.filter(this.fastGet(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int element) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (element != this.fastLastGet(i)) continue;
            return l - i - 1;
        }
        return -1;
    }

    public int lastIndexOfIf(IIntFilter condition) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!condition.filter(this.fastLastGet(i))) continue;
            return l - i - 1;
        }
        return -1;
    }

    public String toString(String joiner) {
        TIntIterator it = this.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            int e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.toString();
            }
            sb.append(joiner);
        }
    }

    public IntList asUnmodifiable() {
        return new IntList(){
            {
                this.cache = IntList.this.cache;
                this.start = IntList.this.start;
                this.end = IntList.this.end;
            }

            @Override
            public int popFirst() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int popLast() {
                throw new UnsupportedOperationException();
            }

            @Override
            public IntList popFirst(int size, boolean requireReturns) {
                throw new UnsupportedOperationException();
            }

            @Override
            public IntList popLast(int size, boolean requireReturns) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(int element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(int element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int removeByIndex(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean insert(int index, int value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(int[] elements) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(int[] elements, int offset, int length) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(IntList values2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeIf(IIntFilter condition) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainIf(IIntFilter condition) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int fastSet(int index, int newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int set(int index, int newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int lastSet(int index, int newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void dropDuplicates() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void applyInplace(TIntFunction function) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sort(int beginIndex, int endIndex) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sort() {
                throw new UnsupportedOperationException();
            }

            @Override
            public <V extends Comparable<V>> void sortWith(TIntObjectMap<V> values2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <V extends Comparable<V>> void sortWith(List<V> values2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <V extends Comparable<V>> void sortWith(IntList values2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public IntList asUnmodifiable() {
                return this;
            }

            @Override
            public void shuffle(long seed) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void shuffle(long seed) {
        Random random = new Random(seed);
        for (int i = this.end - 1; i > this.start; --i) {
            int j = this.start + random.nextInt(i - this.start + 1);
            int temp = this.cache[i];
            this.cache[i] = this.cache[j];
            this.cache[j] = temp;
        }
    }
}

