/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.list;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.filter.IIntFilter;
import edu.sysu.pmglab.ccf.toolkit.filter.ILongFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.LongList;
import edu.sysu.pmglab.utils.Assert;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.TCollections;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class List<T>
extends AbstractList<T> {
    private static final List<?> EMPTY = new List(0).asUnmodifiable();
    Object[] cache;
    int start = 0;
    int end = 0;

    public List() {
        this(4);
    }

    public List(int initialCapacity) {
        if (initialCapacity == 0) {
            this.cache = EmptyArray.OBJECT;
        } else {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
            }
            this.cache = new Object[initialCapacity];
        }
    }

    public List(T[] values2) {
        this(values2, 0, values2.length);
    }

    public List(Iterable<T> iterable) {
        this(16);
        for (T value : iterable) {
            this.add(value);
        }
    }

    public List(T[] values2, int offset, int length) {
        this.cache = new Object[values2.length];
        System.arraycopy(values2, offset, this.cache, 0, length);
        this.end = length;
    }

    public static <T> List<T> EMPTY() {
        return EMPTY;
    }

    public static <T> List<T> singleton(T src) {
        List<T> returns = new List<T>(1);
        returns.end = 1;
        returns.cache[0] = src;
        return returns;
    }

    public static <T> List<T> wrap(Iterable<T> src) {
        if (src instanceof List) {
            List<T> array = new List<T>(0);
            array.cache = ((List)src).cache;
            array.start = ((List)src).start;
            array.end = ((List)src).end;
            return array;
        }
        return new List<T>(src);
    }

    public static <T> List<T> wrap(T[] src) {
        if (src == null || src.length == 0) {
            return new List<T>(0);
        }
        return List.wrap(src, 0, src.length);
    }

    public static <T> List<T> wrap(Object[] src, int offset, int length) {
        Assert.that(src != null);
        Assert.that(offset >= 0 && offset <= src.length);
        Assert.that(length >= 0 && offset + length <= src.length);
        List<T> array = new List<T>(0);
        array.cache = src;
        array.start = offset;
        array.end = offset + length;
        return array;
    }

    public static List<String> wrap(String ... otherValues) {
        return List.wrap((Object[])otherValues, 0, otherValues.length);
    }

    public static List<Bytes> wrap(Bytes ... otherValues) {
        return List.wrap((Object[])otherValues, 0, otherValues.length);
    }

    public T popFirst() {
        if (this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Empty queue");
        }
        try {
            T t = this.fastGet(0);
            return t;
        }
        finally {
            ++this.start;
        }
    }

    public T popLast() {
        if (this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Empty queue");
        }
        try {
            T t = this.fastLastGet(0);
            return t;
        }
        finally {
            --this.end;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> popFirst(int size, boolean requireReturns) {
        if (size < 0 || this.start + size > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        try {
            if (requireReturns) {
                List<T> returns = new List<T>(size);
                for (int i = 0; i < size; ++i) {
                    returns.add(this.fastGet(i));
                }
                List<T> list = returns;
                return list;
            }
            List<T> list = null;
            return list;
        }
        finally {
            this.start += size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> popLast(int size, boolean requireReturns) {
        if (size < 0 || this.start + size > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        try {
            if (requireReturns) {
                List<T> returns = new List<T>(size);
                for (int i = size - 1; i >= 0; --i) {
                    returns.add(this.fastLastGet(i));
                }
                List<T> list = returns;
                return list;
            }
            List<T> list = null;
            return list;
        }
        finally {
            this.end -= size;
        }
    }

    private void checkCapacity(int writeSize) {
        this.expansion(writeSize - (this.cache.length - this.end));
    }

    private void expansion(long requestSize) {
        if (requestSize > 0L) {
            long newSize = requestSize + (long)(this.cache.length - this.start);
            if (newSize <= (long)this.cache.length) {
                int index = 0;
                for (T value : this) {
                    this.cache[index++] = value;
                }
                this.start = 0;
                this.end = index;
                return;
            }
            if (newSize >= 0x7FFFFFFDL) {
                throw new OutOfMemoryError("Requested array size exceeds VM limit");
            }
            newSize = newSize < 16L ? 16L : (newSize <= 0x7FFFFFFL ? (newSize <<= 1) : ValueUtils.valueOf(newSize + (newSize >> 1), 0L, 0x7FFFFFFDL));
            Object[] newCache = new Object[(int)newSize];
            System.arraycopy(this.cache, this.start, newCache, 0, this.size());
            this.end -= this.start;
            this.start = 0;
            this.cache = newCache;
        }
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object element) {
        if (element == null) {
            for (T value : this) {
                if (value != null) continue;
                return true;
            }
        } else {
            for (T value : this) {
                if (!element.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        if (this.size() == 0) {
            return EmptyArray.OBJECT;
        }
        return Arrays.copyOfRange(this.cache, this.start, this.end);
    }

    @Override
    public <T1> T1[] toArray(T1[] dest) {
        if (dest.length < this.size()) {
            return Arrays.copyOfRange(this.cache, this.start, this.end, dest.getClass());
        }
        System.arraycopy(this.cache, 0, dest, 0, this.size());
        if (dest.length > this.size()) {
            dest[this.size()] = null;
        }
        return dest;
    }

    @Override
    public boolean remove(Object element) {
        boolean anyRemove = false;
        if (this.size() > 0) {
            int index = 0;
            if (element == null) {
                for (T value : this) {
                    if (value != null) {
                        this.cache[index++] = value;
                        continue;
                    }
                    anyRemove = true;
                }
            } else {
                for (T value : this) {
                    if (!element.equals(value)) {
                        this.cache[index++] = value;
                        continue;
                    }
                    anyRemove = true;
                }
            }
            this.start = 0;
            this.end = index;
        }
        return anyRemove;
    }

    @Override
    public String toString() {
        Iterator<T> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            T e;
            sb.append((Object)((e = it.next()) == this ? "(this List)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean add(T element) {
        this.checkCapacity(1);
        this.cache[this.end++] = element;
        return true;
    }

    @Override
    public T get(int index) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        return this.fastGet(index);
    }

    @Override
    public T set(int index, T newValue) {
        if (index == this.size()) {
            this.add(newValue);
        } else {
            if (index < 0 || this.start + index >= this.end) {
                throw new ArrayIndexOutOfBoundsException("Index out of bounds");
            }
            this.cache[this.start + index] = newValue;
        }
        return newValue;
    }

    @Override
    public int indexOf(Object element) {
        int index = 0;
        if (element == null) {
            for (T value : this) {
                if (value == null) {
                    return index;
                }
                ++index;
            }
        } else {
            for (T value : this) {
                if (element.equals(value)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        if (element == null) {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                if (this.fastLastGet(i) != null) continue;
                return l - i - 1;
            }
        } else {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                if (!element.equals(this.fastLastGet(i))) continue;
                return l - i - 1;
            }
        }
        return -1;
    }

    @Override
    public void clear() {
        this.start = 0;
        this.end = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final int length;
            int pointer;
            {
                this.length = List.this.size();
                this.pointer = 0;
            }

            @Override
            public boolean hasNext() {
                return this.pointer < this.length;
            }

            @Override
            public T next() {
                return List.this.fastGet(this.pointer++);
            }
        };
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        Assert.that(fromIndex >= 0 && fromIndex <= this.size());
        Assert.that(toIndex >= 0 && toIndex <= this.size());
        Assert.that(fromIndex <= toIndex);
        return List.wrap(this.cache, this.start + fromIndex, toIndex - fromIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List array = (List)o;
        if (this.cache == array.cache && this.start == array.start && this.end == array.end) {
            return true;
        }
        if (array.size() != this.size()) {
            return false;
        }
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            T v1 = this.fastGet(i);
            T v2 = array.fastGet(i);
            if (!(v1 == null ? v2 != null : v1.equals(v2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (T value : this) {
            hashCode = 31 * hashCode + Objects.hashCode(value);
        }
        return hashCode;
    }

    public T removeByIndex(int index) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        int size = this.size();
        T value = this.fastGet(index);
        if (index == 0) {
            ++this.start;
        } else if (index == size - 1) {
            --this.end;
        } else if (index < size / 2) {
            for (int ind = this.start + index; ind >= this.start + 1; --ind) {
                this.cache[ind] = this.cache[ind - 1];
            }
            ++this.start;
        } else {
            for (int ind = this.start + index; ind < this.end - 1; ++ind) {
                this.cache[ind] = this.cache[ind + 1];
            }
            --this.end;
        }
        return value;
    }

    public boolean insert(int index, T value) {
        if (index < 0 || this.start + index > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        this.checkCapacity(1);
        if (this.start > 0) {
            int l = this.start + index;
            for (int i = this.start; i < l; ++i) {
                this.cache[i - 1] = this.cache[i];
            }
            --this.start;
        } else {
            int l = this.start + index;
            for (int i = this.end - 1; i >= l; --i) {
                this.cache[i + 1] = this.cache[i];
            }
            ++this.end;
        }
        this.cache[this.start + index] = value;
        return true;
    }

    public boolean addAll(T[] elements) {
        return this.addAll(elements, 0, elements.length);
    }

    public boolean addAll(T[] elements, int offset, int length) {
        Assert.that(elements != null);
        Assert.that(offset >= 0 && offset <= elements.length);
        Assert.that(length >= 0 && offset + length <= elements.length);
        this.checkCapacity(length);
        for (int i = offset; i < offset + length; ++i) {
            this.cache[this.end++] = elements[i];
        }
        return true;
    }

    public List<T> subList(int fromIndex) {
        return this.subList(fromIndex, this.size());
    }

    @Override
    public boolean removeIf(IFilter<T> condition) {
        int index = 0;
        boolean change = false;
        for (T value : this) {
            if (condition.filter(value)) {
                change = true;
                continue;
            }
            this.cache[index++] = value;
        }
        this.start = 0;
        this.end = index;
        return change;
    }

    public boolean retainIf(IFilter<T> condition) {
        int index = 0;
        boolean change = false;
        for (T value : this) {
            if (condition.filter(value)) {
                this.cache[index++] = value;
                continue;
            }
            change = true;
        }
        this.start = 0;
        this.end = index;
        return change;
    }

    public T fastGet(int index) {
        return (T)this.cache[this.start + index];
    }

    public T fastLastGet(int index) {
        return (T)this.cache[this.end - index - 1];
    }

    public T fastSet(int index, T newValue) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        this.cache[this.start + index] = newValue;
        return newValue;
    }

    public T lastGet(int index) {
        return this.get(this.size() - 1 - index);
    }

    public T lastSet(int index, T newValue) {
        return this.set(this.end - index - 1, newValue);
    }

    public List<T> clone() {
        return new List<T>(this);
    }

    public void dropDuplicates() {
        if (this.size() <= 1) {
            return;
        }
        HashSet<T> existsElements = new HashSet<T>();
        int index = 0;
        for (T element : this) {
            if (existsElements.contains(element)) continue;
            existsElements.add(element);
            this.cache[index++] = element;
        }
        existsElements.clear();
        this.start = 0;
        this.end = index;
    }

    public List<T> fill(T value, int size) {
        if (size > 0) {
            this.checkCapacity(size);
            for (int i = 0; i < size; ++i) {
                this.cache[this.end++] = value;
            }
        }
        return this;
    }

    public void close() {
        this.start = 0;
        this.end = 0;
        this.cache = EmptyArray.OBJECT;
    }

    public int binarySearch(T key) {
        if (key instanceof Comparable) {
            int low = 0;
            int high = this.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                Comparable midVal = (Comparable)this.cache[this.start + mid];
                int cmp = midVal.compareTo(key);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }
        return this.indexOf(key);
    }

    public boolean all(IFilter<T> rule) {
        for (T value : this) {
            if (rule.filter(value)) continue;
            return false;
        }
        return true;
    }

    public boolean any(IFilter<T> rule) {
        for (T value : this) {
            if (!rule.filter(value)) continue;
            return true;
        }
        return false;
    }

    public int count(IFilter<T> rule) {
        int count = 0;
        for (T value : this) {
            if (!rule.filter(value)) continue;
            ++count;
        }
        return count;
    }

    public LinkedSet<T> toIndexableSet() {
        return new LinkedSet(this);
    }

    public Set<T> toSet() {
        LinkedHashSet<T> container = new LinkedHashSet<T>(this.size());
        for (T value : this) {
            container.add(value);
        }
        return container;
    }

    public Set<T> toUnmodifiableSet() {
        LinkedHashSet<T> container = new LinkedHashSet<T>(this.size());
        for (T value : this) {
            container.add(value);
        }
        return Collections.unmodifiableSet(container);
    }

    public IndexIterator where(IFilter<T> function) {
        return new IndexIterator(this.size(), function == null ? null : index -> function.filter(this.fastGet(index)));
    }

    public <N> List<N> apply(Function<T, N> function) {
        return this.apply(function, null);
    }

    public IntList applyAsInt(ToIntFunction<T> function) {
        return this.applyAsInt(function, null);
    }

    public LongList applyAsLong(ToLongFunction<T> function) {
        return this.applyAsLong(function, null);
    }

    public IntList applyAsInt(ToIntFunction<T> function, IIntFilter filter) {
        IntList result = new IntList(this.size());
        if (filter != null) {
            for (T element : this) {
                int value = function.applyAsInt(element);
                if (!filter.filter(value)) continue;
                result.add(value);
            }
        } else {
            for (T element : this) {
                result.add(function.applyAsInt(element));
            }
        }
        return result;
    }

    public LongList applyAsLong(ToLongFunction<T> function, ILongFilter filter) {
        LongList result = new LongList(this.size());
        if (filter != null) {
            for (T element : this) {
                long value = function.applyAsLong(element);
                if (!filter.filter(value)) continue;
                result.add(value);
            }
        } else {
            for (T element : this) {
                result.add(function.applyAsLong(element));
            }
        }
        return result;
    }

    public <N> List<N> apply(Function<T, N> function, IFilter<N> filter) {
        List<N> result = new List<N>(this.size());
        if (filter != null) {
            for (T element : this) {
                N value = function.apply(element);
                if (!filter.filter(value)) continue;
                result.add(value);
            }
        } else {
            for (T element : this) {
                result.add(function.apply(element));
            }
        }
        return result;
    }

    public void applyInplace(Function<T, T> function) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            this.cache[i] = function.apply(this.fastGet(i));
        }
        this.end = l;
        this.start = 0;
    }

    public void filterInplace(IFilter<T> filter) {
        int index = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            T object = this.fastGet(i);
            if (!filter.filter(object)) continue;
            this.cache[index++] = object;
        }
        this.start = 0;
        this.end = index;
    }

    public List<T> filter(IFilter<T> filter) {
        List<T> result = new List<T>(1);
        for (T element : this) {
            if (!filter.filter(element)) continue;
            result.add(element);
        }
        return result;
    }

    public void sort(Comparator<? super T> comparator, int beginIndex, int endIndex) {
        Assert.that(beginIndex >= 0 && beginIndex <= this.size());
        Assert.that(endIndex >= beginIndex && endIndex <= this.size());
        Arrays.sort(this.cache, this.start + beginIndex, this.start + endIndex, comparator == null ? null : (o1, o2) -> comparator.compare(o1, o2));
    }

    public void sort() {
        this.sort((Comparator<? super T>)null);
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        int size = this.size();
        if (size >= 2) {
            this.sort(comparator, 0, size);
        }
    }

    public int indexOfIf(IFilter<T> condition) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!condition.filter(this.fastGet(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfIf(IFilter<T> condition) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!condition.filter(this.fastLastGet(i))) continue;
            return l - i - 1;
        }
        return -1;
    }

    public String toString(String joiner) {
        Iterator<T> it = this.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            T e;
            sb.append((Object)((e = it.next()) == this ? "(this List)" : e));
            if (!it.hasNext()) {
                return sb.toString();
            }
            sb.append(joiner);
        }
    }

    public List<T> asUnmodifiable() {
        return new List<T>(){
            {
                this.cache = List.this.cache;
                this.start = List.this.start;
                this.end = List.this.end;
            }

            @Override
            public T popFirst() {
                throw new UnsupportedOperationException();
            }

            @Override
            public T popLast() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<T> popFirst(int size, boolean requireReturns) {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<T> popLast(int size, boolean requireReturns) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(T element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public T set(int index, T newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public T removeByIndex(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean insert(int index, T value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(T[] elements) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(T[] elements, int offset, int length) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeIf(IFilter<T> condition) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainIf(IFilter<T> condition) {
                throw new UnsupportedOperationException();
            }

            @Override
            public T fastSet(int index, T newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public T lastSet(int index, T newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void dropDuplicates() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<T> fill(T value, int size) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void applyInplace(Function<T, T> function) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sort(Comparator<? super T> comparator, int beginIndex, int endIndex) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sort() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sort(Comparator<? super T> comparator) {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<T> asUnmodifiable() {
                return this;
            }

            @Override
            public void shuffle(long seed) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isModifiable() {
                return false;
            }
        };
    }

    public List<List<T>> divide(ToLongFunction<T> weights, int expectSize) {
        if (expectSize <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        List<List<Object>> returns = new List<List<Object>>(expectSize);
        if (this.size() <= expectSize) {
            for (T element : this) {
                returns.add(List.singleton(element));
            }
            return returns;
        }
        long totalWeights = 0L;
        for (T element : this) {
            long weight = weights.applyAsLong(element);
            if (weight < 0L) {
                throw new UnsupportedOperationException("weight < 0");
            }
            totalWeights += weight;
        }
        long averageWeight = totalWeights % (long)expectSize == 0L ? totalWeights / (long)expectSize : totalWeights / (long)expectSize + 1L;
        long cumsumWeights = 0L;
        List<T> wrapper = new List<T>();
        for (T element : this) {
            wrapper.add(element);
            long weight = weights.applyAsLong(element);
            if (cumsumWeights + weight >= (long)(returns.size() + 1) * averageWeight) {
                returns.add((List<Object>)wrapper.clone());
                wrapper.clear();
            }
            cumsumWeights += weight;
        }
        if (wrapper.size() > 0) {
            returns.add(wrapper);
        }
        return returns;
    }

    public void shuffle(long seed) {
        Random random = new Random(seed);
        for (int i = this.end - 1; i > this.start; --i) {
            int j = this.start + random.nextInt(i - this.start + 1);
            Object temp = this.cache[i];
            this.cache[i] = this.cache[j];
            this.cache[j] = temp;
        }
    }

    public boolean isModifiable() {
        return true;
    }

    public <K> Map<K, T> toMap(Function<T, K> mapper) {
        LinkedHashMap<K, T> map = new LinkedHashMap<K, T>();
        for (T value : this) {
            K key = mapper.apply(value);
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }

    public TLongObjectMap<T> toLongMap(ToLongFunction<T> mapper) {
        TLongObjectHashMap<T> map = new TLongObjectHashMap<T>(this.size());
        for (T value : this) {
            long key = mapper.applyAsLong(value);
            map.put(key, value);
        }
        return TCollections.unmodifiableMap(map);
    }

    public TIntObjectMap<T> toIntMap(ToIntFunction<T> mapper) {
        TIntObjectHashMap<T> map = new TIntObjectHashMap<T>(this.size());
        for (T value : this) {
            int key = mapper.applyAsInt(value);
            map.put(key, value);
        }
        return TCollections.unmodifiableMap(map);
    }
}

