/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.list;

import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.filter.ILongFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.entry.TObjectLongEntry;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.TCollections;
import gnu.trove.function.TLongFunction;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.function.LongFunction;

public class LongList {
    long[] cache;
    int start = 0;
    int end = 0;

    public LongList() {
        this(4);
    }

    public LongList(int initialCapacity) {
        if (initialCapacity == 0) {
            this.cache = EmptyArray.LONG;
        } else {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
            }
            this.cache = new long[initialCapacity];
        }
    }

    public LongList(long[] values2) {
        this(values2, 0, values2.length);
    }

    public LongList(long[] values2, int offset, int length) {
        this.cache = new long[values2.length];
        System.arraycopy(values2, offset, this.cache, 0, length);
        this.end = length;
    }

    public LongList(Long[] values2) {
        this.cache = new long[values2.length];
        for (Long value : values2) {
            if (value == null) continue;
            this.cache[this.end++] = value;
        }
    }

    public LongList(Iterable<Long> values2) {
        this.cache = new long[4];
        for (Long value : values2) {
            if (value == null) continue;
            this.add(value);
        }
    }

    public LongList(TLongIterator values2) {
        this.cache = new long[4];
        while (values2.hasNext()) {
            this.add(values2.next());
        }
    }

    public static LongList wrap(long ... src) {
        if (src == null || src.length == 0) {
            return new LongList(0);
        }
        return LongList.wrap(src, 0, src.length);
    }

    public static LongList wrap(long[] src, int offset, int length) {
        Assert.that(src != null);
        Assert.that(offset >= 0 && offset <= src.length);
        Assert.that(length >= 0 && offset + length <= src.length);
        LongList array = new LongList(0);
        array.cache = src;
        array.start = offset;
        array.end = offset + length;
        return array;
    }

    public long popFirst() {
        if (this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Empty queue");
        }
        try {
            long l = this.fastGet(0);
            return l;
        }
        finally {
            ++this.start;
        }
    }

    public long popLast() {
        if (this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Empty queue");
        }
        try {
            long l = this.fastLastGet(0);
            return l;
        }
        finally {
            --this.end;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongList popFirst(int size, boolean requireReturns) {
        if (size < 0 || this.start + size > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        try {
            if (requireReturns) {
                LongList returns = new LongList(size);
                for (int i = 0; i < size; ++i) {
                    returns.add(this.fastGet(i));
                }
                LongList longList = returns;
                return longList;
            }
            LongList longList = null;
            return longList;
        }
        finally {
            this.start += size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongList popLast(int size, boolean requireReturns) {
        if (size < 0 || this.start + size > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        try {
            if (requireReturns) {
                LongList returns = new LongList(size);
                for (int i = size - 1; i >= 0; --i) {
                    returns.add(this.fastLastGet(i));
                }
                LongList longList = returns;
                return longList;
            }
            LongList longList = null;
            return longList;
        }
        finally {
            this.end -= size;
        }
    }

    private void checkCapacity(int writeSize) {
        this.expansion(writeSize - (this.cache.length - this.end));
    }

    private void expansion(long requestSize) {
        if (requestSize > 0L) {
            long newSize = requestSize + (long)(this.cache.length - this.start);
            if (newSize <= (long)this.cache.length) {
                int index = 0;
                int l = this.size();
                for (int i = 0; i < l; ++i) {
                    this.cache[index++] = this.fastGet(i);
                }
                this.start = 0;
                this.end = index;
                return;
            }
            if (newSize >= 0x7FFFFFFDL) {
                throw new OutOfMemoryError("Requested array size exceeds VM limit");
            }
            newSize = newSize < 16L ? 16L : (newSize <= 0x7FFFFFFL ? (newSize <<= 1) : ValueUtils.valueOf(newSize + (newSize >> 1), 0L, 0x7FFFFFFDL));
            long[] newCache = new long[(int)newSize];
            System.arraycopy(this.cache, this.start, newCache, 0, this.size());
            this.end -= this.start;
            this.start = 0;
            this.cache = newCache;
        }
    }

    public long[] toArray() {
        if (this.size() == 0) {
            return EmptyArray.LONG;
        }
        return Arrays.copyOfRange(this.cache, this.start, this.end);
    }

    public long[] toArray(long[] dest) {
        if (dest.length < this.size()) {
            return Arrays.copyOfRange(this.cache, this.start, this.end);
        }
        System.arraycopy(this.cache, 0, dest, 0, this.size());
        if (dest.length > this.size()) {
            dest[this.size()] = 0L;
        }
        return dest;
    }

    public int size() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(long element) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (element != this.fastGet(i)) continue;
            return true;
        }
        return false;
    }

    public TLongIterator iterator() {
        return new TLongIterator(){
            final int size;
            int pointer;
            {
                this.size = LongList.this.size();
                this.pointer = 0;
            }

            @Override
            public long next() {
                return LongList.this.fastGet(this.pointer++);
            }

            @Override
            public boolean hasNext() {
                return this.pointer < this.size;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean add(long element) {
        this.checkCapacity(1);
        this.cache[this.end++] = element;
        return true;
    }

    public boolean remove(long element) {
        boolean anyRemove = false;
        if (this.size() > 0) {
            int index = 0;
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                long value = this.fastGet(i);
                if (element != value) {
                    this.cache[index++] = value;
                    continue;
                }
                anyRemove = true;
            }
            this.start = 0;
            this.end = index;
        }
        return anyRemove;
    }

    public void clear() {
        this.start = 0;
        this.end = 0;
    }

    public long removeByIndex(int index) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        int size = this.size();
        long value = this.fastGet(index);
        if (index == 0) {
            ++this.start;
        } else if (index == size - 1) {
            --this.end;
        } else if (index < size / 2) {
            for (int ind = this.start + index; ind >= this.start + 1; --ind) {
                this.cache[ind] = this.cache[ind - 1];
            }
            ++this.start;
        } else {
            for (int ind = this.start + index; ind < this.end - 1; ++ind) {
                this.cache[ind] = this.cache[ind + 1];
            }
            --this.end;
        }
        return value;
    }

    public boolean insert(int index, long value) {
        if (index < 0 || this.start + index > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        this.checkCapacity(1);
        if (this.start > 0) {
            int l = this.start + index;
            for (int i = this.start; i < l; ++i) {
                this.cache[i - 1] = this.fastGet(i);
            }
            --this.start;
        } else {
            int l = this.start + index;
            for (int i = this.end - 1; i >= l; --i) {
                this.cache[i + 1] = this.fastGet(i);
            }
            ++this.end;
        }
        this.cache[this.start + index] = value;
        return true;
    }

    public boolean addAll(long[] elements) {
        return this.addAll(elements, 0, elements.length);
    }

    public boolean addAll(long[] elements, int offset, int length) {
        Assert.that(elements != null);
        Assert.that(offset >= 0 && offset <= elements.length);
        Assert.that(length >= 0 && offset + length <= elements.length);
        this.checkCapacity(length);
        for (int i = offset; i < offset + length; ++i) {
            this.cache[this.end++] = elements[i];
        }
        return true;
    }

    public boolean addAll(LongList values2) {
        Assert.that(values2 != null);
        this.checkCapacity(values2.size());
        boolean addAnyValue = false;
        int l = values2.size();
        for (int i = 0; i < l; ++i) {
            this.cache[this.end++] = values2.fastGet(i);
            addAnyValue = true;
        }
        return addAnyValue;
    }

    public LongList subList(int fromIndex, int toIndex) {
        Assert.that(fromIndex >= 0 && fromIndex <= this.size());
        Assert.that(toIndex >= 0 && toIndex <= this.size());
        Assert.that(fromIndex <= toIndex);
        return LongList.wrap(this.cache, this.start + fromIndex, toIndex - fromIndex);
    }

    public boolean removeIf(ILongFilter condition) {
        int index = 0;
        boolean change = false;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            long value = this.fastGet(i);
            if (condition.filter(value)) {
                change = true;
                continue;
            }
            this.cache[index++] = value;
        }
        this.start = 0;
        this.end = index;
        return change;
    }

    public boolean retainIf(ILongFilter condition) {
        int index = 0;
        boolean change = false;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            long value = this.fastGet(i);
            if (condition.filter(value)) {
                this.cache[index++] = value;
                continue;
            }
            change = true;
        }
        this.start = 0;
        this.end = index;
        return change;
    }

    public long fastGet(int index) {
        return this.cache[this.start + index];
    }

    public long fastLastGet(int index) {
        return this.cache[this.end - index - 1];
    }

    public long fastSet(int index, long newValue) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        this.cache[this.start + index] = newValue;
        return newValue;
    }

    public long get(int index) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        return this.fastGet(index);
    }

    public long lastGet(int index) {
        return this.get(this.size() - 1 - index);
    }

    public long set(int index, long newValue) {
        if (index == this.size()) {
            this.add(newValue);
        } else {
            if (index < 0 || this.start + index >= this.end) {
                throw new ArrayIndexOutOfBoundsException("Index out of bounds");
            }
            this.cache[this.start + index] = newValue;
        }
        return newValue;
    }

    public long lastSet(int index, long newValue) {
        return this.set(this.end - index - 1, newValue);
    }

    public int hashCode() {
        int hashCode = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            hashCode = 31 * hashCode + Long.hashCode(this.fastGet(i));
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongList)) {
            return false;
        }
        LongList array = (LongList)o;
        if (this.cache == array.cache && this.start == array.start && this.end == array.end) {
            return true;
        }
        if (array.size() != this.size()) {
            return false;
        }
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (this.fastGet(i) == array.fastGet(i)) continue;
            return false;
        }
        return true;
    }

    public LongList clone() {
        return new LongList(this.cache, this.start, this.size());
    }

    public String toString() {
        TLongIterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            long e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public void dropDuplicates() {
        if (this.size() <= 1) {
            return;
        }
        TLongHashSet existsElements = new TLongHashSet();
        int index = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            long element = this.fastGet(i);
            if (existsElements.contains(element)) continue;
            existsElements.add(element);
            this.cache[index++] = element;
        }
        existsElements.clear();
        this.start = 0;
        this.end = index;
    }

    public void fill(long value, int size) {
        if (size > 0) {
            this.checkCapacity(size);
            for (int i = 0; i < size; ++i) {
                this.cache[this.end++] = value;
            }
        }
    }

    public void close() {
        this.start = 0;
        this.end = 0;
        this.cache = EmptyArray.LONG;
    }

    public int binarySearch(long key) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this.cache[this.start + mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int argmax() {
        if (this.size() == 0) {
            return -1;
        }
        long element = this.fastGet(0);
        int index = 0;
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (element >= this.fastGet(i)) continue;
            index = i;
        }
        return index;
    }

    public int argmin() {
        if (this.size() == 0) {
            return -1;
        }
        long element = this.fastGet(0);
        int index = 0;
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (element <= this.fastGet(i)) continue;
            index = i;
        }
        return index;
    }

    public long max() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        long maxValue = this.fastGet(0);
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (maxValue >= this.fastGet(i)) continue;
            maxValue = this.fastGet(i);
        }
        return maxValue;
    }

    public long min() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        long minValue = this.fastGet(0);
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (minValue <= this.fastGet(i)) continue;
            minValue = this.fastGet(i);
        }
        return minValue;
    }

    public long sum() {
        long sum = 0L;
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            sum += this.fastGet(i);
        }
        return sum;
    }

    public boolean all(ILongFilter rule) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (rule.filter(this.fastGet(i))) continue;
            return false;
        }
        return true;
    }

    public boolean any(ILongFilter rule) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!rule.filter(this.fastGet(i))) continue;
            return true;
        }
        return false;
    }

    public int count(ILongFilter rule) {
        int count = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!rule.filter(this.fastGet(i))) continue;
            ++count;
        }
        return count;
    }

    public TLongSet toSet() {
        TLongHashSet container = new TLongHashSet(this.size());
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            container.add(this.fastGet(i));
        }
        return container;
    }

    public TLongSet toUnmodifiableSet() {
        return TCollections.unmodifiableSet(this.toSet());
    }

    public IndexIterator where(ILongFilter function) {
        return new IndexIterator(this.size(), function == null ? null : index -> function.filter(this.fastGet(index)));
    }

    public LongList apply(TLongFunction function) {
        return this.apply(function, null);
    }

    public LongList apply(TLongFunction function, ILongFilter filter) {
        LongList result = new LongList(this.size());
        if (filter != null) {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                long value = function.execute(this.fastGet(i));
                if (!filter.filter(value)) continue;
                result.add(value);
            }
        } else {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                result.add(function.execute(this.fastGet(i)));
            }
        }
        return result;
    }

    public <V> List<V> apply(LongFunction<V> function) {
        return this.apply(function, null);
    }

    public <V> List<V> apply(LongFunction<V> function, IFilter<V> filter) {
        List<V> result = new List<V>(this.size());
        if (filter != null) {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                V value = function.apply(this.fastGet(i));
                if (!filter.filter(value)) continue;
                result.add(value);
            }
        } else {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                result.add(function.apply(this.fastGet(i)));
            }
        }
        return result;
    }

    public void applyInplace(TLongFunction function) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            this.cache[i] = function.execute(this.fastGet(i));
        }
        this.end = l;
        this.start = 0;
    }

    public LongList filter(ILongFilter filter) {
        LongList result = new LongList(1);
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            long c = this.fastGet(i);
            if (!filter.filter(c)) continue;
            result.add(c);
        }
        return result;
    }

    public void sort(int beginIndex, int endIndex) {
        Assert.that(beginIndex >= 0 && beginIndex <= this.size());
        Assert.that(endIndex >= beginIndex && endIndex <= this.size());
        Arrays.sort(this.cache, this.start + beginIndex, this.start + endIndex);
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public <V extends Comparable<V>> void sortWith(TLongObjectMap<V> values2) {
        if (this.size() > 0) {
            TObjectLongEntry[] indices = new TObjectLongEntry[this.size()];
            for (int i = 0; i < indices.length; ++i) {
                long element = this.fastGet(i);
                indices[i] = new TObjectLongEntry<V>(values2.get(element), element);
            }
            Arrays.sort(indices, Comparator.comparing(TObjectLongEntry::getKey));
            this.start = 0;
            this.end = 0;
            for (TObjectLongEntry index : indices) {
                this.cache[this.end++] = index.getValue();
            }
        }
    }

    public int indexOf(long element) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (element != this.fastGet(i)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIf(ILongFilter condition) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!condition.filter(this.fastGet(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long element) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (element != this.fastLastGet(i)) continue;
            return l - i - 1;
        }
        return -1;
    }

    public int lastIndexOfIf(ILongFilter condition) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!condition.filter(this.fastLastGet(i))) continue;
            return l - i - 1;
        }
        return -1;
    }

    public String toString(String joiner) {
        TLongIterator it = this.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            long e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.toString();
            }
            sb.append(joiner);
        }
    }

    public LongList asUnmodifiable() {
        return new LongList(){
            {
                this.cache = LongList.this.cache;
                this.start = LongList.this.start;
                this.end = LongList.this.end;
            }

            @Override
            public long popFirst() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long popLast() {
                throw new UnsupportedOperationException();
            }

            @Override
            public LongList popFirst(int size, boolean requireReturns) {
                throw new UnsupportedOperationException();
            }

            @Override
            public LongList popLast(int size, boolean requireReturns) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(long element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(long element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long removeByIndex(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean insert(int index, long value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(long[] elements) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(long[] elements, int offset, int length) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(LongList values2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeIf(ILongFilter condition) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainIf(ILongFilter condition) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long fastSet(int index, long newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long set(int index, long newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long lastSet(int index, long newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void dropDuplicates() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void applyInplace(TLongFunction function) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sort(int beginIndex, int endIndex) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sort() {
                throw new UnsupportedOperationException();
            }

            @Override
            public <V extends Comparable<V>> void sortWith(TLongObjectMap<V> values2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public LongList asUnmodifiable() {
                return this;
            }

            @Override
            public void shuffle(long seed) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void shuffle(long seed) {
        Random random = new Random(seed);
        for (int i = this.end - 1; i > this.start; --i) {
            int j = this.start + random.nextInt(i - this.start + 1);
            long temp = this.cache[i];
            this.cache[i] = this.cache[j];
            this.cache[j] = temp;
        }
    }
}

