/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.list;

import edu.sysu.pmglab.ccf.toolkit.filter.IShortFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.utils.Assert;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.TCollections;
import gnu.trove.function.TShortFunction;
import gnu.trove.iterator.TShortIterator;
import gnu.trove.set.TShortSet;
import gnu.trove.set.hash.TShortHashSet;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;

public class ShortList {
    short[] cache;
    int start = 0;
    int end = 0;

    public ShortList() {
        this(4);
    }

    public ShortList(int initialCapacity) {
        if (initialCapacity == 0) {
            this.cache = EmptyArray.SHORT;
        } else {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
            }
            this.cache = new short[initialCapacity];
        }
    }

    public ShortList(short[] values2) {
        this(values2, 0, values2.length);
    }

    public ShortList(short[] values2, int offset, int length) {
        this.cache = new short[values2.length];
        System.arraycopy(values2, offset, this.cache, 0, length);
        this.end = length;
    }

    public ShortList(Short[] values2) {
        this.cache = new short[values2.length];
        for (Short value : values2) {
            if (value == null) continue;
            this.cache[this.end++] = value;
        }
    }

    public ShortList(Iterable<Short> values2) {
        this.cache = new short[4];
        for (Short value : values2) {
            if (value == null) continue;
            this.add(value);
        }
    }

    public ShortList(TShortIterator values2) {
        this.cache = new short[4];
        while (values2.hasNext()) {
            this.add(values2.next());
        }
    }

    public static ShortList wrap(short ... src) {
        if (src == null || src.length == 0) {
            return new ShortList(0);
        }
        return ShortList.wrap(src, 0, src.length);
    }

    public static ShortList wrap(short[] src, int offset, int length) {
        Assert.that(src != null);
        Assert.that(offset >= 0 && offset <= src.length);
        Assert.that(length >= 0 && offset + length <= src.length);
        ShortList array = new ShortList(0);
        array.cache = src;
        array.start = offset;
        array.end = offset + length;
        return array;
    }

    public short popFirst() {
        if (this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Empty queue");
        }
        try {
            short s = this.fastGet(0);
            return s;
        }
        finally {
            ++this.start;
        }
    }

    public short popLast() {
        if (this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Empty queue");
        }
        try {
            short s = this.fastLastGet(0);
            return s;
        }
        finally {
            --this.end;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortList popFirst(int size, boolean requireReturns) {
        if (size < 0 || this.start + size > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        try {
            if (requireReturns) {
                ShortList returns = new ShortList(size);
                for (int i = 0; i < size; ++i) {
                    returns.add(this.fastGet(i));
                }
                ShortList shortList = returns;
                return shortList;
            }
            ShortList shortList = null;
            return shortList;
        }
        finally {
            this.start += size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortList popLast(int size, boolean requireReturns) {
        if (size < 0 || this.start + size > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        try {
            if (requireReturns) {
                ShortList returns = new ShortList(size);
                for (int i = size - 1; i >= 0; --i) {
                    returns.add(this.fastLastGet(i));
                }
                ShortList shortList = returns;
                return shortList;
            }
            ShortList shortList = null;
            return shortList;
        }
        finally {
            this.end -= size;
        }
    }

    private void checkCapacity(int writeSize) {
        this.expansion(writeSize - (this.cache.length - this.end));
    }

    private void expansion(long requestSize) {
        if (requestSize > 0L) {
            long newSize = requestSize + (long)(this.cache.length - this.start);
            if (newSize <= (long)this.cache.length) {
                int index = 0;
                int l = this.size();
                for (int i = 0; i < l; ++i) {
                    this.cache[index++] = this.fastGet(i);
                }
                this.start = 0;
                this.end = index;
                return;
            }
            if (newSize >= 0x7FFFFFFDL) {
                throw new OutOfMemoryError("Requested array size exceeds VM limit");
            }
            newSize = newSize < 16L ? 16L : (newSize <= 0x7FFFFFFL ? (newSize <<= 1) : ValueUtils.valueOf(newSize + (newSize >> 1), 0L, 0x7FFFFFFDL));
            short[] newCache = new short[(int)newSize];
            System.arraycopy(this.cache, this.start, newCache, 0, this.size());
            this.end -= this.start;
            this.start = 0;
            this.cache = newCache;
        }
    }

    public short[] toArray() {
        if (this.size() == 0) {
            return EmptyArray.SHORT;
        }
        return Arrays.copyOfRange(this.cache, this.start, this.end);
    }

    public short[] toArray(short[] dest) {
        if (dest.length < this.size()) {
            return Arrays.copyOfRange(this.cache, this.start, this.end);
        }
        System.arraycopy(this.cache, 0, dest, 0, this.size());
        if (dest.length > this.size()) {
            dest[this.size()] = 0;
        }
        return dest;
    }

    public int size() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(short element) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (element != this.fastGet(i)) continue;
            return true;
        }
        return false;
    }

    public TShortIterator iterator() {
        return new TShortIterator(){
            final int size;
            int pointer;
            {
                this.size = ShortList.this.size();
                this.pointer = 0;
            }

            @Override
            public short next() {
                return ShortList.this.fastGet(this.pointer++);
            }

            @Override
            public boolean hasNext() {
                return this.pointer < this.size;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean add(short element) {
        this.checkCapacity(1);
        this.cache[this.end++] = element;
        return true;
    }

    public boolean remove(short element) {
        boolean anyRemove = false;
        if (this.size() > 0) {
            int index = 0;
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                short value = this.fastGet(i);
                if (element != value) {
                    this.cache[index++] = value;
                    continue;
                }
                anyRemove = true;
            }
            this.start = 0;
            this.end = index;
        }
        return anyRemove;
    }

    public void clear() {
        this.start = 0;
        this.end = 0;
    }

    public short removeByIndex(int index) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        int size = this.size();
        short value = this.fastGet(index);
        if (index == 0) {
            ++this.start;
        } else if (index == size - 1) {
            --this.end;
        } else if (index < size / 2) {
            for (int ind = this.start + index; ind >= this.start + 1; --ind) {
                this.cache[ind] = this.cache[ind - 1];
            }
            ++this.start;
        } else {
            for (int ind = this.start + index; ind < this.end - 1; ++ind) {
                this.cache[ind] = this.cache[ind + 1];
            }
            --this.end;
        }
        return value;
    }

    public boolean insert(int index, short value) {
        if (index < 0 || this.start + index > this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        this.checkCapacity(1);
        if (this.start > 0) {
            int l = this.start + index;
            for (int i = this.start; i < l; ++i) {
                this.cache[i - 1] = this.fastGet(i);
            }
            --this.start;
        } else {
            int l = this.start + index;
            for (int i = this.end - 1; i >= l; --i) {
                this.cache[i + 1] = this.fastGet(i);
            }
            ++this.end;
        }
        this.cache[this.start + index] = value;
        return true;
    }

    public boolean addAll(short[] elements) {
        return this.addAll(elements, 0, elements.length);
    }

    public boolean addAll(short[] elements, int offset, int length) {
        Assert.that(elements != null);
        Assert.that(offset >= 0 && offset <= elements.length);
        Assert.that(length >= 0 && offset + length <= elements.length);
        this.checkCapacity(length);
        for (int i = offset; i < offset + length; ++i) {
            this.cache[this.end++] = elements[i];
        }
        return true;
    }

    public boolean addAll(ShortList values2) {
        Assert.that(values2 != null);
        this.checkCapacity(values2.size());
        boolean addAnyValue = false;
        int l = values2.size();
        for (int i = 0; i < l; ++i) {
            this.cache[this.end++] = values2.fastGet(i);
            addAnyValue = true;
        }
        return addAnyValue;
    }

    public ShortList subList(int fromIndex, int toIndex) {
        Assert.that(fromIndex >= 0 && fromIndex <= this.size());
        Assert.that(toIndex >= 0 && toIndex <= this.size());
        Assert.that(fromIndex <= toIndex);
        return ShortList.wrap(this.cache, this.start + fromIndex, toIndex - fromIndex);
    }

    public boolean removeIf(IShortFilter condition) {
        int index = 0;
        boolean change = false;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            short value = this.fastGet(i);
            if (condition.filter(value)) {
                change = true;
                continue;
            }
            this.cache[index++] = value;
        }
        this.start = 0;
        this.end = index;
        return change;
    }

    public boolean retainIf(IShortFilter condition) {
        int index = 0;
        boolean change = false;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            short value = this.fastGet(i);
            if (condition.filter(value)) {
                this.cache[index++] = value;
                continue;
            }
            change = true;
        }
        this.start = 0;
        this.end = index;
        return change;
    }

    public short fastGet(int index) {
        return this.cache[this.start + index];
    }

    public short fastLastGet(int index) {
        return this.cache[this.end - index - 1];
    }

    public short fastSet(int index, short newValue) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        this.cache[this.start + index] = newValue;
        return newValue;
    }

    public short get(int index) {
        if (index < 0 || this.start + index >= this.end) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
        return this.fastGet(index);
    }

    public short lastGet(int index) {
        return this.get(this.size() - 1 - index);
    }

    public short set(int index, short newValue) {
        if (index == this.size()) {
            this.add(newValue);
        } else {
            if (index < 0 || this.start + index >= this.end) {
                throw new ArrayIndexOutOfBoundsException("Index out of bounds");
            }
            this.cache[this.start + index] = newValue;
        }
        return newValue;
    }

    public short lastSet(int index, short newValue) {
        return this.set(this.end - index - 1, newValue);
    }

    public int hashCode() {
        int hashCode = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            hashCode = 31 * hashCode + Short.hashCode(this.fastGet(i));
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShortList)) {
            return false;
        }
        ShortList array = (ShortList)o;
        if (this.cache == array.cache && this.start == array.start && this.end == array.end) {
            return true;
        }
        if (array.size() != this.size()) {
            return false;
        }
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (this.fastGet(i) == array.fastGet(i)) continue;
            return false;
        }
        return true;
    }

    public ShortList clone() {
        return new ShortList(this.cache, this.start, this.size());
    }

    public String toString() {
        TShortIterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            short e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public void dropDuplicates() {
        if (this.size() <= 1) {
            return;
        }
        TShortHashSet existsElements = new TShortHashSet();
        int index = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            short element = this.fastGet(i);
            if (existsElements.contains(element)) continue;
            existsElements.add(element);
            this.cache[index++] = element;
        }
        existsElements.clear();
        this.start = 0;
        this.end = index;
    }

    public void fill(short value, int size) {
        if (size > 0) {
            this.checkCapacity(size);
            for (int i = 0; i < size; ++i) {
                this.cache[this.end++] = value;
            }
        }
    }

    public void close() {
        this.start = 0;
        this.end = 0;
        this.cache = EmptyArray.SHORT;
    }

    public int binarySearch(short key) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            short midVal = this.cache[this.start + mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int argmax() {
        if (this.size() == 0) {
            return -1;
        }
        short element = this.fastGet(0);
        int index = 0;
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (element >= this.fastGet(i)) continue;
            index = i;
        }
        return index;
    }

    public int argmin() {
        if (this.size() == 0) {
            return -1;
        }
        short element = this.fastGet(0);
        int index = 0;
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (element <= this.fastGet(i)) continue;
            index = i;
        }
        return index;
    }

    public short max() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        short maxValue = this.fastGet(0);
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (maxValue >= this.fastGet(i)) continue;
            maxValue = this.fastGet(i);
        }
        return maxValue;
    }

    public short min() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        short minValue = this.fastGet(0);
        int l = this.size();
        for (int i = 1; i < l; ++i) {
            if (minValue <= this.fastGet(i)) continue;
            minValue = this.fastGet(i);
        }
        return minValue;
    }

    public boolean all(IShortFilter rule) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (rule.filter(this.fastGet(i))) continue;
            return false;
        }
        return true;
    }

    public boolean any(IShortFilter rule) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!rule.filter(this.fastGet(i))) continue;
            return true;
        }
        return false;
    }

    public int count(IShortFilter rule) {
        int count = 0;
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!rule.filter(this.fastGet(i))) continue;
            ++count;
        }
        return count;
    }

    public TShortSet toSet() {
        TShortHashSet container = new TShortHashSet(this.size());
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            container.add(this.fastGet(i));
        }
        return container;
    }

    public TShortSet toUnmodifiableSet() {
        return TCollections.unmodifiableSet(this.toSet());
    }

    public IndexIterator where(IShortFilter function) {
        return new IndexIterator(this.size(), function == null ? null : index -> function.filter(this.fastGet(index)));
    }

    public ShortList apply(TShortFunction function) {
        return this.apply(function, null);
    }

    public ShortList apply(TShortFunction function, IShortFilter filter) {
        ShortList result = new ShortList(this.size());
        if (filter != null) {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                short value = function.execute(this.fastGet(i));
                if (!filter.filter(value)) continue;
                result.add(value);
            }
        } else {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                result.add(function.execute(this.fastGet(i)));
            }
        }
        return result;
    }

    public void applyInplace(TShortFunction function) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            this.cache[i] = function.execute(this.fastGet(i));
        }
        this.end = l;
        this.start = 0;
    }

    public ShortList filter(IShortFilter filter) {
        ShortList result = new ShortList(1);
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            short c = this.fastGet(i);
            if (!filter.filter(c)) continue;
            result.add(c);
        }
        return result;
    }

    public void sort(int beginIndex, int endIndex) {
        Assert.that(beginIndex >= 0 && beginIndex <= this.size());
        Assert.that(endIndex >= beginIndex && endIndex <= this.size());
        Arrays.sort(this.cache, this.start + beginIndex, this.start + endIndex);
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public int indexOf(short element) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (element != this.fastGet(i)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIf(IShortFilter condition) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!condition.filter(this.fastGet(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(short element) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (element != this.fastLastGet(i)) continue;
            return l - i - 1;
        }
        return -1;
    }

    public int lastIndexOfIf(IShortFilter condition) {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            if (!condition.filter(this.fastLastGet(i))) continue;
            return l - i - 1;
        }
        return -1;
    }

    public String toString(String joiner) {
        TShortIterator it = this.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            short e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.toString();
            }
            sb.append(joiner);
        }
    }

    public ShortList asUnmodifiable() {
        return new ShortList(){
            {
                this.cache = ShortList.this.cache;
                this.start = ShortList.this.start;
                this.end = ShortList.this.end;
            }

            @Override
            public short popFirst() {
                throw new UnsupportedOperationException();
            }

            @Override
            public short popLast() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ShortList popFirst(int size, boolean requireReturns) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ShortList popLast(int size, boolean requireReturns) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(short element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(short element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public short removeByIndex(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean insert(int index, short value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(short[] elements) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(short[] elements, int offset, int length) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(ShortList values2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeIf(IShortFilter condition) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainIf(IShortFilter condition) {
                throw new UnsupportedOperationException();
            }

            @Override
            public short fastSet(int index, short newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public short set(int index, short newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public short lastSet(int index, short newValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void dropDuplicates() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void applyInplace(TShortFunction function) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sort(int beginIndex, int endIndex) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sort() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ShortList asUnmodifiable() {
                return this;
            }

            @Override
            public void shuffle(long seed) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void shuffle(long seed) {
        Random random = new Random(seed);
        for (int i = this.end - 1; i > this.start; --i) {
            int j = this.start + random.nextInt(i - this.start + 1);
            short temp = this.cache[i];
            this.cache[i] = this.cache[j];
            this.cache[j] = temp;
        }
    }
}

