/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.pointer;

import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.ValueUtils;

public final class Pointer
implements Cloneable {
    private final long END;
    private final long[] RANGE;
    private volatile long current = 0L;

    public Pointer(long numOfRecords) {
        this.END = Math.max(0L, numOfRecords);
        this.RANGE = new long[]{0L, this.END};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long tell() {
        Pointer pointer = this;
        synchronized (pointer) {
            return this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pointer next() {
        Pointer pointer = this;
        synchronized (pointer) {
            if (this.current < this.RANGE[1]) {
                ++this.current;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        Pointer pointer = this;
        synchronized (pointer) {
            return this.current < this.RANGE[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long remaining() {
        Pointer pointer = this;
        synchronized (pointer) {
            return this.RANGE[1] - this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pointer seek(long pointer) {
        Pointer pointer2 = this;
        synchronized (pointer2) {
            this.current = pointer < this.RANGE[0] ? this.RANGE[0] : (pointer > this.RANGE[1] ? this.RANGE[1] : pointer);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongInterval available() {
        Pointer pointer = this;
        synchronized (pointer) {
            return new LongInterval(this.RANGE[0], this.RANGE[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pointer> part(int nParts) {
        Pointer pointer = this;
        synchronized (pointer) {
            long remaining = this.RANGE[1] - this.current;
            if (remaining <= 0L) {
                return List.EMPTY();
            }
            long start = this.current;
            if ((long)(nParts = Math.max(1, nParts)) > remaining) {
                nParts = (int)remaining;
            }
            List<Pointer> pointers = new List<Pointer>(nParts);
            long partitionSize = remaining / (long)nParts;
            long remainder = remaining % (long)nParts;
            long end = start + partitionSize;
            for (int i = 0; i < nParts; ++i) {
                if ((long)i < remainder) {
                    ++end;
                }
                pointers.add(new Pointer(this.END).limit(start, end));
                start = end;
                end = start + partitionSize;
            }
            return pointers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pointer clearLimit() {
        Pointer pointer = this;
        synchronized (pointer) {
            this.RANGE[0] = 0L;
            this.RANGE[1] = this.END;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pointer limit(long min, long max) {
        Pointer pointer = this;
        synchronized (pointer) {
            min = ValueUtils.valueOf(min, 0L, this.END);
            max = ValueUtils.valueOf(max, min, this.END);
            this.RANGE[0] = min;
            this.RANGE[1] = max;
            if (this.current < min) {
                this.current = min;
            } else if (this.current > max) {
                this.current = max;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pointer limit(LongInterval interval) {
        Pointer pointer = this;
        synchronized (pointer) {
            if (interval == null) {
                this.RANGE[0] = 0L;
                this.RANGE[1] = 0L;
                this.current = 0L;
            } else {
                long min = ValueUtils.valueOf(interval.start(), 0L, this.END);
                long max = ValueUtils.valueOf(interval.end(), min, this.END);
                this.RANGE[0] = min;
                this.RANGE[1] = max;
                if (this.current < min) {
                    this.current = min;
                } else if (this.current > max) {
                    this.current = max;
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLimited() {
        Pointer pointer = this;
        synchronized (pointer) {
            return this.RANGE[0] != 0L || this.RANGE[1] != this.END;
        }
    }

    public Pointer clone() {
        return new Pointer(this.END).limit(this.RANGE[0], this.RANGE[1]).seek(this.current);
    }
}

