/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.rangelist;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import gnu.trove.iterator.TIntIterator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.concurrent.atomic.AtomicLong;

public class VarInt32RangeList
implements RandomAccess {
    private static final Comparator<Bucket> COMPARATOR = new Comparator<Bucket>(){
        final Comparator<Bucket> comparator = Comparator.comparingLong(o -> o.start).thenComparingLong(o -> o.end);

        @Override
        public int compare(Bucket o1, Bucket o2) {
            if (o1.start > o1.end) {
                return -1;
            }
            if (o2.start > o2.end) {
                return 1;
            }
            return this.comparator.compare(o1, o2);
        }
    };
    private final AtomicLong size;
    private final List<Bucket> buckets;

    public VarInt32RangeList() {
        this.size = new AtomicLong(0L);
        this.buckets = new List();
    }

    private VarInt32RangeList(AtomicLong size, List<Bucket> buckets) {
        this.size = size;
        this.buckets = buckets;
    }

    public static VarInt32RangeList decode(int[] arrays) {
        if (arrays == null || arrays.length == 0) {
            return new VarInt32RangeList();
        }
        if (arrays.length % 3 != 0) {
            throw new UnsupportedOperationException("[start, end, count] ...");
        }
        VarInt32RangeList list = new VarInt32RangeList();
        for (int i = 0; i < arrays.length / 3; ++i) {
            int start = arrays[i * 3];
            int end = arrays[1 + i * 3];
            int count = arrays[2 + i * 3];
            list.buckets.add(new Bucket(start, end, count));
            list.size.addAndGet((long)count * ((long)(end - start) + 1L));
        }
        return list;
    }

    public static VarInt32RangeList decode(Bytes byteCode) {
        VarInt32RangeList list = new VarInt32RangeList();
        ByteStream reader = byteCode.toByteStream();
        while (reader.rRemaining() > 0) {
            int start = reader.getVarInt32();
            int end = reader.getVarInt32();
            long count = reader.getVarInt64();
            list.buckets.add(new Bucket(start, end, count));
            list.size.addAndGet(count * ((long)(end - start) + 1L));
        }
        reader.close();
        return list;
    }

    public void sort() {
        Bucket bucket;
        if (this.buckets.size() == 0) {
            return;
        }
        this.buckets.sort(COMPARATOR);
        boolean ordered = true;
        if (this.buckets.fastGet((int)0).start == this.buckets.fastGet((int)0).end || this.buckets.fastGet((int)0).count == 1L) {
            for (int bucketIndex = 1; bucketIndex < this.buckets.size(); ++bucketIndex) {
                bucket = this.buckets.fastGet(bucketIndex);
                if (bucket.start != bucket.end && bucket.count > 1L) {
                    ordered = false;
                } else {
                    if (bucket.start >= this.buckets.fastGet((int)(bucketIndex - 1)).end) continue;
                    ordered = false;
                }
                break;
            }
        } else {
            ordered = false;
        }
        if (ordered) {
            return;
        }
        VarInt32RangeList target = new VarInt32RangeList();
        block1: while (this.buckets.size() > 0) {
            if (this.buckets.size() == 1 || this.buckets.fastGet((int)0).end <= this.buckets.fastGet((int)1).start) {
                bucket = this.buckets.fastGet(0);
                if (bucket.count == 1L) {
                    target.add0(bucket.start, bucket.end, bucket.count);
                } else {
                    for (int value = bucket.start; value <= bucket.end; ++value) {
                        target.add0(value, bucket.count);
                    }
                }
                this.buckets.popFirst();
                continue;
            }
            int dupStartCount = 1;
            Bucket firstBucket = this.buckets.fastGet(0);
            for (int bucketIndex = 1; bucketIndex < this.buckets.size(); ++bucketIndex) {
                Bucket bucket2 = this.buckets.fastGet(bucketIndex);
                if (bucket2.start != firstBucket.start) break;
                ++dupStartCount;
            }
            if (dupStartCount == 1) {
                Bucket secondBucket = this.buckets.fastGet(1);
                if (firstBucket.count == 1L) {
                    target.add0(firstBucket.start, secondBucket.start - 1, firstBucket.count);
                } else {
                    for (int value = firstBucket.start; value <= secondBucket.start - 1; ++value) {
                        target.add0(value, firstBucket.count);
                    }
                }
                firstBucket.start = secondBucket.start;
                if (firstBucket.start > firstBucket.end) {
                    this.buckets.popFirst();
                    continue;
                }
                dupStartCount = 2;
                for (int bucketIndex = 2; bucketIndex < this.buckets.size(); ++bucketIndex) {
                    Bucket bucket3 = this.buckets.fastGet(bucketIndex);
                    if (bucket3.start != firstBucket.start) break;
                    ++dupStartCount;
                }
                this.buckets.sort(COMPARATOR, 0, dupStartCount);
                continue;
            }
            int maxValue = firstBucket.end;
            int value = firstBucket.start;
            for (int bucketIndex = 1; bucketIndex < dupStartCount; ++bucketIndex) {
                Bucket bucket4 = this.buckets.fastGet(bucketIndex);
                if (bucket4.end >= maxValue) continue;
                maxValue = bucket4.end;
            }
            for (int storedValue = value; storedValue <= maxValue; ++storedValue) {
                for (int bucketIndex = 0; bucketIndex < dupStartCount; ++bucketIndex) {
                    Bucket bucket5 = this.buckets.fastGet(bucketIndex);
                    target.add0(storedValue, bucket5.count);
                    ++bucket5.start;
                }
            }
            this.buckets.sort(COMPARATOR, 0, dupStartCount);
            for (int i = 0; i < dupStartCount; ++i) {
                Bucket bucket6 = this.buckets.fastGet(0);
                if (bucket6.start <= bucket6.end) continue block1;
                this.buckets.popFirst();
            }
        }
        this.buckets.addAll(target.buckets);
    }

    public int get(long index) {
        if (index >= 0L && index < this.size.get()) {
            long count = 0L;
            for (Bucket bucket : this.buckets) {
                long rangeSize = bucket.getEnd() - bucket.getStart() + 1L;
                long rangeCount = rangeSize * bucket.getCount();
                if (index < count + rangeCount) {
                    return (int)((long)bucket.start + (index - count) % rangeSize);
                }
                count += rangeCount;
            }
        }
        throw new ArrayIndexOutOfBoundsException(String.valueOf(index));
    }

    private VarInt32RangeList add0(int varInt, long times) {
        if (times >= 1L) {
            if (this.buckets.size() == 0) {
                this.buckets.add(new Bucket(varInt, varInt, times));
            } else {
                Bucket lastBucket = this.buckets.fastLastGet(0);
                if (lastBucket.count == 1L && times == 1L && lastBucket.end + 1 == varInt) {
                    ++lastBucket.end;
                    if (this.buckets.size() >= 2 && this.buckets.fastLastGet((int)1).start == lastBucket.start && this.buckets.fastLastGet((int)1).end == lastBucket.end) {
                        this.buckets.popLast();
                        ++this.buckets.fastLastGet((int)0).count;
                    }
                } else if (lastBucket.end == varInt && lastBucket.start == varInt) {
                    lastBucket.count += times;
                } else {
                    this.buckets.add(new Bucket(varInt, varInt, times));
                }
            }
        }
        return this;
    }

    private VarInt32RangeList add0(int start, int end, long times) {
        Assert.that(start <= end);
        if (times >= 1L) {
            if (this.buckets.size() == 0) {
                this.buckets.add(new Bucket(start, end, times));
            } else {
                Bucket lastBucket = this.buckets.fastLastGet(0);
                if (times == 1L && lastBucket.count == 1L && lastBucket.end + 1 == start) {
                    lastBucket.end = end;
                    if (this.buckets.size() >= 2 && this.buckets.fastLastGet((int)1).start == lastBucket.start && this.buckets.fastLastGet((int)1).end == lastBucket.end) {
                        this.buckets.popLast();
                        ++this.buckets.fastLastGet((int)0).count;
                    }
                } else if (lastBucket.end == end && lastBucket.start == start) {
                    lastBucket.count += times;
                } else {
                    this.buckets.add(new Bucket(start, end, times));
                }
            }
        }
        return this;
    }

    public VarInt32RangeList add(int varInt) {
        if (this.size.get() == Long.MAX_VALUE) {
            throw new OutOfMemoryError("Requested array size exceeds VM limit");
        }
        try {
            if (this.buckets.size() == 0) {
                this.buckets.add(new Bucket(varInt, varInt));
            } else {
                Bucket lastBucket = this.buckets.fastLastGet(0);
                if (lastBucket.end + 1 == varInt && lastBucket.count == 1L) {
                    ++lastBucket.end;
                    if (this.buckets.size() >= 2 && this.buckets.fastLastGet((int)1).start == lastBucket.start && this.buckets.fastLastGet((int)1).end == lastBucket.end) {
                        this.buckets.popLast();
                        ++this.buckets.fastLastGet((int)0).count;
                    }
                } else if (lastBucket.end == varInt && lastBucket.start == varInt) {
                    ++lastBucket.count;
                } else {
                    this.buckets.add(new Bucket(varInt, varInt));
                }
            }
            VarInt32RangeList varInt32RangeList = this;
            return varInt32RangeList;
        }
        finally {
            this.size.addAndGet(1L);
        }
    }

    public VarInt32RangeList adds(int[] varInts) {
        for (int value : varInts) {
            this.add(value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VarInt32RangeList adds(VarInt32RangeList varInts) {
        if (varInts.size() == 0L) {
            return this;
        }
        if (this.size.get() + varInts.size() <= 0L) {
            throw new OutOfMemoryError("Requested array size exceeds VM limit");
        }
        try {
            if (this.buckets.size() == 0) {
                for (Bucket bucket : varInts.buckets) {
                    this.buckets.add(new Bucket(bucket.start, bucket.end, bucket.count));
                }
            } else if (this.buckets.fastLastGet((int)0).start == varInts.buckets.fastGet((int)0).start && this.buckets.fastLastGet((int)0).end == varInts.buckets.fastGet((int)0).end) {
                this.buckets.fastLastGet((int)0).count += varInts.buckets.fastGet((int)0).count;
                for (int i = 1; i < varInts.buckets.size(); ++i) {
                    Bucket bucket = varInts.buckets.fastGet(i);
                    this.buckets.add(new Bucket(bucket.start, bucket.end, bucket.count));
                }
            } else if (this.buckets.fastLastGet((int)0).end + 1 == varInts.buckets.fastGet((int)0).start && this.buckets.fastLastGet((int)0).count == 1L && varInts.buckets.fastGet((int)0).count == 1L) {
                this.buckets.fastLastGet((int)0).end = varInts.buckets.fastGet((int)0).end;
                for (int i = 1; i < varInts.buckets.size(); ++i) {
                    Bucket bucket = varInts.buckets.fastGet(i);
                    this.buckets.add(new Bucket(bucket.start, bucket.end, bucket.count));
                }
            } else {
                for (Bucket bucket : varInts.buckets) {
                    this.buckets.add(new Bucket(bucket.start, bucket.end, bucket.count));
                }
            }
            VarInt32RangeList varInt32RangeList = this;
            return varInt32RangeList;
        }
        finally {
            this.size.addAndGet(varInts.size());
        }
    }

    public VarInt32RangeList addInterval(IntInterval values2) {
        return this.addInterval(values2.start(), values2.end());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VarInt32RangeList addInterval(int start, int end) {
        if (start > end) {
            throw new NullPointerException();
        }
        if (start == end) {
            return this.add(start);
        }
        long length = (long)end - (long)start + 1L;
        if (length <= 0L) {
            throw new OutOfMemoryError("Requested array size exceeds VM limit");
        }
        if (this.size.get() + length <= 0L) {
            throw new OutOfMemoryError("Requested array size exceeds VM limit");
        }
        try {
            if (this.buckets.size() == 0) {
                this.buckets.add(new Bucket(start, end));
            } else if (this.buckets.fastLastGet((int)0).end + 1 == start && this.buckets.fastLastGet((int)0).count == 1L) {
                this.buckets.fastLastGet((int)0).end = end;
            } else if (this.buckets.fastLastGet((int)0).start == start && this.buckets.fastLastGet((int)0).end <= end) {
                ++this.buckets.fastLastGet((int)0).count;
                if (this.buckets.fastLastGet((int)0).end < end) {
                    this.buckets.add(new Bucket(this.buckets.fastLastGet((int)0).end + 1, end));
                }
            } else {
                this.buckets.add(new Bucket(start, end));
            }
            VarInt32RangeList varInt32RangeList = this;
            return varInt32RangeList;
        }
        finally {
            this.size.addAndGet(length);
        }
    }

    public long size() {
        return this.size.get();
    }

    public boolean contains(int pointer) {
        for (Bucket interval : this.buckets) {
            if (interval.start > pointer || interval.end < pointer) continue;
            return true;
        }
        return false;
    }

    public long[] encode() {
        int resLength = 0;
        long[] returns = new long[this.buckets.size() * 3];
        for (int bucketIndex = 0; bucketIndex < this.buckets.size(); ++bucketIndex) {
            returns[resLength] = this.buckets.fastGet((int)bucketIndex).start;
            returns[resLength + 1] = this.buckets.fastGet((int)bucketIndex).end;
            returns[resLength + 2] = this.buckets.fastGet((int)bucketIndex).count;
            int secondBucketIndex = bucketIndex + 1;
            while (secondBucketIndex < this.buckets.size() && this.buckets.fastGet(bucketIndex).equals(this.buckets.fastGet(secondBucketIndex))) {
                int n = resLength + 2;
                returns[n] = returns[n] + this.buckets.fastGet((int)secondBucketIndex).count;
                bucketIndex = secondBucketIndex++;
            }
            resLength += 3;
        }
        if (resLength < returns.length) {
            return Arrays.copyOfRange(returns, 0, resLength);
        }
        return returns;
    }

    public int encodeTo(ByteStream container) {
        int length = 0;
        container.rRequire(this.buckets.size() * 5);
        for (int bucketIndex = 0; bucketIndex < this.buckets.size(); ++bucketIndex) {
            int start = this.buckets.fastGet((int)bucketIndex).start;
            int end = this.buckets.fastGet((int)bucketIndex).end;
            long count = this.buckets.fastGet((int)bucketIndex).count;
            int secondBucketIndex = bucketIndex + 1;
            while (secondBucketIndex < this.buckets.size() && this.buckets.fastGet(bucketIndex).equals(this.buckets.fastGet(secondBucketIndex))) {
                count += this.buckets.fastGet((int)secondBucketIndex).count;
                bucketIndex = secondBucketIndex++;
            }
            length += container.putVarInt32(start);
            length += container.putVarInt32(end);
            length += container.putVarInt64(count);
        }
        return length;
    }

    public VarInt32RangeList clear() {
        this.buckets.clear();
        this.size.set(0L);
        return this;
    }

    public TIntIterator iterator() {
        return new TIntIterator(){
            private final Iterator<Bucket> outerIterator;
            private TIntIterator innerIterator;
            {
                this.outerIterator = VarInt32RangeList.this.buckets.iterator();
                this.innerIterator = null;
            }

            @Override
            public boolean hasNext() {
                while ((this.innerIterator == null || !this.innerIterator.hasNext()) && this.outerIterator.hasNext()) {
                    this.innerIterator = this.outerIterator.next().iterator();
                }
                return this.innerIterator != null && this.innerIterator.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.innerIterator.next();
            }
        };
    }

    public IntList toIntList() {
        if (this.size() >= 0x7FFFFFFDL) {
            throw new OutOfMemoryError();
        }
        IntList list = new IntList((int)this.size());
        for (Bucket bucket : this.buckets) {
            int i = 0;
            while ((long)i < bucket.count) {
                for (int value = bucket.start; value <= bucket.end; ++value) {
                    list.add(value);
                }
                ++i;
            }
        }
        return list;
    }

    public String toString() {
        return this.toBytes().toString();
    }

    public Bytes toBytes() {
        if (this.size.get() == 0L) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ByteStream.getThreadInstance();
        Iterator<Bucket> iterator2 = this.buckets.iterator();
        boolean next = false;
        while (iterator2.hasNext()) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.writeChar(iterator2.next().toString());
        }
        return builder.toBytes(true);
    }

    public VarInt32RangeList asUnmodifiable() {
        return new VarInt32RangeList(this.size, this.buckets){

            @Override
            public VarInt32RangeList add(int varInt) {
                throw new UnsupportedOperationException();
            }

            @Override
            public VarInt32RangeList adds(int[] varInts) {
                throw new UnsupportedOperationException();
            }

            @Override
            public VarInt32RangeList addInterval(IntInterval values2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public VarInt32RangeList addInterval(int start, int end) {
                throw new UnsupportedOperationException();
            }

            @Override
            public VarInt32RangeList clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public VarInt32RangeList asUnmodifiable() {
                return this;
            }
        };
    }

    private static class Bucket
    implements Comparable<Bucket> {
        int start;
        int end;
        long count;

        public Bucket(int start, int end) {
            this.start = start;
            this.end = end;
            this.count = 1L;
            Assert.that(this.start <= this.end);
        }

        public Bucket(int start, int end, long count) {
            Assert.that(count >= 1L);
            this.start = start;
            this.end = end;
            this.count = count;
            Assert.that(this.start <= this.end);
        }

        public long getEnd() {
            return this.end;
        }

        public long getStart() {
            return this.start;
        }

        public long getCount() {
            return this.count;
        }

        public TIntIterator iterator() {
            return new TIntIterator(){
                int c = 0;
                int p;
                {
                    this.p = start;
                }

                @Override
                public boolean hasNext() {
                    return (long)this.c < count;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int next() {
                    try {
                        int n = this.p;
                        return n;
                    }
                    finally {
                        ++this.p;
                        if (this.p > end) {
                            ++this.c;
                            this.p = start;
                        }
                    }
                }
            };
        }

        public String toString() {
            if (this.start == this.end) {
                if (this.count == 1L) {
                    return String.valueOf(this.start);
                }
                StringBuilder builder = new StringBuilder();
                int i = 0;
                while ((long)i < this.count - 1L) {
                    builder.append(this.start);
                    builder.append(",");
                    ++i;
                }
                builder.append(this.start);
                return builder.toString();
            }
            String v = this.start + "~" + this.end;
            if (this.count == 1L) {
                return v;
            }
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while ((long)i < this.count - 1L) {
                builder.append(v);
                builder.append(",");
                ++i;
            }
            builder.append(v);
            return builder.toString();
        }

        public boolean equals(Bucket obj) {
            return this.start == obj.start && this.end == obj.end;
        }

        @Override
        public int compareTo(Bucket o) {
            int status = Long.compare(this.start, o.start);
            if (status == 0) {
                status = Long.compare(this.end, o.end);
            }
            return status;
        }
    }
}

