/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.container.sparsearray;

import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.iterator.TByteIterator;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class SparseByteArray {
    final byte defaultValue;
    final byte[][] buckets;
    final int size;
    final int BUCKET_MASK;
    final int BUCKET_SIZE;
    final int VALUE_MASK;

    public SparseByteArray(int size) {
        this(size, 0, 6);
    }

    public SparseByteArray(int size, byte defaultValue) {
        this(size, defaultValue, 6);
    }

    public SparseByteArray(int size, byte defaultValue, int mask) {
        if (size < 0) {
            throw new IllegalArgumentException("size must >= 0");
        }
        this.size = size;
        this.defaultValue = defaultValue;
        mask = ValueUtils.valueOf(mask, 3, 30);
        int bucketSize = 1 << mask;
        if (size == 0) {
            this.BUCKET_MASK = mask;
            this.BUCKET_SIZE = 0;
            this.VALUE_MASK = -1;
            this.buckets = new byte[0][0];
            return;
        }
        if (size >= 8 && bucketSize > size) {
            mask = 32 - Integer.numberOfLeadingZeros(size - 1);
            bucketSize = 1 << mask;
        }
        this.BUCKET_MASK = mask;
        this.BUCKET_SIZE = bucketSize;
        this.VALUE_MASK = bucketSize - 1;
        this.buckets = new byte[(size - 1 >> this.BUCKET_MASK) + 1][];
    }

    public byte getDefaultValue() {
        return this.defaultValue;
    }

    public int size() {
        return this.size;
    }

    public void set(int key, byte value) {
        if (key < 0 || key >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(key));
        }
        int bucketIndex = key >> this.BUCKET_MASK;
        byte[] values2 = this.buckets[bucketIndex];
        if (values2 == null) {
            if (value == this.defaultValue) {
                return;
            }
            if (bucketIndex == this.buckets.length - 1) {
                int res = this.size & this.VALUE_MASK;
                if (res == 0) {
                    values2 = new byte[this.BUCKET_SIZE];
                    this.buckets[bucketIndex] = values2;
                } else {
                    values2 = new byte[this.size & this.VALUE_MASK];
                    this.buckets[bucketIndex] = values2;
                }
            } else {
                values2 = new byte[this.BUCKET_SIZE];
                this.buckets[bucketIndex] = values2;
            }
            if (this.defaultValue != 0) {
                Arrays.fill(values2, this.defaultValue);
            }
        }
        values2[key & this.VALUE_MASK] = value;
    }

    public byte get(int key) {
        if (key < 0 || key >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(key));
        }
        byte[] values2 = this.buckets[key >> this.BUCKET_MASK];
        if (values2 == null) {
            return this.defaultValue;
        }
        return values2[key & this.VALUE_MASK];
    }

    public void clear() {
        for (byte[] values2 : this.buckets) {
            if (values2 == null) continue;
            Arrays.fill(values2, this.defaultValue);
        }
    }

    public void deepClear() {
        Arrays.fill((Object[])this.buckets, null);
    }

    public byte[] compact() {
        byte[] values2 = new byte[this.size];
        for (int i = 0; i < this.buckets.length; ++i) {
            int start = i * this.BUCKET_SIZE;
            int end = Math.min(start + this.BUCKET_SIZE, this.size);
            if (this.buckets[i] == null) {
                if (this.defaultValue == 0) continue;
                Arrays.fill(values2, start, end, this.defaultValue);
                continue;
            }
            System.arraycopy(this.buckets[i], 0, values2, start, end - start);
        }
        return values2;
    }

    public TByteIterator iterator() {
        return new TByteIterator(){
            int index = 0;

            @Override
            public byte next() {
                if (this.index < SparseByteArray.this.size) {
                    return SparseByteArray.this.get(this.index++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.index < SparseByteArray.this.size;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

