/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.executor;

import edu.sysu.pmglab.executor.ErrorPolicy;
import edu.sysu.pmglab.executor.IExecutor;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Pipeline;
import java.util.Iterator;

public class Executor
extends IExecutor<Executor>
implements Iterable<ITask> {
    final Pipeline.Builder builder = new Pipeline.Builder();

    @Override
    public Executor addTask(Pipeline pipeline) {
        this.LOCK.lock();
        if (pipeline != null) {
            this.builder.add(pipeline);
        }
        this.LOCK.unlock();
        return this;
    }

    @Override
    public Executor addTask(ITask task) {
        this.LOCK.lock();
        if (task != null) {
            this.builder.add(task);
        }
        this.LOCK.unlock();
        return this;
    }

    public Executor clearTasks() {
        this.LOCK.lock();
        this.builder.clear();
        this.LOCK.unlock();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long execute() {
        block22: {
            block21: {
                this.LOCK.lock();
                start = System.currentTimeMillis();
                pipeline = this.builder.build();
                while (true) {
                    taskIndex = 0;
lbl7:
                    // 7 sources

                    for (ITask task : pipeline) {
                        ++taskIndex;
                        if (!task.isFinish(pipeline.status, this.context)) {
                            if (!this.silent && Executor.LOGGER != null) {
                                Executor.LOGGER.info("Task@{}: {} (threads: {})", new Object[]{taskIndex, task.description(pipeline.status, this.context), task.getThreads()});
                            }
                            break block21;
                        }
                        if (this.silent || Executor.LOGGER == null) continue;
                        Executor.LOGGER.info("Task@{}: {} (skipped)", (Object)taskIndex, (Object)task.description(pipeline.status, this.context));
                    }
                    break block22;
                    break;
                }
                finally {
                    this.LOCK.unlock();
                }
            }
            block14: while (true) {
                try {
                    task.execute(pipeline.status, this.context);
                    ** GOTO lbl7
                }
                catch (Error | Exception e) {
                    taskPolicy = task.getErrorPolicy(pipeline.status, this.context, e);
                    if (taskPolicy == null) {
                        taskPolicy = ErrorPolicy.STOP_AND_THROW_EXCEPTION;
                    }
                    switch (1.$SwitchMap$edu$sysu$pmglab$executor$ErrorPolicy[taskPolicy.ordinal()]) {
                        case 1: {
                            if (this.silent || Executor.LOGGER == null) ** GOTO lbl-1000
                            if (!Executor.LOGGER.isDebugEnabled()) ** GOTO lbl35
                            Executor.LOGGER.debug("Task@{}: {} (retried workflow due to: {})", new Object[]{taskIndex, task.description(pipeline.status, this.context), e.getMessage(), e});
                            ** GOTO lbl-1000
lbl35:
                            // 1 sources

                            Executor.LOGGER.error("Task@{}: {} (retried workflow due to: {})", new Object[]{taskIndex, task.description(pipeline.status, this.context), e.getMessage()});
                            ** continue;
                        }
                        case 2: {
                            if (this.silent || Executor.LOGGER == null) continue block14;
                            if (Executor.LOGGER.isDebugEnabled()) {
                                Executor.LOGGER.debug("Task@{}: {} (retried task due to: {})", new Object[]{taskIndex, task.description(pipeline.status, this.context), e.getMessage(), e});
                                continue block14;
                            }
                            Executor.LOGGER.error("Task@{}: {} (retried task due to: {})", new Object[]{taskIndex, task.description(pipeline.status, this.context), e.getMessage()});
                            continue block14;
                        }
                        case 3: {
                            if (this.silent || Executor.LOGGER == null) ** GOTO lbl7
                            if (!Executor.LOGGER.isDebugEnabled()) ** GOTO lbl49
                            Executor.LOGGER.debug("Task@{}: {} (skipped task due to: {})", new Object[]{taskIndex, task.description(pipeline.status, this.context), e.getMessage(), e});
                            ** GOTO lbl7
lbl49:
                            // 1 sources

                            Executor.LOGGER.error("Task@{}: {} (skipped task due to: {})", new Object[]{taskIndex, task.description(pipeline.status, this.context), e.getMessage()});
                            ** GOTO lbl7
                        }
                        case 4: {
                            if (this.silent != false) throw new RuntimeException(e);
                            if (Executor.LOGGER == null) throw new RuntimeException(e);
                            if (Executor.LOGGER.isDebugEnabled()) {
                                Executor.LOGGER.debug("Task@{}: {} (interrupted workflow due to: {})", new Object[]{taskIndex, task.description(pipeline.status, this.context), e.getMessage(), e});
                                throw new RuntimeException(e);
                            }
                            Executor.LOGGER.error("Task@{}: {} (interrupted workflow due to: {})", new Object[]{taskIndex, task.description(pipeline.status, this.context), e.getMessage()});
                            throw new RuntimeException(e);
                        }
                        case 5: 
                        case 6: {
                            if (this.silent || Executor.LOGGER == null) break block14;
                            if (Executor.LOGGER.isDebugEnabled()) {
                                Executor.LOGGER.debug("Task@{}: {} (interrupted workflow due to: {})", new Object[]{taskIndex, task.description(pipeline.status, this.context), e.getMessage(), e});
                                break block14;
                            }
                            Executor.LOGGER.error("Task@{}: {} (interrupted workflow due to: {})", new Object[]{taskIndex, task.description(pipeline.status, this.context), e.getMessage()});
                            break block14;
                        }
                        default: {
                            continue block14;
                        }
                    }
                }
                break;
            }
        }
        end = System.currentTimeMillis();
        if (this.silent != false) return end - start;
        if (Executor.LOGGER == null) return end - start;
        Executor.LOGGER.info("All tasks have been completed, total time taken: {} s", (Object)Float.valueOf((float)(end - start) / 1000.0f));
        return end - start;
    }

    @Override
    public Iterator<ITask> iterator() {
        return this.builder.tasks.iterator();
    }
}

