/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.executor;

import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Pipeline;
import edu.sysu.pmglab.executor.track.ITrack;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IExecutor<T> {
    public static final String THREADS = "AutomaticThreadAllocation";
    static final Logger LOGGER = LoggerFactory.getLogger("EXECUTOR");
    final Context context = new Context(4);
    final ReentrantLock LOCK = new ReentrantLock();
    boolean silent = true;

    ThreadPoolExecutor createCoreExecutor(int nThreads, boolean infinity) {
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.SECONDS, infinity ? new LinkedBlockingQueue<Runnable>() : new LinkedBlockingQueue(nThreads), new ThreadFactory(){
            private static final String NAME_PREFIX = "Workflow-Thread-";
            private final AtomicInteger THREAD_NUMBER = new AtomicInteger(1);
            private final SecurityManager manager = System.getSecurityManager();
            private final ThreadGroup group = this.manager != null ? this.manager.getThreadGroup() : Thread.currentThread().getThreadGroup();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread2 = new Thread(this.group, r, NAME_PREFIX + this.THREAD_NUMBER.getAndIncrement());
                thread2.setDaemon(true);
                return thread2;
            }
        });
    }

    public abstract T addTask(Pipeline var1);

    public abstract T addTask(ITask var1);

    public Logger getLogger() {
        return LOGGER;
    }

    public T silent(boolean silent) {
        this.silent = silent;
        return (T)this;
    }

    public T setLoggerLevel(Level level) {
        return (T)this;
    }

    public T setParam(Object propertyKey, Object propertyValue) {
        this.context.put(propertyKey, propertyValue);
        return (T)this;
    }

    public T setParams(Map<?, ?> params) {
        if (params != null && params.size() > 0) {
            this.context.putAll(params);
        }
        return (T)this;
    }

    public <V> V getParam(Object propertyKey) {
        return this.context.get(propertyKey);
    }

    public Map<Object, Object> getParams() {
        return Collections.unmodifiableMap(this.context);
    }

    public T clearParams() {
        this.context.clear();
        return (T)this;
    }

    public T setTracker(ITrack tracker) {
        if (tracker == null) {
            this.context.setTracker(ITrack.EMPTY);
        } else {
            this.context.setTracker(tracker);
        }
        return (T)this;
    }

    public ITrack getTracker() {
        return this.context.getTracker();
    }
}

