/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.executor;

import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class Pipeline
implements Iterable<ITask> {
    public static final Pipeline WAIT_FOR_ALL = new Pipeline(true, new ITask[0]){

        @Override
        public Pipeline setParam(Object propertyKey, Object propertyValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Pipeline setParams(Map<?, ?> params) {
            throw new UnsupportedOperationException();
        }
    };
    final List<ITask> tasks;
    final boolean exclusive;
    final Status status = new Status(0);

    public Pipeline() {
        this(false, new ITask[0]);
    }

    public Pipeline(ITask ... tasks) {
        this(false, tasks);
    }

    public Pipeline(boolean exclusive, ITask ... tasks) {
        this.exclusive = exclusive;
        if (tasks != null && tasks.length > 0) {
            this.tasks = new List(tasks.length);
            for (ITask task : tasks) {
                if (task == null) continue;
                this.tasks.add(task);
            }
        } else {
            this.tasks = new List(0);
        }
    }

    public Pipeline(Iterable<ITask> tasks) {
        this(false, tasks);
    }

    public Pipeline(boolean exclusive, Iterable<ITask> tasks) {
        this.exclusive = exclusive;
        if (tasks != null) {
            this.tasks = tasks instanceof Collection ? new List(((Collection)tasks).size()) : new List();
            for (ITask task : tasks) {
                if (task == null) continue;
                this.tasks.add(task);
            }
        } else {
            this.tasks = new List(0);
        }
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public Iterator<ITask> iterator() {
        return this.tasks.iterator();
    }

    public Pipeline setParam(Object propertyKey, Object propertyValue) {
        this.status.put(propertyKey, propertyValue);
        return this;
    }

    public <T> T getParam(Object propertyKey) {
        return (T)this.status.get(propertyKey);
    }

    public Map<Object, Object> getParams() {
        return Collections.unmodifiableMap(this.status);
    }

    public Pipeline setParams(Map<?, ?> params) {
        if (params != null && params.size() > 0) {
            this.status.putAll(params);
        }
        return this;
    }

    public Pipeline setParams(IRecord params) {
        if (params != null && params.size() > 0) {
            for (FieldMeta field : params.keys()) {
                if (params.getField(field.simpleName()) == params.getField(field.fullName())) {
                    this.status.put(field.simpleName(), params.get(field));
                    this.status.put(field.fullName(), params.get(field));
                    continue;
                }
                this.status.put(field.fullName(), params.get(field));
            }
        }
        return this;
    }

    public Pipeline clearParams() {
        this.status.clear();
        return this;
    }

    public static class Builder {
        final List<ITask> tasks = new List();
        boolean exclusive = false;

        public Builder add(ITask ... tasks) {
            if (tasks == null) {
                return this;
            }
            for (ITask task : tasks) {
                if (task == null) continue;
                this.tasks.add(task);
            }
            return this;
        }

        public Builder add(Iterable<ITask> tasks) {
            if (tasks == null) {
                return this;
            }
            for (ITask task : tasks) {
                if (task == null) continue;
                this.tasks.add(task);
            }
            return this;
        }

        public Builder clear() {
            this.tasks.clear();
            return this;
        }

        public Builder setExclusive(boolean exclusive) {
            this.exclusive = exclusive;
            return this;
        }

        public Pipeline build() {
            return new Pipeline(this.exclusive, this.tasks);
        }
    }
}

