/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.executor;

import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Pipeline;
import edu.sysu.pmglab.utils.Assert;
import java.util.Iterator;

class RuntimeLayer
implements Iterable<Pipeline> {
    final List<Pipeline> pipelines;
    final boolean exclusive;

    public RuntimeLayer(ITask task) {
        this(task.toPipeline());
    }

    public RuntimeLayer(Pipeline pipeline) {
        if (pipeline.isExclusive()) {
            this.exclusive = true;
            this.pipelines = new List(1);
        } else {
            this.exclusive = false;
            this.pipelines = new List(4);
        }
        this.pipelines.add(pipeline);
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public RuntimeLayer update(ITask pipeline) {
        return this.update(pipeline.toPipeline());
    }

    public RuntimeLayer update(Pipeline pipeline) {
        if (pipeline == null) {
            return this;
        }
        Assert.that(!this.exclusive && !pipeline.isExclusive());
        this.pipelines.add(pipeline);
        return this;
    }

    @Override
    public Iterator<Pipeline> iterator() {
        return this.pipelines.iterator();
    }

    public int size() {
        return this.pipelines.size();
    }

    public Pipeline getPipeline(int pipelineIndex) {
        return this.pipelines.get(pipelineIndex);
    }
}

