/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.executor;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.executor.IExecutor;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Pipeline;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class ThreadQueue
extends IExecutor<ThreadQueue>
implements Closeable,
AutoCloseable {
    final int threads;
    final int pipelines;
    final ThreadPoolExecutor pool;
    final Semaphore threadSemaphore;
    final Semaphore pipelineSemaphore;
    final AtomicReference<Throwable> exception = new AtomicReference();

    public ThreadQueue() {
        this(RuntimeProperty.AVAILABLE_PROCESSORS);
    }

    public ThreadQueue(int nThreads) {
        this(Math.max(nThreads, 1), Math.max(nThreads, 1));
    }

    public ThreadQueue(int nThreads, int nPipelines) {
        this.threads = Math.max(nThreads, 1);
        this.pipelines = Math.max(nPipelines, 1);
        this.threadSemaphore = new Semaphore(this.threads, true);
        this.pipelineSemaphore = new Semaphore(this.pipelines, true);
        this.pool = this.createCoreExecutor(this.pipelines, false);
    }

    public int getThreads() {
        return this.threads;
    }

    @Override
    public ThreadQueue addTask(Pipeline pipeline) {
        if (this.exception.get() != null) {
            this.close0();
            throw new RuntimeException("Due to internal thread exceptions, the thread pool has been shut down prematurely", this.exception.get());
        }
        if (pipeline != null) {
            int require = pipeline.isExclusive() ? this.pipelines : 1;
            try {
                this.pipelineSemaphore.acquire(require);
                if (pipeline == Pipeline.WAIT_FOR_ALL) {
                    this.pipelineSemaphore.release(this.pipelines);
                } else {
                    CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CASE]], but top level block is 5[TRYBLOCK]
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }, this.pool);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (RejectedExecutionException e) {
                this.pipelineSemaphore.release(require);
                throw new RuntimeException("The closed thread queue has rejected the task submission request");
            }
        }
        return this;
    }

    @Override
    public ThreadQueue addTask(ITask task) {
        return this.addTask(new Pipeline(task));
    }

    @Override
    public void close() {
        try {
            this.await();
        }
        finally {
            this.close0();
        }
    }

    public void await() {
        this.addTask(Pipeline.WAIT_FOR_ALL);
        if (this.exception.get() != null) {
            throw new RuntimeException(this.exception.get());
        }
    }

    private void close0() {
        if (!this.pool.isTerminated() || !this.pool.isShutdown()) {
            try {
                this.pool.shutdown();
                this.pool.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (!this.silent && LOGGER != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("{}", (Object)e.getMessage(), (Object)e);
                    } else {
                        LOGGER.error("{}", (Object)e.getMessage());
                    }
                }
                this.pool.shutdownNow();
                throw new RuntimeException(e);
            }
        }
    }
}

