/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.executor;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.IExecutor;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Pipeline;
import edu.sysu.pmglab.executor.RuntimeLayer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Workflow
extends IExecutor<Workflow> {
    final List<RuntimeLayer> layers = new List(4);
    final int threads;
    final int maxPipeline;

    public Workflow() {
        this(RuntimeProperty.AVAILABLE_PROCESSORS);
    }

    public Workflow(int threads) {
        this.threads = Math.max(1, threads);
        this.maxPipeline = threads;
    }

    public Workflow(int threads, int pipelinePoolSize) {
        this.threads = Math.max(1, threads);
        this.maxPipeline = Math.max(1, pipelinePoolSize);
    }

    @Override
    public Workflow addTask(Pipeline pipeline) {
        if (pipeline != null) {
            for (ITask task : pipeline) {
                if (task.getThreads() < 1 || task.getThreads() <= this.threads) continue;
                String message = "Execute task (" + task + ") requires at least " + task.getThreads() + " threads, but only " + this.threads + " were provided at most";
                throw new RuntimeException(message);
            }
            this.LOCK.lock();
            if (this.layers.size() == 0) {
                this.layers.add(new RuntimeLayer(pipeline));
            } else if (this.layers.lastGet(0).isExclusive() || pipeline.isExclusive()) {
                this.layers.add(new RuntimeLayer(pipeline));
            } else {
                this.layers.lastGet(0).update(pipeline);
            }
            this.LOCK.unlock();
        }
        return this;
    }

    @Override
    public Workflow addTask(ITask task) {
        return this.addTask(new Pipeline(task));
    }

    public Workflow clearTasks() {
        this.LOCK.lock();
        this.layers.clear();
        this.LOCK.unlock();
        return this;
    }

    public int getThreads() {
        return this.threads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long execute() {
        long start;
        block11: {
            this.LOCK.lock();
            start = System.currentTimeMillis();
            try {
                if (this.layers.size() == 0) break block11;
                Semaphore threadSemaphore = new Semaphore(this.threads, true);
                Semaphore pipelineSemaphore = new Semaphore(this.maxPipeline, true);
                ThreadPoolExecutor pool = this.createCoreExecutor(this.maxPipeline, true);
                AtomicBoolean stop = new AtomicBoolean(false);
                for (int i = 0; i < this.layers.size(); ++i) {
                    RuntimeLayer layer = this.layers.get(i);
                    CompletableFuture[] futures = new CompletableFuture[layer.size()];
                    int layerIndex = i;
                    for (int j = 0; j < layer.size(); ++j) {
                        int pipeLineIndex = j;
                        futures[j] = CompletableFuture.runAsync(() -> {
                            /*
                             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                             * 
                             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CASE]], but top level block is 5[TRYBLOCK]
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                             *     at org.benf.cfr.reader.Main.main(Main.java:54)
                             */
                            throw new IllegalStateException("Decompilation failed");
                        }, pool);
                    }
                    CompletableFuture.allOf(futures).join();
                    if (stop.get()) break;
                }
                try {
                    pool.shutdown();
                    pool.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (!this.silent && LOGGER != null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("{}", (Object)e.getMessage(), (Object)e);
                        } else {
                            LOGGER.error("{}", (Object)e.getMessage());
                        }
                    }
                    pool.shutdownNow();
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.LOCK.unlock();
            }
        }
        long end = System.currentTimeMillis();
        if (!this.silent && LOGGER != null) {
            LOGGER.info("All tasks have been completed, total time taken: {} s", (Object)Float.valueOf((float)(end - start) / 1000.0f));
        }
        return end - start;
    }
}

