/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.executor.track;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.io.text.reader.CustomSeparator;
import edu.sysu.pmglab.io.text.writer.CustomJoiner;
import edu.sysu.pmglab.io.writer.WriterStream;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public class FileTracker
extends ITrack {
    static final CustomJoiner joiner = new CustomJoiner("{} {} {}");
    static final CustomSeparator splitter = new CustomSeparator("{} {} {}");
    final WriterStream writer;
    final Set<String> tracks = new THashSet<String>();

    public FileTracker(String filename) throws IOException {
        this(new File(filename));
    }

    public FileTracker(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new RuntimeException("The track file cannot be a folder: " + file);
            }
            try (ReaderStream reader = new ReaderStream(file.getPath(), ReaderStream.Option.DEFAULT);){
                Bytes line;
                while ((line = reader.readline()) != null) {
                    if (line.length() <= 0) continue;
                    this.tracks.add(splitter.accept(line).get(2).toString());
                }
            }
        } else if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        this.writer = new WriterStream(file, WriterStream.Option.APPEND);
    }

    @Override
    public FileTracker add(String pipeline, String task, String id) throws IOException {
        if (!this.contains(id)) {
            this.writer.writeChar(pipeline);
            this.writer.write(32);
            this.writer.writeChar(task);
            this.writer.write(32);
            this.writer.writeChar(id);
            this.writer.write(10);
            this.writer.flush();
            this.tracks.add(id);
        }
        return this;
    }

    @Override
    public synchronized boolean contains(String id) {
        return this.tracks.contains(id);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

