/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.executor.track;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.utils.MD5;
import java.io.Closeable;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public abstract class ITrack
implements AutoCloseable,
Closeable {
    public static final ITrack EMPTY = new ITrack(){};
    private static final MessageDigest calculator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String digest(Object ... objects) {
        MessageDigest messageDigest = calculator;
        synchronized (messageDigest) {
            calculator.reset();
            if (objects == null) {
                calculator.update(new byte[]{0});
            } else {
                for (Object object : objects) {
                    if (object instanceof Enum) {
                        object = object.getClass().getName() + "$" + object;
                    }
                    ByteStream container = ByteStream.getThreadInstance();
                    container.clear();
                    container.writeChar(Integer.toHexString(Arrays.deepHashCode(new Object[]{object})));
                    calculator.update(container.bytes(), container.offset(), container.length());
                }
            }
            return MD5.toString(calculator.digest());
        }
    }

    public ITrack add(String id) throws IOException {
        return this.add("0", "0", id);
    }

    public ITrack add(String pipeline, String id) throws IOException {
        return this.add(pipeline, "0", id);
    }

    public ITrack add(String pipeline, String task, String id) throws IOException {
        return this;
    }

    public boolean contains(String id) {
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    static {
        try {
            calculator = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

