/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb;

import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.type.basic.ChromosomeBox;
import edu.sysu.pmglab.ccf.type.basic.VarInt32Box;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.pointer.Pointer;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import java.io.IOException;

public class GTBCoordinateReader {
    final CCFReader reader;
    final BoxRecord record = new BoxRecord(GTBManager.FIELDS.subsetFields("CHROM", "POS"));
    final ChromosomeBox chromosomeBox = (ChromosomeBox)this.record.getBox(null, "CHROM");
    final VarInt32Box posBox = (VarInt32Box)this.record.getBox(null, "POS");
    final boolean skipDuplicates;
    Coordinate coordinate;

    public GTBCoordinateReader(CCFTable input, boolean skipDuplicates) throws IOException {
        this.reader = new CCFReader(new ReaderOption(input, "CHROM", "POS"));
        this.skipDuplicates = skipDuplicates;
    }

    public GTBCoordinateReader(GTBManager input, boolean skipDuplicates) throws IOException {
        this.reader = new CCFReader(new ReaderOption(input.getTable(), "CHROM", "POS"));
        this.skipDuplicates = skipDuplicates;
    }

    public GTBCoordinateReader limit(LongInterval range) {
        this.reader.limit(range);
        this.coordinate = null;
        return this;
    }

    public GTBCoordinateReader limit(long minPointer, long maxPointer) throws IOException {
        this.reader.limit(minPointer, maxPointer);
        this.coordinate = null;
        return this;
    }

    public GTBCoordinateReader clearLimit() {
        this.reader.clearLimit();
        this.coordinate = null;
        return this;
    }

    public GTBCoordinateReader seek(long variantIndex) throws IOException {
        this.reader.seek(variantIndex);
        this.coordinate = null;
        return this;
    }

    public Coordinate read() throws IOException {
        if (this.skipDuplicates) {
            while (this.reader.read(this.record)) {
                if (this.coordinate == null) {
                    this.coordinate = new Coordinate(this.chromosomeBox.get(), (int)this.posBox.get());
                    return this.coordinate;
                }
                if (this.coordinate.getChromosome() == this.chromosomeBox.get() && this.coordinate.getPosition() == this.posBox.intValue()) continue;
                this.coordinate = new Coordinate(this.chromosomeBox.get(), (int)this.posBox.get());
                return this.coordinate;
            }
            this.coordinate = null;
        } else if (this.reader.read(this.record)) {
            return new Coordinate(this.chromosomeBox.get(), (int)this.posBox.get());
        }
        return null;
    }

    public void close() throws IOException {
        this.reader.close();
        this.chromosomeBox.init();
        this.posBox.init();
        this.record.clear();
        this.coordinate = null;
    }

    public Pointer getPointer() {
        return this.reader.getPointer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GTBCoordinateReader> part(int nParts) throws IOException {
        try {
            List<Pointer> pointers = this.reader.getPointer().part(nParts);
            if (pointers.size() == 0) {
                List<GTBCoordinateReader> list = List.EMPTY();
                return list;
            }
            if (pointers.size() == 1) {
                Pointer pointer = pointers.fastGet(0);
                List<GTBCoordinateReader> list = List.singleton(new GTBCoordinateReader(this.reader.getTable(), this.skipDuplicates).limit(pointer.available())).asUnmodifiable();
                return list;
            }
            GTBCoordinateReader fixer = new GTBCoordinateReader(this.reader.getTable(), true);
            List<GTBCoordinateReader> readers = new List<GTBCoordinateReader>(pointers.size());
            long end = -1L;
            for (int i = 0; i < pointers.size(); ++i) {
                LongInterval pointer;
                long start = i == 0 ? pointer.start() : end;
                if (start >= (pointer = pointers.fastGet(i).available()).end()) continue;
                fixer.seek(pointer.end());
                if (fixer.read() != null && fixer.read() != null) {
                    fixer.seek(fixer.tell() - 1L);
                }
                end = fixer.tell();
                readers.add(new GTBCoordinateReader(this.reader.getTable(), this.skipDuplicates).limit(start, end));
            }
            fixer.close();
            List<GTBCoordinateReader> list = readers;
            return list;
        }
        finally {
            this.close();
        }
    }

    public long tell() {
        return this.reader.tell();
    }
}

