/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb;

import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.LiteTable;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.indexer.intvalue.CCFIntIndexer;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.meta.ICCFOptions;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.gtb.exception.GTBComponentException;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.utils.Configurator;
import java.io.File;
import java.io.IOException;

public class GTBManager
implements IFieldCollection {
    public static final String INDEXER_OPTION_KEY = "INDEXER";
    public static final String INDIVIDUAL_OPTION_KEY = "GTB_INDIVIDUAL";
    public static final FieldGroupMeta FIELDS = new FieldGroupMeta(null).addField("CHROM", FieldType.chromosome).addField("POS", FieldType.varInt32).addField("ALLELE", FieldType.stringIndexableSet).addField("GT", FieldType.bytecode).asUnmodifiable();
    final CCFTable table;
    final IndexableSet<String> individuals;
    final IFieldCollection fields;
    CCFIntIndexer<Chromosome> indexer;

    public GTBManager(String file) throws IOException {
        this(new CCFTable(file));
    }

    public GTBManager(File file) throws IOException {
        this(new CCFTable(file));
    }

    public GTBManager(LiveFile file) throws IOException {
        this(new CCFTable(file));
    }

    public GTBManager(CCFTable table) {
        CCFIntIndexer gtbIndexer;
        this.table = table;
        if (!this.table.containsField("CHROM") || !this.table.containsField("POS")) {
            throw new GTBComponentException("GTB file needs to include mandatory fields: " + FIELDS.subsetFields("CHROM", "POS"));
        }
        if (this.table.containsField("ALLELE") && !this.table.containsField(FIELDS.getField("ALLELE"))) {
            throw new GTBComponentException("GTB file needs to include mandatory fields: " + FIELDS.subsetFields("ALLELE"));
        }
        if (this.table.containsField("GT") && !this.table.containsField(FIELDS.getField("GT"))) {
            throw new GTBComponentException("GTB file needs to include mandatory fields: " + FIELDS.subsetFields("GT"));
        }
        LiteTable indexer = this.table.getOption(INDEXER_OPTION_KEY, null);
        this.indexer = indexer == null ? null : ((gtbIndexer = new CCFIntIndexer(indexer)).numOfRecords() != this.table.numOfRecords() ? null : gtbIndexer);
        this.fields = table.getAllFields().subsetFieldsExcludes(FIELDS).asUnmodifiable();
        this.individuals = this.table.getOption(INDIVIDUAL_OPTION_KEY, IndexableSet.EMPTY());
    }

    public CCFTable getTable() {
        return this.table;
    }

    public CCFIntIndexer<Chromosome> getIndexer() throws IOException {
        return this.getIndexer(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CCFIntIndexer<Chromosome> getIndexer(boolean build, Configurator<GTBIndexer> setting) throws IOException {
        GTBManager gTBManager = this;
        synchronized (gTBManager) {
            if (this.indexer == null) {
                if (build) {
                    GTBIndexer indexer = GTBIndexer.setInput(this.table, new String[0]);
                    if (setting != null) {
                        setting.configure(indexer);
                    }
                    this.indexer = indexer.build(2);
                    return this.indexer;
                }
                return null;
            }
            return this.indexer;
        }
    }

    public int numOfIndividuals() {
        return this.individuals.size();
    }

    public String getIndividual(int index) {
        return this.individuals.valueOf(index);
    }

    public int indexOfIndividual(String individual) {
        return this.individuals.indexOf(individual);
    }

    public boolean containsIndividual(String individual) {
        return this.individuals.contains(individual);
    }

    public IndexableSet<String> getIndividuals() {
        return this.individuals;
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Summary of GTB File:");
        builder.append("\n    GTB File Name: " + this.table.getFile());
        builder.append("\n    GTB File Size: " + this.table.getFile().formatLength("#.###"));
        builder.append("\n    GTB File Last Modify Time: " + this.table.getFile().formatLastModifyTime(null));
        builder.append("\n    Dimension of Genotype: " + this.numOfVariants() + " variant" + (this.numOfVariants() <= 1L ? "" : "s") + " and " + this.numOfIndividuals() + " individual" + (this.numOfIndividuals() <= 1 ? "" : "s"));
        if (this.indexer != null) {
            builder.append("\n    Ordered GTB: " + (this.indexer.isOrdered() && this.indexer.isCompact()));
        }
        if (this.table.numOfFieldGroups() > 0) {
            builder.append("\n    Fields in FieldGroup (" + this.table.numOfFieldGroups() + " group" + (this.numOfFieldGroups() == 1 ? "" : "s") + " in total, " + this.numOfFields() + " field" + (this.numOfFields() <= 1 ? "" : "s") + " in total):");
            for (FieldGroupMeta group : this.table.getAllFieldGroups()) {
                builder.append("\n        ").append(group);
            }
        }
        return builder.toString();
    }

    public long numOfVariants() {
        return this.table.numOfRecords();
    }

    @Override
    public IFieldCollection getAllFields() {
        return this.fields;
    }

    public ICCFMeta getMeta() {
        return this.table.getMeta();
    }

    public ICCFOptions getOptions() {
        return this.table.getOptions();
    }

    public <T> T getOption(String key) {
        return this.table.getOption(key);
    }

    public <T> T getOption(String key, T defaults) {
        return this.table.getOption(key, defaults);
    }

    public LiveFile getFile() {
        return this.table.getFile();
    }
}

