/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.type.basic.VarInt32Box;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.pointer.Pointer;
import edu.sysu.pmglab.gtb.GTBCoordinateReader;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.exception.GTBComponentException;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.cache.CacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.ConstantGenotypes;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.File;
import java.io.IOException;

public class GTBReader
implements AutoCloseable,
IFieldCollection {
    private final GTBReaderOption option;
    private final IFieldCollection fields;
    private final CCFReader reader;
    private final BoxRecord record;
    private final CoordinateCache coordinate = new CoordinateCache();

    public GTBReader(String input) throws IOException {
        this(new GTBReaderOption(input));
    }

    public GTBReader(File input) throws IOException {
        this(new GTBReaderOption(input));
    }

    public GTBReader(LiveFile input) throws IOException {
        this(new GTBReaderOption(input));
    }

    public GTBReader(GTBManager input) {
        this(new GTBReaderOption(input));
    }

    public GTBReader(CCFTable input) {
        this(new GTBReaderOption(input));
    }

    public GTBReader(GTBReaderOption option) {
        this.option = (GTBReaderOption)option.asUnmodifiable();
        try {
            this.fields = this.option.getAllSupplementaryFields();
            this.reader = new CCFReader(this.option);
            this.record = this.reader.getRecord();
            Variant.addPropertyKeys(this.fields);
        }
        catch (Error | Exception e) {
            throw new GTBComponentException("Broken genotype block format (based on ccf)");
        }
    }

    public GTBManager getManager() {
        return this.option.getGTBManager();
    }

    public GTBReaderOption getReaderOption() {
        return this.option;
    }

    public LongInterval available() {
        return this.reader.available();
    }

    public Variant read() throws IOException {
        if (this.reader.read(this.record)) {
            Chromosome chromosome = (Chromosome)this.record.get(null, "CHROM");
            VarInt32Box posBox = (VarInt32Box)this.record.getBox(null, "POS");
            Coordinate coordinate = new Coordinate(chromosome, posBox.intValue());
            Variant variant = new Variant(coordinate);
            if (this.record.containsKey("ALLELE")) {
                variant.addAlleles((IndexableSet)this.record.get("ALLELE"));
            }
            if (this.option.loadGenotype()) {
                variant.setGenotypes(IGenotypes.load((Bytes)this.record.get("GT")));
            } else if (this.option.numOfIndividuals() == 0) {
                variant.setGenotypes(CacheGenotypes.EMPTY);
            } else {
                variant.setGenotypes(new ConstantGenotypes(this.option.numOfIndividuals()));
            }
            for (FieldMeta field : this.fields) {
                variant.setProperty(field.fullName(), this.record.get(field));
            }
            if (this.coordinate.pointer != this.reader.tell() - 1L) {
                this.coordinate.coordinate = coordinate;
                this.coordinate.pointer = this.reader.tell() - 1L;
            }
            return variant;
        }
        return null;
    }

    public long tell() {
        return this.reader.tell();
    }

    public boolean hasNext() {
        return this.reader.hasNext();
    }

    public Coordinate getCoordinate() throws IOException {
        if (this.coordinate.pointer == this.reader.tell()) {
            return this.coordinate.coordinate;
        }
        if (this.reader.read(this.coordinate.record)) {
            long pointer = this.reader.tell() - 1L;
            this.reader.seek(pointer);
            Chromosome chromosome = (Chromosome)this.coordinate.record.get(0);
            int position = (Integer)this.coordinate.record.get(1);
            this.coordinate.pointer = pointer;
            this.coordinate.coordinate = new Coordinate(chromosome, position);
            return this.coordinate.coordinate;
        }
        return null;
    }

    public Coordinate readCoordinate() throws IOException {
        if (this.coordinate.pointer == this.reader.tell()) {
            this.reader.seek(this.reader.tell() + 1L);
            return this.coordinate.coordinate;
        }
        if (this.reader.read(this.coordinate.record)) {
            long pointer = this.reader.tell() - 1L;
            Chromosome chromosome = (Chromosome)this.coordinate.record.get(0);
            int position = (Integer)this.coordinate.record.get(1);
            this.coordinate.pointer = pointer;
            this.coordinate.coordinate = new Coordinate(chromosome, position);
            return this.coordinate.coordinate;
        }
        return null;
    }

    public List<Variant> reads() throws IOException {
        Coordinate coordinate;
        if (this.remaining() == 0L) {
            return List.EMPTY();
        }
        Variant variant = this.read();
        if (variant == null) {
            return List.EMPTY();
        }
        List<Variant> variants = List.singleton(variant);
        while ((coordinate = this.getCoordinate()) != null && variant.getCoordinate().equals(coordinate)) {
            variants.add(this.read());
        }
        return variants;
    }

    public boolean seek(long variantIndex) throws IOException {
        return this.reader.seek(variantIndex);
    }

    public GTBReader limit(LongInterval ranges) throws IOException {
        this.reader.limit(ranges);
        return this;
    }

    public GTBReader limit(long minPointer, long maxPointer) throws IOException {
        this.reader.limit(minPointer, maxPointer);
        return this;
    }

    public GTBReader clearLimit() {
        this.reader.clearLimit();
        return this;
    }

    public long remaining() {
        return this.reader.remaining();
    }

    public IndexableSet<String> getIndividuals() {
        return this.option.getIndividuals();
    }

    public int numOfIndividuals() {
        return this.option.numOfIndividuals();
    }

    public long numOfVariants() {
        return this.option.numOfRecords();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public boolean isClosed() {
        return this.reader.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GTBReader> part(int nParts) throws IOException {
        try {
            List<Pointer> pointers = this.reader.getPointer().part(nParts);
            if (pointers.size() == 0) {
                List<GTBReader> list = List.EMPTY();
                return list;
            }
            if (pointers.size() == 1) {
                Pointer pointer = pointers.fastGet(0);
                List<GTBReader> list = List.singleton(new GTBReader(this.option).limit(pointer.available())).asUnmodifiable();
                return list;
            }
            GTBCoordinateReader fixer = new GTBCoordinateReader(this.reader.getTable(), true);
            List<GTBReader> readers = new List<GTBReader>(pointers.size());
            long end = -1L;
            for (int i = 0; i < pointers.size(); ++i) {
                LongInterval pointer;
                long start = i == 0 ? pointer.start() : end;
                if (start >= (pointer = pointers.fastGet(i).available()).end()) continue;
                fixer.seek(pointer.end());
                if (fixer.read() != null && fixer.read() != null) {
                    fixer.seek(fixer.tell() - 1L);
                }
                end = fixer.tell();
                readers.add(new GTBReader(this.option).limit(start, end));
            }
            fixer.close();
            List<GTBReader> list = readers;
            return list;
        }
        finally {
            this.close();
        }
    }

    @Override
    public IFieldCollection getAllFields() {
        return this.fields;
    }

    @Override
    public int numOfFields() {
        return this.option.numOfFields();
    }

    private static class CoordinateCache {
        final BoxRecord record = new BoxRecord(GTBManager.FIELDS.subsetFields("CHROM", "POS"));
        Coordinate coordinate = null;
        long pointer = -1L;

        private CoordinateCache() {
        }
    }
}

