/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb;

import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.File;
import java.io.IOException;

public class GTBReaderOption
extends IReaderOption<GTBReaderOption> {
    private final GTBManager manager;

    public GTBReaderOption(String path) throws IOException {
        this(new GTBManager(path), true, true);
    }

    public GTBReaderOption(LiveFile path) throws IOException {
        this(new GTBManager(path), true, true);
    }

    public GTBReaderOption(File path) throws IOException {
        this(new GTBManager(path), true, true);
    }

    public GTBReaderOption(CCFTable table) {
        this(new GTBManager(table), true, true);
    }

    public GTBReaderOption(GTBManager manager) {
        this(manager, true, true);
    }

    public GTBReaderOption(String manager, boolean loadGenotypes, boolean loadFields) throws IOException {
        this(new GTBManager(manager), loadGenotypes, loadFields);
    }

    public GTBReaderOption(File manager, boolean loadGenotypes, boolean loadFields) throws IOException {
        this(new GTBManager(manager), loadGenotypes, loadFields);
    }

    public GTBReaderOption(LiveFile manager, boolean loadGenotypes, boolean loadFields) throws IOException {
        this(new GTBManager(manager), loadGenotypes, loadFields);
    }

    public GTBReaderOption(CCFTable manager, boolean loadGenotypes, boolean loadFields) throws IOException {
        this(new GTBManager(manager), loadGenotypes, loadFields);
    }

    public GTBReaderOption(final GTBManager manager, final boolean loadGenotypes, boolean loadFields) {
        super(manager.getTable(), new IFieldCollection(){
            final FieldGroupMeta fields = new FieldGroupMeta();
            {
                this.fields.addField(manager.getTable().getField(null, "CHROM", FieldType.chromosome));
                this.fields.addField(manager.getTable().getField(null, "POS", FieldType.varInt32));
                this.fields.addField(manager.getTable().getField(null, "ALLELE", FieldType.stringIndexableSet));
                if (loadGenotypes && manager.numOfIndividuals() > 0) {
                    this.fields.addField(manager.getTable().getField(null, "GT", FieldType.bytecode));
                }
                this.fields.asUnmodifiable();
            }

            @Override
            public IFieldCollection getAllFields() {
                return this.fields;
            }
        });
        this.manager = manager;
        if (loadFields) {
            this.addAllFields();
        }
    }

    @Override
    public GTBReaderOption addField(FieldMeta field) {
        if (!GTBManager.FIELDS.containsField(field)) {
            super.addField(field);
        }
        return this;
    }

    @Override
    public GTBReaderOption clone() {
        return (GTBReaderOption)new GTBReaderOption(this.manager, this.containsField(null, "GT"), false).addFields(this.getAllSupplementaryFields());
    }

    public final GTBManager getGTBManager() {
        return this.manager;
    }

    public boolean loadGenotype() {
        return this.containsField(null, "GT");
    }

    public int numOfIndividuals() {
        return this.manager.numOfIndividuals();
    }

    public IndexableSet<String> getIndividuals() {
        return this.manager.getIndividuals();
    }
}

