/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.CCFConfiguration;
import edu.sysu.pmglab.ccf.CCFWriter;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.meta.ICCFOptions;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.ccf.type.basic.VarInt32Box;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.exception.GTBComponentException;
import edu.sysu.pmglab.gtb.exception.InvalidIndividualException;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.cache.CacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.ConstantGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.Encoder;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFHeader;
import edu.sysu.pmglab.utils.Configurator;
import java.io.File;
import java.io.IOException;

public class GTBWriter {
    final CCFWriter writer;
    final IndexableSet<String> individuals;
    final Encoder[] encoders;
    final BoxRecord[] records;
    final IGenotypes EMPTY_GENOTYPES;

    private GTBWriter(CCFWriter writer, IndexableSet<String> individuals) {
        this.writer = writer;
        this.individuals = individuals;
        this.records = new BoxRecord[writer.numOfParts()];
        this.encoders = new Encoder[writer.numOfParts()];
        if (this.individuals.size() == 0) {
            this.EMPTY_GENOTYPES = CacheGenotypes.EMPTY;
        } else {
            this.EMPTY_GENOTYPES = new ConstantGenotypes(this.individuals.size(), Genotype.MISSING);
            this.writer.addOption(CCFMetaItem.of("GTB_INDIVIDUAL", this.individuals));
        }
        Variant.addPropertyKeys(writer.getAllSupplementaryFields());
    }

    public static Builder setOutput(String output) {
        return new Builder(new File(output));
    }

    public static Builder setOutput(File output) {
        return new Builder(output);
    }

    public GTBWriter addMeta(CCFMetaItem meta) {
        this.writer.addMeta(meta);
        return this;
    }

    public GTBWriter addMeta(Iterable<CCFMetaItem> metas) {
        if (metas != null) {
            for (CCFMetaItem meta : metas) {
                this.addMeta(meta);
            }
        }
        return this;
    }

    public GTBWriter addOption(CCFMetaItem option) {
        this.writer.addOption(option);
        return this;
    }

    public GTBWriter addOptions(Iterable<CCFMetaItem> options) {
        this.writer.addOptions(options);
        return this;
    }

    public File getFile() {
        return this.writer.getFile();
    }

    public IFieldCollection getAllFields() {
        return this.writer.getAllSupplementaryFields();
    }

    public int numOfFields() {
        return this.writer.getAllSupplementaryFields().numOfFields();
    }

    public ICCFMeta getMeta() {
        return this.writer.getMeta();
    }

    public ICCFOptions getOptions() {
        return this.writer.getOptions();
    }

    public boolean isClosed() {
        return this.writer.isClosed();
    }

    public long numOfVariants() {
        return this.writer.numOfRecords();
    }

    public int numOfIndividuals() {
        return this.individuals.size();
    }

    public String getIndividual(int index) {
        return this.individuals.valueOf(index);
    }

    public int indexOfIndividual(String individual) {
        return this.individuals.indexOf(individual);
    }

    public boolean containsIndividual(String individual) {
        return this.individuals.contains(individual);
    }

    public IndexableSet<String> getIndividuals() {
        return this.individuals;
    }

    public int numOfParts() {
        return this.writer.numOfParts();
    }

    public void write(Variant variant) throws IOException {
        this.write(0, variant);
    }

    public void write(int partIndex, Iterable<Variant> variants) throws IOException {
        if (variants != null) {
            for (Variant variant : variants) {
                this.write(partIndex, variant);
            }
        }
    }

    public void write(Coordinate coordinate) throws IOException {
        this.write(0, coordinate);
    }

    public void write(int partIndex, Coordinate coordinate) throws IOException {
        if (coordinate == null) {
            return;
        }
        if (this.records[partIndex] == null) {
            this.records[partIndex] = this.writer.getRecord();
        }
        BoxRecord record = this.records[partIndex];
        if (this.encoders[partIndex] == null) {
            this.encoders[partIndex] = new Encoder(true);
        }
        record.set(null, "CHROM", coordinate.getChromosome());
        VarInt32Box posBox = (VarInt32Box)record.getBox(null, "POS");
        posBox.set(coordinate.getPosition());
        record.set(null, "ALLELE", LinkedSet.EMPTY());
        record.set(null, "GT", this.encoders[partIndex].encode(this.EMPTY_GENOTYPES));
        for (FieldMeta field : this.writer.getAllSupplementaryFields()) {
            record.set(field, null);
        }
        this.writer.write(partIndex, record);
    }

    public void write(int partIndex, Variant variant) throws IOException {
        if (variant == null) {
            return;
        }
        if (this.records[partIndex] == null) {
            this.records[partIndex] = this.writer.getRecord();
        }
        BoxRecord record = this.records[partIndex];
        if (this.encoders[partIndex] == null) {
            this.encoders[partIndex] = new Encoder(true);
        }
        record.set(null, "CHROM", variant.getChromosome());
        VarInt32Box posBox = (VarInt32Box)record.getBox(null, "POS");
        posBox.set(variant.getPosition());
        record.set(null, "ALLELE", variant.getAlleles());
        if (this.individuals.size() > 0) {
            IGenotypes genotypes = variant.getGenotypes();
            if (genotypes == null || genotypes.size() == 0) {
                genotypes = this.EMPTY_GENOTYPES;
            } else if (genotypes.size() != this.individuals.size()) {
                throw new GTBComponentException("Invalid genotypes: " + variant.getCoordinate() + " takes " + this.individuals.size() + " genotypes, but " + genotypes.size() + " given");
            }
            record.set(null, "GT", this.encoders[partIndex].encode(genotypes));
        }
        for (FieldMeta field : this.writer.getAllSupplementaryFields()) {
            Object value = variant.getProperty(field.fullName());
            if (value == null) {
                record.set(field, null);
                continue;
            }
            if (value instanceof Bytes) {
                ((Box)record.getBox(field)).char2Object((Bytes)value, false);
                continue;
            }
            if (value instanceof String) {
                ((Box)record.getBox(field)).char2Object((String)value);
                continue;
            }
            record.set(field, value);
        }
        this.writer.write(partIndex, record);
    }

    public GTBWriter finish(int partIndex) throws IOException {
        this.writer.finish(partIndex);
        return this;
    }

    public synchronized void close() throws IOException {
        if (!this.writer.isClosed()) {
            this.writer.close();
            for (int i = 0; i < this.encoders.length; ++i) {
                if (this.encoders[i] != null) {
                    this.encoders[i].close();
                    this.encoders[i] = null;
                }
                if (this.records[i] == null) continue;
                this.records[i].clear();
                this.records[i] = null;
            }
        }
    }

    public static class Builder {
        final CCFWriter.Builder builder;
        final IndexableSet<String> individuals = new LinkedSet<String>();

        private Builder(File file) {
            this.builder = CCFWriter.setOutput(file, (IFieldCollection)GTBManager.FIELDS);
        }

        public Builder addField(FieldMeta field) {
            this.builder.addField(field);
            return this;
        }

        public Builder addField(String name, IFieldType type) {
            this.builder.addField(name, type);
            return this;
        }

        public Builder addField(String group, String name, IFieldType type) {
            this.builder.addField(group, name, type);
            return this;
        }

        public Builder addFields(FieldMeta ... fields) {
            this.builder.addFields(fields);
            return this;
        }

        public Builder addFields(Iterable<FieldMeta> fields) {
            this.builder.addFields(fields);
            return this;
        }

        public int numOfFields() {
            return this.builder.getAllSupplementaryFields().numOfFields();
        }

        public Builder clearFields() {
            this.builder.clearFields();
            return this;
        }

        public IFieldCollection getAllFields() {
            return this.builder.getAllSupplementaryFields();
        }

        public boolean isModifiable() {
            return this.builder.isModifiable();
        }

        public Builder configureFileOptions(Configurator<CCFConfiguration> consumer) {
            this.builder.configureFileOptions(consumer);
            return this;
        }

        public Builder clearIndividuals() {
            if (!this.builder.isModifiable()) {
                throw new IllegalStateException("This object is immutable");
            }
            this.individuals.clear();
            return this;
        }

        public Builder addIndividual(String individual) {
            if (!this.builder.isModifiable()) {
                throw new IllegalStateException("This object is immutable");
            }
            if (!VCFHeader.isValidIndividual(individual)) {
                throw new InvalidIndividualException("Invalid individual: " + individual);
            }
            this.individuals.add(individual);
            return this;
        }

        public Builder addIndividuals(String ... individuals) {
            if (!this.builder.isModifiable()) {
                throw new IllegalStateException("This object is immutable");
            }
            if (individuals != null) {
                for (String individual : individuals) {
                    if (!VCFHeader.isValidIndividual(individual)) {
                        throw new InvalidIndividualException("Invalid individual: " + individual);
                    }
                    this.individuals.add(individual);
                }
            }
            return this;
        }

        public Builder addIndividuals(Iterable<String> individuals) {
            if (!this.builder.isModifiable()) {
                throw new IllegalStateException("This object is immutable");
            }
            if (individuals != null) {
                for (String individual : individuals) {
                    if (!VCFHeader.isValidIndividual(individual)) {
                        throw new InvalidIndividualException("Invalid individual: " + individual);
                    }
                    this.individuals.add(individual);
                }
            }
            return this;
        }

        public IndexableSet<String> getIndividuals() {
            return this.individuals.asUnmodifiable();
        }

        public Builder setIndividuals(Iterable<String> individuals) {
            if (!this.builder.isModifiable()) {
                throw new IllegalStateException("This object is immutable");
            }
            this.individuals.clear();
            if (individuals != null) {
                for (String individual : individuals) {
                    if (!VCFHeader.isValidIndividual(individual)) {
                        throw new InvalidIndividualException("Invalid individual: " + individual);
                    }
                    this.individuals.add(individual);
                }
            }
            return this;
        }

        public String getIndividual(int index) {
            return this.individuals.valueOf(index);
        }

        public int indexOfIndividual(String individual) {
            return this.individuals.indexOf(individual);
        }

        public boolean containsIndividual(String individual) {
            return this.individuals.contains(individual);
        }

        public int numOfIndividuals() {
            return this.individuals.size();
        }

        public GTBWriter instance() {
            return this.instance(1);
        }

        public GTBWriter instance(int nParts) {
            return new GTBWriter(this.builder.instance(nParts), this.individuals.asUnmodifiable());
        }

        public File getFile() {
            return this.builder.getFile();
        }
    }
}

