/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command;

import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.EntryOption;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.gtb.command.database.MakeDatabaseCommandProgram;
import edu.sysu.pmglab.gtb.command.program.CollectProgram;
import edu.sysu.pmglab.gtb.command.program.ConcatGTBCommandProgram;
import edu.sysu.pmglab.gtb.command.program.ConverterEntry;
import edu.sysu.pmglab.gtb.command.program.GTBMergerCommandProgram;
import edu.sysu.pmglab.gtb.command.program.GTBRefineCommandProgram;
import edu.sysu.pmglab.gtb.command.program.GTBSortCommandProgram;
import edu.sysu.pmglab.gtb.command.program.GUIProgram;
import edu.sysu.pmglab.gtb.command.program.LDCalculatorProgram;
import edu.sysu.pmglab.gtb.command.program.LessProgram;
import edu.sysu.pmglab.gtb.command.program.SplitGTBCommandProgram;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="gbc [options]", usage_item={@UsageItem(key="About", value={"The GenoType Block Compressor (GBC) is an assembly of tools for compressing, accessing and managing genotype data with unparalleled efficiency."})})
public class GBCEntry
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(GBCEntry.class);
    @EntryOption(value={"convert"}, retain=false)
    @OptionUsage(description={"Convert between VCF, MAF, TEXT, GTB, and PLINK formats."}, format="convert <mode> [options]")
    String[] convert;
    @EntryOption(value={"concat"}, retain=true)
    @OptionUsage(description={"Concatenate multiple *.gtb files."}, format="concat <input> <input> ... --output <output> [options]")
    String[] concat;
    @EntryOption(value={"split"}, retain=true)
    @OptionUsage(description={"Split a genotype dataset into smaller subsets based on variant blocks."}, format="split <input> --output <output> [options]")
    String[] split;
    @EntryOption(value={"sort"}, retain=true)
    @OptionUsage(description={"Sort the variants in *.gtb by coordinate fields (CHROM, POS)."}, format="sort <input> --output <output> [options]")
    String[] sort;
    @EntryOption(value={"refine"}, retain=true)
    @OptionUsage(description={"\u4f18\u5316 CCF \u6587\u4ef6."}, format="refine <input> --output <output> [options]")
    String[] refine;
    @EntryOption(value={"merge"}, retain=true)
    @OptionUsage(description={"\u5408\u5e76  GTB \u6587\u4ef6 (\u5f00\u53d1\u7248\u672c, \u65b0\u7b97\u6cd5\u5b9e\u65bd\u4e2d)."}, format="merge <major> <minor> --output <output> [options]")
    String[] merge;
    @EntryOption(value={"gui"})
    @OptionUsage(description={"Display the *.gtb file in the visualization software window."}, format="gui <input> [options]")
    String[] gui;
    @EntryOption(value={"ld"})
    @OptionUsage(description={"Calculate pairwise the linkage disequilibrium or genotypic correlation."}, format="ld <input> [output] [options]")
    String[] ld;
    @EntryOption(value={"less"})
    @OptionUsage(description={"Display basic metadata and genotype statistics for various genotype formats."}, format="less <input> [options]")
    String[] less;
    @EntryOption(value={"collect"}, retain=true)
    @OptionUsage(description={"Aggregate GTB/VCF/PLINK data by extracting site coordinates and/or individuals information."}, format="collect <input> <input> ... --output <output> [options]")
    String[] collect;
    @EntryOption(value={"make-database"}, retain=false)
    @OptionUsage(description={"Convert database resources into GTB format for high-performance genomic annotation."}, format="make-database [options]")
    String[] makeDatabase;

    public static void main(String[] args) throws IOException {
        GBCEntry program = new GBCEntry();
        CommandOptions options = program.parse(args);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (options.passed("convert")) {
            ConverterEntry.main((String[])options.value("convert"));
            return;
        }
        if (options.passed("concat")) {
            ConcatGTBCommandProgram.main((String[])options.value("concat"));
            return;
        }
        if (options.passed("split")) {
            SplitGTBCommandProgram.main((String[])options.value("split"));
            return;
        }
        if (options.passed("sort")) {
            GTBSortCommandProgram.main((String[])options.value("sort"));
            return;
        }
        if (options.passed("refine")) {
            GTBRefineCommandProgram.main((String[])options.value("refine"));
            return;
        }
        if (options.passed("merge")) {
            GTBMergerCommandProgram.main((String[])options.value("merge"));
            return;
        }
        if (options.passed("ld")) {
            LDCalculatorProgram.main((String[])options.value("ld"));
            return;
        }
        if (options.passed("gui")) {
            GUIProgram.main((String[])options.value("gui"));
            return;
        }
        if (options.passed("less")) {
            LessProgram.main((String[])options.value("less"));
            return;
        }
        if (options.passed("make-database")) {
            MakeDatabaseCommandProgram.main((String[])options.value("make-database"));
            return;
        }
        if (options.passed("collect")) {
            CollectProgram.main((String[])options.value("collect"));
            return;
        }
        if (options.passed("rs-query")) {
            return;
        }
    }
}

