/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command;

import edu.sysu.pmglab.commandParser.converter.IConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import gnu.trove.map.hash.THashMap;
import java.util.Map;

public enum GenomicCoordinatesSelectionConverter implements IConverter<Map<Chromosome, List<IntInterval>>>
{
    INSTANCE;


    public static Map<Chromosome, IntIntervalTree<Void>> toIntervalTree(Map<Chromosome, List<IntInterval>> poses) {
        if (poses == null) {
            return null;
        }
        THashMap<Chromosome, IntIntervalTree<Void>> trees = new THashMap<Chromosome, IntIntervalTree<Void>>();
        for (Chromosome chromosome : poses.keySet()) {
            List<IntInterval> intervals = poses.get(chromosome);
            if (intervals == null) {
                trees.put(chromosome, null);
                continue;
            }
            IntIntervalTree.Builder builder = new IntIntervalTree.Builder();
            for (IntInterval interval : intervals) {
                builder.add(interval, null);
            }
            trees.put(chromosome, builder.build());
        }
        return trees;
    }

    @Override
    public Map<Chromosome, List<IntInterval>> convert(String name, String ... values2) {
        THashMap<Chromosome, List<IntInterval>> containers = new THashMap<Chromosome, List<IntInterval>>();
        for (String coordinates : values2) {
            List<IntInterval> intervals;
            Chromosome chromosome;
            if ((coordinates = coordinates.trim()).length() == 0) continue;
            int index = coordinates.indexOf(":");
            if (index == -1) {
                containers.put(Chromosome.get(coordinates), null);
                continue;
            }
            if (index == coordinates.length() - 1 || containers.containsKey(chromosome = Chromosome.get(coordinates.substring(0, index))) && containers.get(chromosome) == null) continue;
            String[] rules = coordinates.substring(index + 1).split(",");
            if (containers.containsKey(chromosome)) {
                intervals = (List<IntInterval>)containers.get(chromosome);
            } else {
                intervals = new List<IntInterval>();
                containers.put(chromosome, intervals);
            }
            for (String rule : rules) {
                int end;
                int rangeSep = rule.indexOf("-");
                if (rangeSep == -1) {
                    rangeSep = rule.indexOf("~");
                }
                if (rangeSep == -1) {
                    int pos = Integer.parseInt(rule);
                    if (pos < 1) continue;
                    intervals.add(new IntInterval(pos, pos));
                    continue;
                }
                int start = rangeSep == 0 ? 1 : Integer.parseInt(rule.substring(0, rangeSep));
                int n = end = rangeSep == rule.length() - 1 ? Integer.MAX_VALUE : Integer.parseInt(rule.substring(rangeSep + 1));
                if (start > end) {
                    throw new ParameterException("Invalid parameter: \"" + name + "\" accepted a interval where start > end");
                }
                if (end < 1) continue;
                if (start < 1) {
                    start = 1;
                }
                if (start == 1 && end == Integer.MAX_VALUE) {
                    containers.put(chromosome, null);
                    continue;
                }
                intervals.add(new IntInterval(start, end));
            }
        }
        for (Chromosome chromosome : containers.keySet()) {
            List intervals = (List)containers.get(chromosome);
            if (intervals == null) continue;
            intervals.sort(IntInterval::compareTo);
            containers.put(chromosome, IntInterval.merge(intervals));
        }
        return containers;
    }
}

