/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command;

import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.commandParser.converter.IConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFHeader;
import java.io.IOException;

public enum IndividualsSelectionConverter implements IConverter<IndexableSet<String>>
{
    INSTANCE;


    @Override
    public IndexableSet<String> convert(String name, String ... values2) {
        if (values2.length == 0 || values2.length == 1 && values2[0].length() == 0) {
            return IndexableSet.EMPTY();
        }
        if (values2.length == 1) {
            LinkedSet<String> individuals = new LinkedSet<String>();
            String sequence2 = values2[0];
            int offset = 0;
            int l = sequence2.length();
            for (int i = 0; i < l; ++i) {
                if (sequence2.charAt(i) != ',' && sequence2.charAt(i) != ';' && sequence2.charAt(i) != ' ' && sequence2.charAt(i) != '\t') continue;
                String individual = sequence2.substring(offset, i);
                this.addIndividual(individual, individuals);
                offset = i + 1;
            }
            if (offset < sequence2.length()) {
                this.addIndividual(sequence2.substring(offset), individuals);
            }
            return individuals;
        }
        LinkedSet<String> individuals = new LinkedSet<String>();
        for (String individual : values2) {
            this.addIndividual(individual, individuals);
        }
        return individuals;
    }

    void addIndividual(String individual, IndexableSet<String> container) {
        if (!VCFHeader.isValidIndividual(individual)) {
            throw new ParameterException("Invalid individual: " + individual);
        }
        if (container.contains(individual)) {
            throw new ParameterException("Duplicated individual: " + individual);
        }
        container.add(individual);
    }

    public static void main(String[] args) throws IOException {
        ThreadLocal<CCFReader> rs = new ThreadLocal<CCFReader>();
        rs.set(new CCFReader("/Users/suranyi/Desktop/CADD_v1.7.hg38.1kw.gtb"));
    }
}

