/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command;

import edu.sysu.pmglab.commandParser.converter.IConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.utils.Assert;

public enum LiftoverConverter implements IConverter<LiftOver>
{
    INSTANCE;


    @Override
    public LiftOver convert(String name, String ... values2) {
        Assert.that(values2.length == 1);
        if (values2[0].length() == 0) {
            return LiftOver.ITSELF;
        }
        if (values2[0].equalsIgnoreCase("hg19ToHg38")) {
            return LiftOver.hg19ToHg38;
        }
        if (values2[0].equalsIgnoreCase("hg38ToHg19")) {
            return LiftOver.hg38ToHg19;
        }
        if (values2[0].equalsIgnoreCase("hg18ToHg19")) {
            return LiftOver.hg18ToHg19;
        }
        if (values2[0].equalsIgnoreCase("hg18ToHg38")) {
            return LiftOver.hg18ToHg38;
        }
        throw new ParameterException("UCSC liftover resource not found: " + values2[0]);
    }
}

