/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command;

import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.converter.IConverter;
import edu.sysu.pmglab.commandParser.validator.range.Double_0_1_RangeValidator;
import edu.sysu.pmglab.container.interval.DoubleInterval;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.iterator.FilterIterator;
import edu.sysu.pmglab.container.iterator.SingletonIterable;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant.VariantHWEController;

public class VariantProcessOptions {
    @Option(names={"--prune"}, type=FieldType.NULL)
    @OptionUsage(group="Subset Selection Options", description={"Remove alternative alleles (excluding REF) with an allele count of 0."})
    boolean prune = false;
    @Option(names={"--allele-num"}, type=FieldType.intInterval)
    @OptionUsage(group="Subset Selection Options", format="--allele-num <min>~<max>", description={"Exclude variants with the alternative allele number per variant outside the range [min, max]."})
    IntInterval alleleNums;
    @CustomOption(names={"--biallelic"}, converter=BiallelicModeConverter.class, arity={0, 1})
    @OptionUsage(description={"Convert multiallelic variant to biallelic variant and correct redundant suffixes of REF and ALT bases. Supports the following parameters:", "* SET_TO_MISSING (default): Set other genotypes (>= 2) to missing. This may result in half-calling genotypes like ./1.", "* SET_TO_REF: Set other genotypes (>= 2) to the reference allele.", "* DISCARD_GENOTYPE: Discard other genotypes (>= 2) entirely, which will result in loss of information."}, format="--biallelic [SET_TO_MISSING/SET_TO_REF/DISCARD_GENOTYPE]", group="Subset Selection Options")
    Variant.BiallelicMode biallelic = null;
    @Option(names={"--hwe"}, type=FieldType.float64, validator=Double_0_1_RangeValidator.class)
    @OptionUsage(group="Subset Selection Options", format="--hwe <double>", description={"Exclude variants that have a Hardy-Weinberg Equilibrium (HWE) p-value less than the specified threshold (e.g., 1e-6)."})
    double hwe = Double.NaN;
    @Option(names={"--seq-ac"}, type=FieldType.intInterval)
    @OptionUsage(group="Subset Selection Options", format="--seq-ac <minAc>~<maxAc>", description={"Exclude variants with the alternate allele count (AC) per variant outside the range [minAc, maxAc].", "If a subset selection occurs, this filter applies to the genotype sequences after selection."})
    IntInterval ac = null;
    @Option(names={"--seq-an"}, type=FieldType.intInterval)
    @OptionUsage(group="Subset Selection Options", format="--seq-an <minAn>~<maxAn>", description={"Exclude variants with the non-missing allele number (AN) per variant outside the range [minAn, maxAn].", "If a subset selection occurs, this filter applies to the genotype sequences after selection."})
    IntInterval an = null;
    @Option(names={"--seq-af"}, type=FieldType.doubleInterval)
    @OptionUsage(group="Subset Selection Options", format="--seq-af <minAf>~<maxAf>", description={"Exclude variants with the alternate allele frequency (AF) per variant outside the range [minAf, maxAf].", "If a subset selection occurs, this filter applies to the genotype sequences after selection."})
    DoubleInterval af = null;

    public ILiteConverter<Variant, Iterable<Variant>> getVariantConverter() {
        return new ILiteConverter<Variant, Iterable<Variant>>(){
            final IFilter<Variant> filter;
            {
                this.filter = VariantProcessOptions.this.getFilter();
            }

            @Override
            public Iterable<Variant> converter(Variant input) {
                if (VariantProcessOptions.this.prune) {
                    input.prune();
                }
                if (VariantProcessOptions.this.alleleNums != null && !VariantProcessOptions.this.alleleNums.contains(input.numOfAlleles())) {
                    return null;
                }
                if (VariantProcessOptions.this.biallelic == null) {
                    if (this.filter.filter(input)) {
                        return new SingletonIterable<Variant>(input);
                    }
                    return null;
                }
                List<Variant> variants = input.biallelic(VariantProcessOptions.this.biallelic);
                if (variants.size() == 0) {
                    return null;
                }
                if (variants.size() == 1) {
                    if (this.filter.filter(variants.fastGet(0))) {
                        return variants;
                    }
                    return null;
                }
                return () -> new FilterIterator<Variant>(variants.iterator(), this.filter);
            }
        };
    }

    private IFilter<Variant> getFilter() {
        return new IFilter<Variant>(){
            final VariantHWEController hwe;
            {
                this.hwe = Double.isNaN(VariantProcessOptions.this.hwe) ? null : new VariantHWEController(VariantProcessOptions.this.hwe, true);
            }

            @Override
            public boolean filter(Variant input) {
                ICounter counter = input.getGenotypes().counter();
                if (VariantProcessOptions.this.ac != null && !VariantProcessOptions.this.ac.contains(counter.getAC())) {
                    return false;
                }
                if (VariantProcessOptions.this.an != null && !VariantProcessOptions.this.an.contains(counter.getAN())) {
                    return false;
                }
                if (VariantProcessOptions.this.af != null && !VariantProcessOptions.this.af.contains(counter.getAF())) {
                    return false;
                }
                return this.hwe == null || this.hwe.filter(input);
            }
        };
    }

    static enum BiallelicModeConverter implements IConverter<Variant.BiallelicMode>
    {
        INSTANCE;


        @Override
        public Variant.BiallelicMode convert(String name, String ... values2) {
            if (values2.length == 0) {
                return Variant.BiallelicMode.SET_TO_MISSING;
            }
            return Variant.BiallelicMode.valueOf(values2[0].toUpperCase());
        }
    }
}

