/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.database;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.annotator.DatabaseException;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.toolkit.input.TextInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.DynamicOption;
import edu.sysu.pmglab.commandParser.annotation.option.Indirect;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.rule.Counter;
import edu.sysu.pmglab.commandParser.annotation.rule.Rule;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.command.LiftoverConverter;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.RefGenomeVersion;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.annotator.CADD;
import edu.sysu.pmglab.gtb.toolkit.annotator.ClinVar;
import edu.sysu.pmglab.gtb.toolkit.annotator.Conservation;
import edu.sysu.pmglab.gtb.toolkit.annotator.DBNSFP_RankScore;
import edu.sysu.pmglab.gtb.toolkit.annotator.DBSNP;
import edu.sysu.pmglab.gtb.toolkit.annotator.EpiMap;
import edu.sysu.pmglab.gtb.toolkit.annotator.FAVOR;
import edu.sysu.pmglab.gtb.toolkit.annotator.GNOMAD;
import edu.sysu.pmglab.gtb.toolkit.annotator.PEXT;
import edu.sysu.pmglab.gtb.toolkit.annotator.RegBase;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import edu.sysu.pmglab.utils.Downloader;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="make-database [options]", usage_item={@UsageItem(key="About", value={"Convert database resources into GTB format for high-performance genomic annotation."})}, rule=@Rule(counter={@Counter(item={"--cadd", "--clinvar", "--conservation", "--dbnsfp", "--dbsnp", "--epimap", "--favor", "--gnomad", "--gwas", "--pext", "--regbase"}, rule=Counter.Type.EQUAL)}), indirect=@Indirect(enable=true))
public class MakeDatabaseCommandProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(MakeDatabaseCommandProgram.class);
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--silent"}, type=FieldType.NULL)
    @OptionUsage(description={"Suppress terminal output logs."})
    boolean silent = false;
    @Option(names={"--output", "-o"}, type=FieldType.file, required=true)
    @OptionUsage(description={"Set the output file path."}, format="--output <file>")
    File output;
    @DynamicOption(names={"--cadd"}, args={"path", "liftover="})
    @OptionUsage(description={"Create the CADD database file."}, item={@UsageItem(key="Source", value={"https://cadd.gs.washington.edu"}), @UsageItem(key="Version", value={"CADDv1.7"})}, format="--cadd <path> [liftover]", group="Database Options")
    Map<String, String> cadd;
    @DynamicOption(names={"--clinvar"}, args={"path=", "version=", "refGenomeVersion=hg38"})
    @OptionUsage(description={"Create the ClinVar database file.", "If 'path' is missing, the original file will be matched and downloaded based on 'version' and 'refGenomeVersion'"}, item={@UsageItem(key="Source", value={"https://ftp.ncbi.nih.gov/snp/redesign/archive/"})}, format="--clinvar [path] [version] [refGenomeVersion=hg38]", group="Database Options")
    Map<String, String> clinvar;
    @DynamicOption(names={"--conservation"}, args={"path", "liftover="})
    @OptionUsage(description={"Create the Conservation database file."}, item={@UsageItem(key="Source", value={"https://github.com/mulinlab/regBase?tab=readme-ov-file"})}, format="--conservation <path> [liftover]", group="Database Options")
    Map<String, String> conservation;
    @DynamicOption(names={"--dbnsfp"}, args={"path", "refGenomeVersion=hg38"})
    @OptionUsage(description={"Create the DBNSFP_RankScore database file."}, item={@UsageItem(key="Source", value={"https://www.dbnsfp.org/home"}), @UsageItem(key="Version", value={"dbNSFPv5.0"})}, format="--dbnsfp path=<file1>,<file2>,... [liftover]", group="Database Options")
    Map<String, String> dbnsfp;
    @DynamicOption(names={"--dbsnp"}, args={"path", "liftover="})
    @OptionUsage(description={"Create the DBSNP database file."}, item={@UsageItem(key="Source", value={"https://ftp.ncbi.nih.gov/snp/redesign/archive/"}), @UsageItem(key="Version", value={"DBSNP_157"})}, format="--dbsnp <path> [liftover]", group="Database Options")
    Map<String, String> dbsnp;
    @DynamicOption(names={"--epimap"}, args={"path=", "liftover=", "subject=", "marker=", "field="})
    @OptionUsage(description={"Create the EpiMap database file.", "If 'path' is missing, the original file will be matched and downloaded based on 'subject' and 'marker'"}, item={@UsageItem(key="Source", value={"https://epigenome.wustl.edu/epimap/data/imputed/"})}, format="--epimap [path] [liftover] [subject] [marker] [field]", group="Database Options")
    Map<String, String> epimap;
    @DynamicOption(names={"--favor"}, args={"path", "liftover="})
    @OptionUsage(description={"Create the FAVOR database file."}, item={@UsageItem(key="Source", value={"https://favor.genohub.org"}), @UsageItem(key="Version", value={"FAVOR_1.0"})}, format="--favor path=<file1>,<file2>,... [liftover]", group="Database Options")
    Map<String, String> favor;
    @DynamicOption(names={"--gnomad"}, args={"path", "liftover="})
    @OptionUsage(description={"Create the GNOMAD database file."}, item={@UsageItem(key="Source", value={"https://gnomad.broadinstitute.org"}), @UsageItem(key="Version", value={"gnomADv4.1"})}, format="--gnomad path=<file1>,<file2>,... [liftover]", group="Database Options")
    Map<String, String> gnomad;
    @DynamicOption(names={"--gwas"}, args={"path", "group=", "liftover="})
    @OptionUsage(description={"Create the GWAS Summary database file."}, item={@UsageItem(key="Source", value={"https://www.ebi.ac.uk/gwas/"})}, format="--gwas <path> [group] [liftover]", group="Database Options")
    Map<String, String> gwas;
    @DynamicOption(names={"--pext"}, args={"path", "liftover="})
    @OptionUsage(description={"Create the PEXT database file."}, item={@UsageItem(key="Source", value={"https://github.com/macarthur-lab/tx_annotation"})}, format="--pext <path> [liftover]", group="Database Options")
    Map<String, String> pext;
    @DynamicOption(names={"--regbase"}, args={"path", "liftover="})
    @OptionUsage(description={"Create the regBase database file."}, item={@UsageItem(key="Source", value={"https://github.com/mulinlab/regBase?tab=readme-ov-file"}), @UsageItem(key="Version", value={"regBase_v1.1.1"})}, format="--regbase <path> [liftover]", group="Database Options")
    Map<String, String> regbase;

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        final MakeDatabaseCommandProgram program = new MakeDatabaseCommandProgram();
        if (args.length == 1 && args[0].equals("make-database")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (program.cadd != null) {
            CADD.buildFrom(program.cadd.get("path")).setOutput(program.output).liftover(LiftoverConverter.INSTANCE.convert("--cadd", program.cadd.get("liftover"))).resume(false).build(program.threads);
        }
        if (program.clinvar != null) {
            if (program.clinvar.get("path").length() > 0) {
                ClinVar.buildFrom(program.clinvar.get("path")).setOutput(program.output).silent(program.silent).resume(false).build(program.threads);
            } else {
                String tempName;
                String webSite;
                String version = program.clinvar.get("version");
                String refGenomeVersion = program.clinvar.get("refGenomeVersion").toLowerCase();
                if (!refGenomeVersion.equals("hg19") && !refGenomeVersion.equals("hg38")) {
                    throw new DatabaseException("The clinvar database only provides hg19 and hg38 reference genome versions");
                }
                if (refGenomeVersion.equals("hg19")) {
                    if (version.length() == 0) {
                        webSite = "https://ftp.ncbi.nlm.nih.gov/pub/clinvar/vcf_GRCh37/weekly/clinvar.vcf.gz";
                        tempName = "clinvar.hg19.vcf.gz";
                    } else {
                        webSite = "https://ftp.ncbi.nlm.nih.gov/pub/clinvar/vcf_GRCh37/weekly/clinvar_" + version + ".vcf.gz";
                        tempName = "clinvar_" + version + ".hg19.vcf.gz";
                    }
                } else if (version.length() == 0) {
                    webSite = "https://ftp.ncbi.nlm.nih.gov/pub/clinvar/vcf_GRCh38/weekly/clinvar.vcf.gz";
                    tempName = "clinvar.hg38.vcf.gz";
                } else {
                    webSite = "https://ftp.ncbi.nlm.nih.gov/pub/clinvar/vcf_GRCh38/weekly/clinvar_" + version + ".vcf.gz";
                    tempName = "clinvar_" + version + ".hg38.vcf.gz";
                }
                LiveFile source2 = LiveFile.of(webSite);
                File temp = RuntimeProperty.createFile(tempName);
                new Downloader(source2, temp).setThreads(1).resume(true).silent(program.silent).download();
                ClinVar.buildFrom(temp).setOutput(program.output).silent(program.silent).resume(false).build(program.threads);
            }
        }
        if (program.conservation != null) {
            Conservation.buildFrom(program.conservation.get("path")).setOutput(program.output).liftover(LiftoverConverter.INSTANCE.convert("--conservation", program.conservation.get("liftover"))).resume(false).build(program.threads);
        }
        if (program.dbnsfp != null) {
            DBNSFP_RankScore.buildFrom(List.wrap(program.dbnsfp.get("path").split(",")).apply(path -> {
                try {
                    return LiveFile.of(path);
                }
                catch (IOException e) {
                    return null;
                }
            })).setOutput(program.output).setRefGenomeVersion(RefGenomeVersion.valueOf(program.dbnsfp.get("refGenomeVersion"))).resume(false).build(program.threads);
        }
        if (program.dbsnp != null) {
            DBSNP.buildFrom(program.dbsnp.get("path")).setOutput(program.output).liftover(LiftoverConverter.INSTANCE.convert("--dbsnp", program.dbsnp.get("liftover"))).resume(false).build(program.threads);
        }
        if (program.epimap != null) {
            if (program.epimap.get("path").length() > 0) {
                EpiMap.buildFrom(program.epimap.get("path")).setOutput(program.output).liftover(LiftoverConverter.INSTANCE.convert("--epimap", program.epimap.get("liftover"))).setMarker(program.epimap.get("field").length() > 0 ? program.epimap.get("field") : null).resume(false).build(program.threads);
            } else {
                LiveFile source3 = LiveFile.of("https://epigenome.wustl.edu/epimap/data/imputed/impute_" + program.epimap.get("subject") + "_" + program.epimap.get("marker") + ".bigWig");
                File temp = RuntimeProperty.createFile(source3.getName());
                new Downloader(source3, temp).setThreads(1).resume(true).silent(program.silent).download();
                EpiMap.buildFrom(temp).setOutput(program.output).liftover(LiftoverConverter.INSTANCE.convert("--epimap", program.epimap.get("liftover"))).setMarker(program.epimap.get("field").length() > 0 ? program.epimap.get("field") : null).resume(false).build(program.threads);
            }
        }
        if (program.favor != null) {
            FAVOR.buildFrom(List.wrap(program.favor.get("path").split(",")).apply(path -> {
                try {
                    return LiveFile.of(path);
                }
                catch (IOException e) {
                    return null;
                }
            })).setOutput(program.output).liftover(LiftoverConverter.INSTANCE.convert("--favor", program.favor.get("liftover"))).resume(false).build(program.threads);
        }
        if (program.gnomad != null) {
            GNOMAD.buildFrom(List.wrap(program.gnomad.get("path").split(",")).apply(path -> {
                try {
                    return LiveFile.of(path);
                }
                catch (IOException e) {
                    return null;
                }
            })).setOutput(program.output).liftover(LiftoverConverter.INSTANCE.convert("--gnomad", program.gnomad.get("liftover"))).resume(false).build(program.threads);
        }
        if (program.gwas != null) {
            String group = program.gwas.get("group").length() == 0 ? null : program.gwas.get("group");
            final IFieldCollection fields = new FieldGroupMetas().addField(null, "ID", FieldType.string).addField(group, "beta", FieldType.float32).addField(group, "standard_error", FieldType.float32).addField(group, "p_value", FieldType.float32).addField(group, "odds_ratio", FieldType.float32).addField(group, "ci_lower", FieldType.float32).addField(group, "ci_uppebeta", FieldType.float32).addField(group, "effect_allele_frequency", FieldType.float32).asUnmodifiable();
            Processor.setInput(new TextInputOption(program.gwas.get("path")).setMetadataParser(IMetadataParser.NO_METADATA).setHeaderParser(IHeaderParser.FIRST_LINE)).setOutput(new GTBOutputOption(program.output).addFields(fields).addMeta(CCFMetaItem.of("Database", "<Name=GWAS,Source=\"" + program.gwas.get("path") + "\">"))).bridge(new ILiteConverter<TextRecord, Variant>(){
                final LiftOver liftover;
                {
                    this.liftover = LiftoverConverter.INSTANCE.convert("--gwas", program.gwas.get("liftover"));
                }

                @Override
                public Variant converter(TextRecord input) throws IOException {
                    Coordinate coordinate = new Coordinate(input.get("chromosome").toString(), input.get("base_pair_location").toInt());
                    if (this.liftover != null && (coordinate = this.liftover.convert(coordinate)) == null) {
                        return null;
                    }
                    Variant variant = new Variant(coordinate);
                    variant.setProperty("ID", input.containsKey("variant_id") ? input.get("variant_id").toString() : ".");
                    variant.addAllele(input.get("other_allele").toString());
                    variant.addAllele(input.get("effect_allele").toString());
                    for (FieldMeta field : fields) {
                        if (!input.containsKey(field.simpleName())) continue;
                        variant.setProperty(field.fullName(), input.get(field.simpleName()));
                    }
                    return variant;
                }
            }).setListener(program.silent ? null : new InputListener()).submit(program.threads);
            GTBSorter sorter = GTBSorter.setInput(program.output, new String[0]).setListener(program.silent ? null : new SortListener());
            if (!sorter.isOrdered(program.threads)) {
                sorter.sort(program.output, program.threads, false);
            }
            GTBIndexer.setInput(program.output, new String[0]).setListener(program.silent ? null : new InputListener("Indexed", "records")).save(program.threads);
        }
        if (program.pext != null) {
            PEXT.buildFrom(program.pext.get("path")).setOutput(program.output).liftover(LiftoverConverter.INSTANCE.convert("--pext", program.pext.get("liftover"))).resume(false).build(program.threads);
        }
        if (program.regbase != null) {
            RegBase.buildFrom(program.regbase.get("path")).setOutput(program.output).liftover(LiftoverConverter.INSTANCE.convert("--regbase", program.regbase.get("liftover"))).resume(false).build(program.threads);
        }
    }
}

