/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.input;

import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.command.GenomicCoordinatesSelectionConverter;
import edu.sysu.pmglab.gtb.command.IndividualsSelectionConverter;
import edu.sysu.pmglab.gtb.command.LiftoverConverter;
import edu.sysu.pmglab.gtb.command.input.StandardVariantInputCommandOptions;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.IOException;
import java.util.Map;

public class GTBInputCommandOptions {
    @Option(names={"--input-field"}, type=FieldType.string, container=Container.LIST)
    @OptionUsage(description={"Specify the fields to be read from the input file. If no fields are specified, all fields will be read by default."}, format="--input-field <field> <field> ...", group="Input Options")
    List<String> readInFields = null;
    @CustomOption(names={"--liftover"}, converter=LiftoverConverter.class)
    @OptionUsage(description={"Lift over variants from one reference genome version to another.", "Chain files are auto-downloaded from http://hgdownload.cse.ucsc.edu/goldenPath/<version>/liftOver"}, format="--liftover <chain>", item={@UsageItem(key="Available", value={"hg19ToHg38, hg38ToHg19, hg18ToHg19, hg18ToHg38"})}, group="Input Options")
    LiftOver liftover = LiftOver.ITSELF;
    @Option(names={"--index-range", "-ir"}, type=FieldType.longInterval)
    @OptionUsage(description={"Retrieve variants within a specified range of variant indices from 'min' (inclusive) to 'max' (exclusive)."}, format="--index-range <min>~<max>")
    LongInterval range = null;
    @CustomOption(names={"--pos"}, converter=GenomicCoordinatesSelectionConverter.class, arity={-1})
    @OptionUsage(description={"Retrieve the variants by the specified coordinate expression of variant.", "The expression can follow one of three formats: '<chr>' for the entire chromosome, '<chr>:<pos>,<pos>,...' for specific positions, or '<chr>:<start>-<end>,<start>-<end>,...' for coordinate ranges."}, format="--pos [expression] [expression] ...", group="Input Options")
    Map<Chromosome, List<IntInterval>> poses = null;
    @CustomOption(names={"--individual"}, converter=IndividualsSelectionConverter.class, arity={-1})
    @OptionUsage(description={"Select a subset of individuals. Individuals not found in the inputs will have their genotype filled with './.'."}, format="--individual <string>,<string>,...", group="Input Options")
    IndexableSet<String> individuals = null;

    public StandardVariantInputCommandOptions<Variant, GTBInputOption> getInputOptions(List<LiveFile> files) throws IOException {
        StandardVariantInputCommandOptions<Variant, GTBInputOption> options = new StandardVariantInputCommandOptions<Variant, GTBInputOption>(null, this.individuals);
        Map<Chromosome, IntIntervalTree<Void>> coordinates = this.liftover == null || this.liftover == LiftOver.ITSELF ? null : GenomicCoordinatesSelectionConverter.toIntervalTree(this.poses);
        for (LiveFile source2 : files) {
            GTBManager manager = new GTBManager(source2);
            options.addIndividuals(manager.getIndividuals());
            GTBInputOption option = manager.getIndividuals().hasOverlaps(options.getIndividuals()) ? new GTBInputOption((GTBReaderOption)new GTBReaderOption(manager, true, this.readInFields == null).addFields(this.readInFields)) : new GTBInputOption((GTBReaderOption)new GTBReaderOption(manager, false, this.readInFields == null).addFields(this.readInFields));
            option.liftover(this.liftover);
            if (this.range != null) {
                option.limit(this.range);
            }
            if (this.poses != null) {
                if (this.liftover == null || this.liftover == LiftOver.ITSELF) {
                    option.selectCoordinates(this.poses);
                } else if (coordinates != null) {
                    option.addFilter(variant -> {
                        if (!coordinates.containsKey(variant.getChromosome())) {
                            return false;
                        }
                        IntIntervalTree tree = (IntIntervalTree)coordinates.get(variant.getChromosome());
                        if (tree == null) {
                            return true;
                        }
                        return tree.contains(variant.getPosition());
                    });
                }
            }
            options.addInput(option);
        }
        for (GTBInputOption option : options) {
            final IntList indexes = options.getIndividuals().findIndicesIn(option.getIndividuals());
            if (indexes == null) continue;
            option.addFilter((IFilter)new IFilter<Variant>(){
                final ThreadLocal<byte[]> bytes = ThreadLocal.withInitial(() -> new byte[indexes.size()]);
                final ThreadLocal<short[]> shorts = ThreadLocal.withInitial(() -> new short[indexes.size()]);
                final ThreadLocal<int[]> ints = ThreadLocal.withInitial(() -> new int[indexes.size()]);

                @Override
                public boolean filter(Variant variant) {
                    int numOfAlleles = variant.getGenotypes().counter().maxAlleleIndex() + 1;
                    if (numOfAlleles <= 15) {
                        variant.setGenotypes(variant.getGenotypes().subGenotypes(indexes, this.bytes.get()));
                    } else if (numOfAlleles <= 255) {
                        variant.setGenotypes(variant.getGenotypes().subGenotypes(indexes, this.shorts.get()));
                    } else {
                        variant.setGenotypes(variant.getGenotypes().subGenotypes(indexes, this.ints.get()));
                    }
                    return true;
                }
            });
        }
        return options;
    }
}

