/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.input;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.input.MAFInputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.validator.range.Float_0_1_RangeValidator;
import edu.sysu.pmglab.commandParser.validator.range.Int_0_RangeValidator;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.command.GenomicCoordinatesSelectionConverter;
import edu.sysu.pmglab.gtb.command.IndividualsSelectionConverter;
import edu.sysu.pmglab.gtb.command.LiftoverConverter;
import edu.sysu.pmglab.gtb.command.input.StandardVariantInputCommandOptions;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.IOException;
import java.util.Map;

public class MAFInputCommandOptions {
    @Option(names={"--collect-mutation"}, type=FieldType.NULL)
    @OptionUsage(description={"Convert individual-level variants at the same coordinate into site-level variants.", "This option discards other individual-level fields in the MAF file (e.g., t_depth)."}, group="Input Options")
    boolean collectMutation = false;
    @CustomOption(names={"--liftover"}, converter=LiftoverConverter.class)
    @OptionUsage(description={"Lift over variants from one reference genome version to another.", "Chain files are auto-downloaded from http://hgdownload.cse.ucsc.edu/goldenPath/<version>/liftOver"}, format="--liftover <chain>", item={@UsageItem(key="Available", value={"hg19ToHg38, hg38ToHg19, hg18ToHg19, hg18ToHg38"})}, group="Input Options")
    LiftOver liftover = LiftOver.ITSELF;
    @CustomOption(names={"--pos"}, converter=GenomicCoordinatesSelectionConverter.class, arity={-1})
    @OptionUsage(description={"Retrieve the variants by the specified coordinate expression of variant.", "The expression can follow one of three formats: '<chr>' for the entire chromosome, '<chr>:<pos>,<pos>,...' for specific positions, or '<chr>:<start>-<end>,<start>-<end>,...' for coordinate ranges."}, format="--pos [expression] [expression] ...", group="Input Options")
    Map<Chromosome, List<IntInterval>> poses = null;
    @CustomOption(names={"--individual"}, converter=IndividualsSelectionConverter.class, arity={-1})
    @OptionUsage(description={"Select a subset of individuals. Individuals not found in the inputs will have their genotype filled with './.'."}, format="--individual <string>,<string>,...", group="Input Options")
    IndexableSet<String> individuals = null;
    @Option(names={"--gty-dp"}, type=FieldType.varInt32, validator=Int_0_RangeValidator.class, defaultTo={"10"})
    @OptionUsage(group="Quality Control Options", format="--gty-dp <minDp>", defaultTo="10", description={"Exclude genotypes with a minimal read depth in the 't_depth' field is < minDp.", "'0' means to disable this filter."})
    int dp = 10;
    @Option(names={"--gty-ac"}, type=FieldType.varInt32, validator=Int_0_RangeValidator.class, defaultTo={"3"})
    @OptionUsage(group="Quality Control Options", format="--gty-ac <minAc>", defaultTo="3", description={"Exclude genotypes with a minimal allele count in the 't_alt_count' field is < minAc.", "'0' means to disable this filter."})
    int ac = 3;
    @Option(names={"--gty-vaf"}, type=FieldType.float32, validator=Float_0_1_RangeValidator.class, defaultTo={"0.05"})
    @OptionUsage(group="Quality Control Options", format="--gty-vaf <minVaf>", defaultTo="0.05", description={"Exclude genotypes with a minimal variant allele frequency (t_alt_count / t_depth) < minVaf.", "'0' means to disable this filter."})
    float vaf = 0.05f;

    public StandardVariantInputCommandOptions<Variant, MAFInputOption> getInputOptions(List<LiveFile> files) throws IOException {
        final StandardVariantInputCommandOptions<Variant, MAFInputOption> options = new StandardVariantInputCommandOptions<Variant, MAFInputOption>(null, this.individuals);
        Map<Chromosome, IntIntervalTree<Void>> coordinates = GenomicCoordinatesSelectionConverter.toIntervalTree(this.poses);
        for (LiveFile file : files) {
            MAFInputOption option = new MAFInputOption(file).liftover(this.liftover);
            if (coordinates != null) {
                option.addFilter(variant -> {
                    if (!coordinates.containsKey(variant.getChromosome())) {
                        return false;
                    }
                    IntIntervalTree tree = (IntIntervalTree)coordinates.get(variant.getChromosome());
                    return tree == null || tree.contains(variant.getPosition());
                });
            }
            if (this.dp > 0) {
                option.addFilter(input -> {
                    Bytes dp = (Bytes)input.getProperty("t_depth");
                    if (dp == null || dp.valueEquals((byte)46)) {
                        return true;
                    }
                    return dp.toInt() >= this.dp;
                });
            }
            if (this.ac > 0) {
                option.addFilter(input -> {
                    Bytes ac = (Bytes)input.getProperty("t_alt_count");
                    if (ac == null || ac.valueEquals((byte)46)) {
                        return true;
                    }
                    return ac.toInt() >= this.ac;
                });
            }
            if (this.vaf > 0.0f) {
                option.addFilter(input -> {
                    Bytes ac = (Bytes)input.getProperty("t_alt_count");
                    Bytes dp = (Bytes)input.getProperty("t_depth");
                    if (ac == null || ac.valueEquals((byte)46) || dp == null || dp.valueEquals((byte)46)) {
                        float score;
                        Bytes vaf = (Bytes)input.getProperty("t_vaf");
                        return vaf == null || vaf.valueEquals((byte)46) || Float.isNaN(score = vaf.toFloat()) || !(score < this.vaf);
                    }
                    float vaf = ac.toFloat() / dp.toFloat();
                    return Float.isNaN(vaf) || vaf >= this.vaf;
                });
            }
            options.addIndividuals(option.getIndividuals());
            options.addInput(option);
        }
        for (final MAFInputOption input2 : options) {
            input2.selectIndividuals(options.getIndividuals());
            input2.addFilter((IFilter)new IFilter<Variant>(){
                final IntList indexes;
                {
                    this.indexes = options.getIndividuals().findIndicesIn(input2.getIndividuals());
                }

                @Override
                public boolean filter(Variant input) {
                    input.setGenotypes(input.getGenotypes().subGenotypes(this.indexes));
                    return true;
                }
            });
        }
        return options;
    }

    public boolean requireCollectMutation() {
        return this.collectMutation;
    }
}

