/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.input;

import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.input.PLINKInputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.annotation.option.Available;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.command.GenomicCoordinatesSelectionConverter;
import edu.sysu.pmglab.gtb.command.IndividualsSelectionConverter;
import edu.sysu.pmglab.gtb.command.LiftoverConverter;
import edu.sysu.pmglab.gtb.command.input.StandardVariantInputCommandOptions;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKFile;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKType;
import java.io.IOException;
import java.util.Map;

public class PLINKInputCommandOptions {
    @Option(names={"--input-type", "-it"}, available=@Available(value={"BED", "PGEN"}, upper=true), defaultTo={"BED"})
    @OptionUsage(description={"Specify the input file type."}, format="--input-type [BED/PGEN]", defaultTo="BED", group="Input Options")
    String type = "BED";
    @CustomOption(names={"--liftover"}, converter=LiftoverConverter.class)
    @OptionUsage(description={"Lift over variants from one reference genome version to another.", "Chain files are auto-downloaded from http://hgdownload.cse.ucsc.edu/goldenPath/<version>/liftOver"}, format="--liftover <chain>", item={@UsageItem(key="Available", value={"hg19ToHg38, hg38ToHg19, hg18ToHg19, hg18ToHg38"})}, group="Input Options")
    LiftOver liftover = LiftOver.ITSELF;
    @Option(names={"--index-range", "-ir"}, type=FieldType.longInterval)
    @OptionUsage(description={"Retrieve variants within a specified range of variant indices from 'min' (inclusive) to 'max' (exclusive)."}, format="--index-range <min>~<max>")
    LongInterval range = null;
    @CustomOption(names={"--pos"}, converter=GenomicCoordinatesSelectionConverter.class, arity={-1})
    @OptionUsage(description={"Retrieve the variants by the specified coordinate expression of variant.", "The expression can follow one of three formats: '<chr>' for the entire chromosome, '<chr>:<pos>,<pos>,...' for specific positions, or '<chr>:<start>-<end>,<start>-<end>,...' for coordinate ranges."}, format="--pos [expression] [expression] ...", group="Input Options")
    Map<Chromosome, List<IntInterval>> poses = null;
    @CustomOption(names={"--individual"}, converter=IndividualsSelectionConverter.class, arity={-1})
    @OptionUsage(description={"Select a subset of individuals. Individuals not found in the inputs will have their genotype filled with './.'."}, format="--individual <string>,<string>,...", group="Input Options")
    IndexableSet<String> individuals = null;

    public StandardVariantInputCommandOptions<Variant, PLINKInputOption> getInputOptions(List<String> files) throws IOException {
        StandardVariantInputCommandOptions<Variant, PLINKInputOption> options = new StandardVariantInputCommandOptions<Variant, PLINKInputOption>(null, this.individuals);
        Map<Chromosome, IntIntervalTree<Void>> coordinates = this.liftover == null || this.liftover == LiftOver.ITSELF ? null : GenomicCoordinatesSelectionConverter.toIntervalTree(this.poses);
        for (String source2 : files) {
            PLINKFile file = PLINKFile.load(source2, PLINKType.valueOf(this.type));
            options.addIndividuals(file.getIndividuals());
            PLINKInputOption option = file.getIndividuals().hasOverlaps(options.getIndividuals()) ? new PLINKInputOption(file, true) : new PLINKInputOption(file, false);
            option.liftover(this.liftover);
            if (this.range != null) {
                option.limit(this.range);
            }
            if (this.poses != null && coordinates != null) {
                option.addFilter(variant -> {
                    if (!coordinates.containsKey(variant.getChromosome())) {
                        return false;
                    }
                    IntIntervalTree tree = (IntIntervalTree)coordinates.get(variant.getChromosome());
                    if (tree == null) {
                        return true;
                    }
                    return tree.contains(variant.getPosition());
                });
            }
            options.addInput(option);
        }
        for (PLINKInputOption option : options) {
            final IntList indexes = options.getIndividuals().findIndicesIn(option.getIndividuals());
            if (indexes == null) continue;
            option.addFilter((IFilter)new IFilter<Variant>(){
                final ThreadLocal<byte[]> bytes = ThreadLocal.withInitial(() -> new byte[indexes.size()]);
                final ThreadLocal<short[]> shorts = ThreadLocal.withInitial(() -> new short[indexes.size()]);
                final ThreadLocal<int[]> ints = ThreadLocal.withInitial(() -> new int[indexes.size()]);

                @Override
                public boolean filter(Variant variant) {
                    int numOfAlleles = variant.getGenotypes().counter().maxAlleleIndex() + 1;
                    if (numOfAlleles <= 15) {
                        variant.setGenotypes(variant.getGenotypes().subGenotypes(indexes, this.bytes.get()));
                    } else if (numOfAlleles <= 255) {
                        variant.setGenotypes(variant.getGenotypes().subGenotypes(indexes, this.shorts.get()));
                    } else {
                        variant.setGenotypes(variant.getGenotypes().subGenotypes(indexes, this.ints.get()));
                    }
                    return true;
                }
            });
        }
        return options;
    }

    public PLINKType getInputType() {
        return PLINKType.valueOf(this.type);
    }
}

