/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.input;

import edu.sysu.pmglab.ccf.toolkit.input.InputOption;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.Variant;
import java.util.Iterator;
import java.util.function.Function;

public class StandardVariantInputCommandOptions<I, T extends InputOption<I, ?, ?>>
implements Iterable<T> {
    final List<T> inputs = new List();
    final Function<I, Variant> converter;
    final IndexableSet<String> individuals;
    final boolean addable;

    public StandardVariantInputCommandOptions(Function<I, Variant> converter, IndexableSet<String> individuals) {
        this.converter = converter;
        this.individuals = individuals == null ? new LinkedSet() : individuals.asUnmodifiable();
        this.addable = individuals == null;
    }

    public StandardVariantInputCommandOptions<I, T> addInput(T input) {
        this.inputs.add(input);
        return this;
    }

    public boolean addIndividuals(IndexableSet<String> individuals) {
        if (this.addable) {
            this.individuals.addAll(individuals);
            return true;
        }
        return false;
    }

    public IndexableSet<String> getIndividuals() {
        return this.individuals;
    }

    public Variant convert(I input) {
        if (this.converter == null) {
            return (Variant)input;
        }
        return this.converter.apply(input);
    }

    public int size() {
        return this.inputs.size();
    }

    public T get(int index) {
        return (T)((InputOption)this.inputs.get(index));
    }

    @Override
    public Iterator<T> iterator() {
        return this.inputs.iterator();
    }
}

