/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.input;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.filter.IObjectObjectFilter;
import edu.sysu.pmglab.ccf.toolkit.input.TextInputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOption;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.converter.TextSeparatorConverter;
import edu.sysu.pmglab.commandParser.rule.CountRule;
import edu.sysu.pmglab.commandParser.rule.IRule;
import edu.sysu.pmglab.commandParser.usage.summary.IParsingSummary;
import edu.sysu.pmglab.container.array.StringArray;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.command.GenomicCoordinatesSelectionConverter;
import edu.sysu.pmglab.gtb.command.IndividualsSelectionConverter;
import edu.sysu.pmglab.gtb.command.LiftoverConverter;
import edu.sysu.pmglab.gtb.command.input.StandardVariantInputCommandOptions;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.genome.genotype.cache.CacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.ConstantGenotypes;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import edu.sysu.pmglab.io.text.reader.ISeparator;
import edu.sysu.pmglab.io.text.reader.Separator;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;

public class TEXTInputCommandOptions {
    @CustomOption(names={"--liftover"}, converter=LiftoverConverter.class)
    @OptionUsage(description={"Lift over variants from one reference genome version to another.", "Chain files are auto-downloaded from http://hgdownload.cse.ucsc.edu/goldenPath/<version>/liftOver"}, format="--liftover <chain>", item={@UsageItem(key="Available", value={"hg19ToHg38, hg38ToHg19, hg18ToHg19, hg18ToHg38"})}, group="Input Options")
    LiftOver liftover = LiftOver.ITSELF;
    @CustomOption(names={"--pos"}, converter=GenomicCoordinatesSelectionConverter.class, arity={-1})
    @OptionUsage(description={"Retrieve the variants by the specified coordinate expression of variant.", "The expression can follow one of three formats: '<chr>' for the entire chromosome, '<chr>:<pos>,<pos>,...' for specific positions, or '<chr>:<start>-<end>,<start>-<end>,...' for coordinate ranges."}, format="--pos [expression] [expression] ...", group="Input Options")
    Map<Chromosome, List<IntInterval>> poses = null;
    @CustomOption(names={"--individual"}, converter=IndividualsSelectionConverter.class, arity={-1})
    @OptionUsage(description={"Select a subset of individuals. Individuals not found in the inputs will have their genotype filled with './.'."}, format="--individual <string>,<string>,...", group="Input Options")
    IndexableSet<String> individuals = null;
    @Option(names={"--meta-starts-with"}, defaultTo={"##"})
    @OptionUsage(description={"Specify the prefix used to identify metadata lines in the input file."}, format="--meta-starts-with <string>", defaultTo="##", group="Text Format Options")
    String metaStartsWith = "##";
    @Option(names={"--skip"}, type=FieldType.int32, defaultTo={"0"})
    @OptionUsage(description={"Specify the number of initial lines to skip before parsing."}, format="--skip <int, >=0>", defaultTo="0", group="Text Format Options")
    int skip = 0;
    @Option(names={"--header-starts-with"}, defaultTo={"#"})
    @OptionUsage(description={"Specify the prefix used to identify the header line."}, format="--header-starts-with <string>", defaultTo="#", group="Text Format Options")
    String headerStartsWith = "#";
    @Option(names={"--header-absent"}, type=FieldType.NULL)
    @OptionUsage(description={"Indicate that the input file lacks a header line, using default field names (V1, V2, ...) instead."}, group="Text Format Options")
    boolean headerAbsent = false;
    @Option(names={"--header"}, type=FieldType.string, container=Container.LIST)
    @OptionUsage(description={"Specify the custom header line to override the existing header line."}, format="--header <string> <string> ...", group="Text Format Options")
    List<String> header;
    @CustomOption(names={"--separator"}, converter=TextSeparatorConverter.class, defaultTo={"TAB"})
    @OptionUsage(description={"Specify the delimiter used to separate fields in the input file."}, format="--separator <string>", item={@UsageItem(key="Available: TAB, COMMA, SEMICOLON, UNIVERSAL, BLANK, MULTI_BLANK, BDD, CDD, SDD, NONE")}, defaultTo="TAB", group="Text Format Options")
    ISeparator separator = Separator.TAB;
    @Option(names={"--chrom-field"}, type=FieldType.string, defaultTo={"CHROM"})
    @OptionUsage(description={"Specify the field name that represents chromosome information."}, format="--chrom-field <string>", defaultTo="CHROM", group="Text Format Options")
    String chrom = "CHROM";
    @Option(names={"--pos-field"}, type=FieldType.string)
    @OptionUsage(description={"Specify the field name that represents the genomic position."}, format="--pos-field <string>", defaultTo="POS", group="Text Format Options")
    String pos = "POS";
    @Option(names={"--allele-field"}, type=FieldType.stringArray, defaultTo={"REF,ALT"})
    @OptionUsage(description={"Specify the field names that represent reference and alternate alleles."}, format="--allele-field <string>,<string>,...", defaultTo="REF,ALT", group="Text Format Options")
    StringArray alleles = new StringArray("REF", "ALT");

    public StandardVariantInputCommandOptions<TextRecord, TextInputOption> getInputOptions(List<LiveFile> files) throws IOException {
        StandardVariantInputCommandOptions<TextRecord, TextInputOption> options = new StandardVariantInputCommandOptions<TextRecord, TextInputOption>(this.getConverter(), this.individuals);
        for (LiveFile file : files) {
            options.addInput(new TextInputOption(file).setMetadataParser(new IMetadataParser(){
                final IMetadataParser parser;
                {
                    this.parser = IMetadataParser.beginWith(TEXTInputCommandOptions.this.metaStartsWith, true);
                }

                @Override
                public boolean parse(long pointer, Bytes data, ICCFMeta metas) {
                    if (pointer < (long)TEXTInputCommandOptions.this.skip) {
                        return true;
                    }
                    return this.parser.parse(pointer, data, metas);
                }
            }).setHeaderParser(new IHeaderParser(){
                final IHeaderParser parser;
                {
                    this.parser = IHeaderParser.beginWith(TEXTInputCommandOptions.this.headerStartsWith, true);
                }

                @Override
                public boolean parse(Bytes data, ISeparator separator, IndexableSet<String> header) {
                    if (TEXTInputCommandOptions.this.headerAbsent) {
                        if (TEXTInputCommandOptions.this.header != null) {
                            header.addAll(TEXTInputCommandOptions.this.header);
                        }
                        return false;
                    }
                    boolean success = this.parser.parse(data, separator, header);
                    if (TEXTInputCommandOptions.this.header != null) {
                        header.clear();
                        header.addAll(TEXTInputCommandOptions.this.header);
                    }
                    return success;
                }
            }).setSeparator(this.separator));
        }
        return options;
    }

    private Function<TextRecord, Variant> getConverter() {
        Map<Chromosome, IntIntervalTree<Void>> coordinates = GenomicCoordinatesSelectionConverter.toIntervalTree(this.poses);
        Set<String> excludes = this.excludeFields();
        CacheGenotypes genotypes = this.individuals == null || this.individuals.size() == 0 ? CacheGenotypes.EMPTY : new ConstantGenotypes(this.individuals.size());
        return record -> {
            if (!record.containsKey(this.chrom)) {
                throw new NoSuchElementException("The specified chromosome field '--chrom-field " + this.chrom + "' does not exist in the input file.");
            }
            if (!record.containsKey(this.pos)) {
                throw new NoSuchElementException("The specified position field '--pos-field " + this.pos + "' does not exist in the input file.");
            }
            Coordinate coordinate = this.liftover.convert(new Coordinate(Chromosome.get(record.get(this.chrom).toString()), record.get(this.pos).toInt()));
            if (coordinate == null) {
                return null;
            }
            if (coordinates != null) {
                if (!coordinates.containsKey(coordinate.getChromosome())) {
                    return null;
                }
                IntIntervalTree tree = (IntIntervalTree)coordinates.get(coordinate.getChromosome());
                if (tree != null && !tree.contains(coordinate.getPosition())) {
                    return null;
                }
            }
            Variant variant = new Variant(coordinate);
            for (String allele : this.alleles) {
                if (!record.containsKey(allele)) {
                    throw new NoSuchElementException("The specified allele field '--allele-field " + List.wrap(this.alleles).toString(",") + "' does not exist in the input file: missing '" + allele + "'");
                }
                Bytes bytes = record.get(allele);
                if (bytes.indexOf((byte)44) == -1) {
                    variant.addAllele(bytes.toString());
                    continue;
                }
                BytesSplitter splitter = new BytesSplitter(44).init(bytes);
                while (splitter.hasNext()) {
                    variant.addAllele(splitter.next().toString());
                }
                splitter.clear();
            }
            for (String field : record.keys()) {
                if (excludes.contains(field)) continue;
                variant.setProperty(field, record.get(field));
            }
            return variant;
        };
    }

    public Set<String> excludeFields() {
        HashSet<String> excludes = new HashSet<String>();
        excludes.add(this.chrom);
        excludes.add(this.pos);
        excludes.addAll(List.wrap(this.alleles));
        return excludes;
    }

    public static class OptionPassedRule
    implements IRule {
        CountRule rule = new CountRule(count -> count <= 1, "--header-starts-with", "--header-absent");

        @Override
        public boolean filter(CommandOptions options) {
            return this.rule.filter(options);
        }

        public String toString() {
            return "The option '--header-starts-with' and '--header-absent' cannot be used together; only one of them may be specified.";
        }
    }

    public static enum TextOptionsSummaryDisplayFilter implements IObjectObjectFilter<CommandOptions, CommandOption<?>>
    {
        INSTANCE;

        final IObjectObjectFilter<CommandOptions, CommandOption<?>> rule = IParsingSummary.disableIf(commands -> commands.passed("--header-absent"), "--header-starts-with");

        @Override
        public boolean filter(CommandOptions options, CommandOption<?> option) {
            return this.rule.filter(options, option);
        }
    }
}

