/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.input;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.filter.IObjectObjectFilter;
import edu.sysu.pmglab.ccf.toolkit.input.VCFInputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOption;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.option.DynamicOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.commandParser.rule.ChainRule;
import edu.sysu.pmglab.commandParser.rule.CountRule;
import edu.sysu.pmglab.commandParser.rule.IRule;
import edu.sysu.pmglab.commandParser.usage.summary.IParsingSummary;
import edu.sysu.pmglab.commandParser.validator.range.Float_0_1_RangeValidator;
import edu.sysu.pmglab.commandParser.validator.range.Float_0_RangeValidator;
import edu.sysu.pmglab.commandParser.validator.range.Int_0_RangeValidator;
import edu.sysu.pmglab.container.entry.TEntry;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.command.GenomicCoordinatesSelectionConverter;
import edu.sysu.pmglab.gtb.command.IndividualsSelectionConverter;
import edu.sysu.pmglab.gtb.command.LiftoverConverter;
import edu.sysu.pmglab.gtb.command.input.StandardVariantInputCommandOptions;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.IGenotypeParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.IgnoreGenotypeParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.StandardVCFGenotypeParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.GenotypeADController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.GenotypeDPController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.GenotypeFTController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.GenotypeGQController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.GenotypeLADController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.GenotypeLPLController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.GenotypeMQController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.GenotypePLController;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.IGenotypeController;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.objectpool.Producer;
import edu.sysu.pmglab.runtimecompiler.JavaCompiler;
import gnu.trove.procedure.TObjectObjectProcedure;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;

public class VCFInputCommandOptions {
    @Option(names={"--phased"}, type=FieldType.NULL)
    @OptionUsage(group="Input Options", description={"Set the status of genotype to phased."})
    boolean phased = false;
    @CustomOption(names={"--liftover"}, converter=LiftoverConverter.class)
    @OptionUsage(description={"Lift over variants from one reference genome version to another.", "Chain files are auto-downloaded from http://hgdownload.cse.ucsc.edu/goldenPath/<version>/liftOver"}, format="--liftover <chain>", item={@UsageItem(key="Available", value={"hg19ToHg38, hg38ToHg19, hg18ToHg19, hg18ToHg38"})}, group="Input Options")
    LiftOver liftover = LiftOver.ITSELF;
    @CustomOption(names={"--pos"}, converter=GenomicCoordinatesSelectionConverter.class, arity={-1})
    @OptionUsage(description={"Retrieve the variants by the specified coordinate expression of variant.", "The expression can follow one of three formats: '<chr>' for the entire chromosome, '<chr>:<pos>,<pos>,...' for specific positions, or '<chr>:<start>-<end>,<start>-<end>,...' for coordinate ranges."}, format="--pos [expression] [expression] ...", group="Input Options")
    Map<Chromosome, List<IntInterval>> poses = null;
    @CustomOption(names={"--individual"}, converter=IndividualsSelectionConverter.class, arity={-1})
    @OptionUsage(description={"Select a subset of individuals. Individuals not found in the inputs will have their genotype filled with './.'."}, format="--individual <string>,<string>,...", group="Input Options")
    IndexableSet<String> individuals = null;
    @Option(names={"--disable-qc"}, type=FieldType.NULL)
    @OptionUsage(group="Quality Control Options", description={"Disable all quality control methods."})
    boolean disableQC = false;
    @Option(names={"--gty-gq"}, type=FieldType.varInt32, validator=Int_0_RangeValidator.class, defaultTo={"20"})
    @OptionUsage(group="Quality Control Options", format="--gty-gq <minGq>", defaultTo="20", description={"Exclude genotypes with a minimal genotype quality (Phred Quality Score) in the 'GQ' field is < minGq.", "'0' means to disable this filter."})
    int gtyGq = 20;
    @Option(names={"--gty-dp"}, type=FieldType.varInt32, validator=Int_0_RangeValidator.class, defaultTo={"8"})
    @OptionUsage(group="Quality Control Options", format="--gty-dp <minDp>", defaultTo="8", description={"Exclude genotypes with a minimal read depth in the 'DP' field is < minDp.", "'0' means to disable this filter."})
    int gtyDp = 8;
    @Option(names={"--gty-mq"}, type=FieldType.varInt32, validator=Int_0_RangeValidator.class, defaultTo={"40"})
    @OptionUsage(group="Quality Control Options", format="--gty-mq <minMq>", defaultTo="40", description={"Exclude genotypes with a minimal RMS mapping quality in the 'MQ' field is < minMq.", "'0' means to disable this filter."})
    int gtyMq = 40;
    @Option(names={"--gty-pl"}, type=FieldType.varInt32, validator=Int_0_RangeValidator.class, defaultTo={"20"})
    @OptionUsage(group="Quality Control Options", format="--gty-pl <minPl>", defaultTo="20", description={"Exclude genotypes where the second smallest normalized Phred-scaled likelihoods in the 'PL' field is < minPl. This filters out genotypes with high uncertainty.", "'0' means to disable this filter."})
    int gtyPl = 20;
    @Option(names={"--gty-lpl"}, type=FieldType.varInt32, validator=Int_0_RangeValidator.class, defaultTo={"20"})
    @OptionUsage(group="Quality Control Options", format="--gty-lpl <minLpl>", defaultTo="20", description={"Exclude genotypes where the second smallest local normalized Phred-scaled likelihoods in the 'LPL' field is < minLpl. This filters out genotypes with high uncertainty.", "'0' means to disable this filter."})
    int gtyLpl = 20;
    @Option(names={"--gty-ft"}, type=FieldType.stringIndexableSet, defaultTo={"PASS"})
    @OptionUsage(group="Quality Control Options", format="--gty-ft <string>,<string>,...", defaultTo="PASS", description={"Exclude genotypes where the value in the 'FT' field does not match any of the specified values. Use commas to separate multiple allowed values.", "'DISABLE' means to disable this filter."})
    Set<String> gtyFt = List.wrap("PASS").toIndexableSet();
    @Option(names={"--gty-ad-hom-ref"}, type=FieldType.float32, validator=Float_0_1_RangeValidator.class, defaultTo={"0.95"})
    @OptionUsage(group="Quality Control Options", format="--gty-ad-hom-ref <minAdHomRef>", defaultTo="0.95", description={"Exclude genotypes with the fraction of the reads carrying reference alleles in the 'AD' fields is < minAdHomRef at a reference-allele homozygous genotype.", "'0' means to disable this filter."})
    float gtyAdHomRef = 0.95f;
    @Option(names={"--gty-ad-hom-alt"}, type=FieldType.float32, validator=Float_0_1_RangeValidator.class, defaultTo={"0.75"})
    @OptionUsage(group="Quality Control Options", format="--gty-ad-hom-alt <minAdHomAlt>", defaultTo="0.75", description={"Exclude genotypes with the fraction of the reads carrying alternative alleles in the 'AD' and 'LAD' fields is < minAdHomAlt at a alternative-allele homozygous genotype.", "'0' means to disable this filter."})
    float gtyAdHomAlt = 0.75f;
    @Option(names={"--gty-ad-het"}, type=FieldType.float32, validator=Float_0_1_RangeValidator.class, defaultTo={"0.25"})
    @OptionUsage(group="Quality Control Options", format="--gty-ad-het <minAdHet>", defaultTo="0.25", description={"Exclude genotypes with the fraction of the reads carrying alternative alleles in the 'AD' and 'LAD' fields is < minAdHet at a heterozygous genotype.", "'0' means to disable this filter."})
    float gtyAdHet = 0.25f;
    @DynamicOption(names={"--gty-qc"}, args={"keyword", "rule"}, repeated=true, converter=CustomVCFGtyFilter.class)
    @OptionUsage(group="Quality Control Options", format="--gty-qc <keyword> <rule>", item={@UsageItem(key="Example", value={"--gty-qc DP \"DP.toInt()>=10\""})}, description={"Exclude genotypes where the genotype quality metric, represented as an Bytes object, corresponding to the keyword has not passed boolean expression quality control."})
    List<TEntry<String, Producer<IGenotypeController>>> gtyQc = new List(0);
    @Option(names={"--seq-fs"}, type=FieldType.float32, validator=Float_0_RangeValidator.class)
    @OptionUsage(group="Quality Control Options", format="--seq-fs <minFs>", description={"Exclude variants with the overall strand bias Phred-scaled p-value (using Fisher's exact test) per variant > maxFs."})
    float fs = Float.MAX_VALUE;
    @Option(names={"--seq-mq"}, type=FieldType.float32, validator=Float_0_RangeValidator.class, defaultTo={"20"})
    @OptionUsage(group="Quality Control Options", format="--seq-mq <minMq>", defaultTo="20", description={"Exclude variants with the minimal overall mapping quality score (Mapping Quality Score) per variant < minMq.", "'0' means to disable this filter."})
    float mq = 20.0f;
    @Option(names={"--seq-qual"}, type=FieldType.float32, validator=Float_0_RangeValidator.class, defaultTo={"30"})
    @OptionUsage(group="Quality Control Options", format="--seq-qual <minQual>", defaultTo="30", description={"Exclude variants with the minimal overall sequencing quality score (Phred Quality Score) per variant < minQual.", "'0' means to disable this filter."})
    float qual = 30.0f;

    public StandardVariantInputCommandOptions<Variant, VCFInputOption> getInputOptions(List<LiveFile> files) throws IOException {
        final StandardVariantInputCommandOptions<Variant, VCFInputOption> options = new StandardVariantInputCommandOptions<Variant, VCFInputOption>(null, this.individuals);
        final List<Producer<IGenotypeController>> gtyControllers = this.getGenotypeControllers();
        List<IFilter<Variant>> preFilters = this.getVariantControllers();
        Map<Chromosome, IntIntervalTree<Void>> coordinates = GenomicCoordinatesSelectionConverter.toIntervalTree(this.poses);
        for (LiveFile file : files) {
            VCFInputOption option = new VCFInputOption(file).addInputPreFilter(variant -> {
                if ((variant = this.liftover.convert((Variant)variant)) == null) {
                    return null;
                }
                if (coordinates != null) {
                    if (!coordinates.containsKey(variant.getChromosome())) {
                        return null;
                    }
                    IntIntervalTree tree = (IntIntervalTree)coordinates.get(variant.getChromosome());
                    if (tree != null && !tree.contains(variant.getPosition())) {
                        return null;
                    }
                }
                if (preFilters.size() > 0) {
                    for (IFilter filter : preFilters) {
                        if (filter.filter(variant)) continue;
                        return null;
                    }
                }
                return variant;
            });
            options.addIndividuals(option.getIndividuals());
            options.addInput(option);
        }
        for (final VCFInputOption input : options) {
            if (input.getIndividuals().hasOverlaps(options.getIndividuals())) {
                input.setGenotypeParser(new IntFunction<IGenotypeParser>(){
                    final IntList indexes;
                    {
                        this.indexes = options.getIndividuals().findIndicesIn(input.getIndividuals());
                    }

                    @Override
                    public IGenotypeParser apply(int value) {
                        StandardVCFGenotypeParser parser = new StandardVCFGenotypeParser(value, VCFInputCommandOptions.this.phased){
                            byte[] bytes;
                            short[] shorts;
                            int[] ints;
                            {
                                this.bytes = null;
                                this.shorts = null;
                                this.ints = null;
                            }

                            @Override
                            public void parse(Variant variant, Bytes sequence2) {
                                super.parse(variant, sequence2);
                                if (indexes != null) {
                                    int numOfAlleles = variant.getGenotypes().counter().maxAlleleIndex() + 1;
                                    if (numOfAlleles <= 15) {
                                        if (this.bytes == null) {
                                            this.bytes = new byte[indexes.size()];
                                        }
                                        variant.setGenotypes(variant.getGenotypes().subGenotypes(indexes, this.bytes));
                                    } else if (numOfAlleles <= 255) {
                                        if (this.shorts == null) {
                                            this.shorts = new short[indexes.size()];
                                        }
                                        variant.setGenotypes(variant.getGenotypes().subGenotypes(indexes, this.shorts));
                                    } else {
                                        if (this.ints == null) {
                                            this.ints = new int[indexes.size()];
                                        }
                                        variant.setGenotypes(variant.getGenotypes().subGenotypes(indexes, this.ints));
                                    }
                                }
                            }
                        };
                        for (Producer controller : gtyControllers) {
                            parser.setController((IGenotypeController)controller.offer());
                        }
                        return parser;
                    }
                });
                continue;
            }
            input.setGenotypeParser(value -> new IgnoreGenotypeParser(options.getIndividuals().size(), false));
        }
        return options;
    }

    List<Producer<IGenotypeController>> getGenotypeControllers() {
        if (this.disableQC) {
            return List.EMPTY();
        }
        LinkedHashMap<String, Producer<IGenotypeController>> controllers = new LinkedHashMap<String, Producer<IGenotypeController>>();
        if (this.gtyGq > 0) {
            controllers.put("GQ", () -> new GenotypeGQController(this.gtyGq));
        }
        if (this.gtyDp > 0) {
            controllers.put("DP", () -> new GenotypeDPController(this.gtyDp));
        }
        if (this.gtyMq > 0) {
            controllers.put("MQ", () -> new GenotypeMQController(this.gtyMq));
        }
        if (this.gtyPl > 0) {
            controllers.put("PL", () -> new GenotypePLController(this.gtyPl));
        }
        if (this.gtyLpl > 0) {
            controllers.put("LPL", () -> new GenotypeLPLController(this.gtyLpl));
        }
        if (!this.gtyFt.contains("DISABLE")) {
            controllers.put("FT", () -> new GenotypeFTController(this.gtyFt));
        }
        if (this.gtyDp != 0 || this.gtyAdHomRef != 0.0f || this.gtyAdHomAlt != 0.0f || this.gtyAdHet != 0.0f) {
            controllers.put("AD", () -> new GenotypeADController(this.gtyDp, this.gtyAdHomRef, this.gtyAdHomAlt, this.gtyAdHet));
            controllers.put("LAD", () -> new GenotypeLADController(this.gtyDp, this.gtyAdHomAlt, this.gtyAdHet));
        }
        for (TEntry<String, Producer<IGenotypeController>> controller : this.gtyQc) {
            if (controllers.containsKey(controller.getKey())) {
                throw new ParameterException("Duplicated genotype-level filter: " + controller.getKey());
            }
            controllers.put(controller.getKey(), controller.getValue());
        }
        return controllers.size() == 0 ? List.EMPTY() : List.wrap(controllers.values());
    }

    List<IFilter<Variant>> getVariantControllers() {
        if (this.disableQC) {
            return List.EMPTY();
        }
        List<IFilter<Variant>> controllers = new List<IFilter<Variant>>();
        if (this.qual > 0.0f) {
            controllers.add(variant -> {
                String quality = (String)variant.getProperty("QUAL");
                if (quality == null || quality.equals(".")) {
                    return true;
                }
                return Float.parseFloat(quality) >= this.qual;
            });
        }
        if (this.mq > 0.0f) {
            controllers.add(variant -> {
                Map INFO = (Map)variant.getProperty("INFO");
                return INFO == null || !INFO.containsKey("MQ") || ((Bytes)INFO.get("MQ")).toFloat() >= this.mq;
            });
        }
        if (this.fs != Float.MAX_VALUE) {
            controllers.add(variant -> {
                Map INFO = (Map)variant.getProperty("INFO");
                return INFO == null || !INFO.containsKey("FS") || ((Bytes)INFO.get("FS")).toFloat() <= this.fs;
            });
        }
        return controllers.size() == 0 ? List.EMPTY() : controllers;
    }

    public static class VCFQCOptionPassedRule
    implements IRule {
        ChainRule rule = new ChainRule(new CountRule(count -> count == 1, "--disable-qc"), new CountRule(count -> count == 0, "--gty-gq", "--gty-dp", "--gty-mq", "--gty-pl", "--gty-lpl", "--gty-ft", "--gty-ad-hom-ref", "--gty-ad-hom-alt", "--gty-ad-het", "--gty-qc", "--seq-fs", "--seq-mq", "--seq-qual"));

        @Override
        public boolean filter(CommandOptions options) {
            return this.rule.filter(options);
        }

        public String toString() {
            return "The option '--disable-qc' cannot be used together with other quality control options (i.e., --gty-gq, --gty-dp, --gty-mq, --gty-pl, --gty-lpl, --gty-ft, --gty-ad-hom-ref, --gty-ad-hom-alt, --gty-ad-het, --gty-qc, --seq-fs, --seq-mq, --seq-qual).";
        }
    }

    public static enum VCFQCOptionsSummaryDisplayFilter implements IObjectObjectFilter<CommandOptions, CommandOption<?>>
    {
        INSTANCE;

        final IObjectObjectFilter<CommandOptions, CommandOption<?>> rule = IParsingSummary.disableIf(commands -> commands.passed("--disable-qc"), "--gty-gq", "--gty-dp", "--gty-mq", "--gty-pl", "--gty-lpl", "--gty-ft", "--gty-ad-hom-ref", "--gty-ad-hom-alt", "--gty-ad-het", "--gty-qc", "--seq-fs", "--seq-mq", "--seq-qual");

        @Override
        public boolean filter(CommandOptions options, CommandOption<?> option) {
            return this.rule.filter(options, option);
        }
    }

    static enum CustomVCFGtyFilter implements IDynamicConverter<TEntry<String, Producer<IGenotypeController>>>
    {
        INSTANCE;


        @Override
        public TEntry<String, Producer<IGenotypeController>> convert(String name, Map<String, String> params) {
            final String keyword = params.get("keyword");
            final String rule = params.get("rule");
            final TObjectObjectProcedure filter = JavaCompiler.procedure(rule, JavaCompiler.Param.of(keyword, Bytes.class), JavaCompiler.Param.of("genotype", Genotype.class));
            return new TEntry<String, Producer<IGenotypeController>>(keyword, () -> new IGenotypeController(){

                @Override
                public boolean execute(Bytes metric, Genotype genotype) {
                    return filter.execute(metric, genotype);
                }

                @Override
                public String getKeyWord() {
                    return keyword;
                }

                public String toString() {
                    return rule;
                }
            });
        }
    }
}

