/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.output;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.command.convetter.CCFMetaConverter;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.commandParser.annotation.option.DynamicOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.entry.TTriEntry;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.rangelist.VarInt32RangeList;
import edu.sysu.pmglab.gtb.command.input.StandardVariantInputCommandOptions;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class GTBOutputCommandOptions {
    @Option(names={"--output", "-o"}, type=FieldType.file, defaultTo={"./archive.gtb"})
    @OptionUsage(group="Output Options", description={"Set the output file path."}, defaultTo="./archive.gtb", format="--output <file>")
    File output = new File(RuntimeProperty.WORKSPACE_PATH, "archive.gtb");
    @DynamicOption(names={"--field", "-f"}, converter=FieldMetaConverter.class, args={"name=", "type=", "source="}, repeated=true)
    @OptionUsage(group="Output Options", description={"Specify the fields to include in the output file. If this option is not specified, the fields will be determined by the first input file."}, format="--field <name> [type] [source]")
    List<TTriEntry<String, IFieldType, String>> fields;
    @Option(names={"--discard-gt"}, type=FieldType.NULL)
    @OptionUsage(group="Output Options", description={"Exclude genotypes from the output."})
    boolean storeGT = true;
    @Option(names={"--disable-sort"}, type=FieldType.NULL)
    @OptionUsage(group="Output Options", description={"Disable sorting of output variants."})
    boolean sort = true;
    @Option(names={"--ignore-index"}, type=FieldType.NULL)
    @OptionUsage(group="Output Options", description={"Disable coordinate-index table generation. By default, indexes are automatically created for optimized access."})
    boolean buildIndex = true;
    @Option(names={"--retain-meta-from"}, type=FieldType.varInt32RangeList, defaultTo={"0"})
    @OptionUsage(description={"Retain metadata from specified input files.", "To disable this functionality, use '-1'."}, format="--retain-meta-from <int>,<int>~<int>,...", group="Output Options", defaultTo="0")
    VarInt32RangeList retainMetasFrom = new VarInt32RangeList().add(0);
    @DynamicOption(names={"--add-meta"}, args={"key", "value=", "type=string"}, converter=CCFMetaConverter.class, repeated=true)
    @OptionUsage(description={"Add metadata to the output file"}, format="--add-meta <key> [value] [type=string]", group="Output Options")
    List<CCFMetaItem> metas = null;
    @Option(names={"--drop-duplicate-meta"}, type=FieldType.NULL)
    @OptionUsage(description={"Remove duplicate metadata entries from the output file."}, group="Output Options")
    boolean dropDuplicateMeta = false;

    public GTBOutputOption getOutputOptions(StandardVariantInputCommandOptions<?, ?> inputs) throws IOException {
        GTBOutputOption output = new GTBOutputOption(this.output).addIndividuals(this.storeGT ? inputs.getIndividuals() : null);
        ICCFMeta metas = new CCFMeta().adds(this.metas);
        for (int i = 0; i < inputs.size(); ++i) {
            if (!this.retainMetasFrom.contains(i)) continue;
            metas.adds(inputs.get(i).getMeta());
        }
        if (this.dropDuplicateMeta) {
            metas.dropDuplicates();
        }
        output.addMeta(metas);
        return output;
    }

    public void finish(boolean silent, int threads) throws IOException {
        GTBSorter sorter;
        if (this.sort && !(sorter = GTBSorter.setInput(this.output, new String[0]).setListener(silent ? null : new SortListener("Crude Indexed", "Sorted", "variants"))).isOrdered(threads)) {
            sorter.sort(this.output, threads, false);
        }
        if (this.buildIndex) {
            GTBIndexer.setInput(this.output, new String[0]).setListener(silent ? null : new InputListener("Indexed", "variants")).save(threads);
        }
    }

    public List<TTriEntry<String, IFieldType, String>> getAllFields() {
        return this.fields;
    }

    public File getFile() {
        return this.output;
    }

    private static enum FieldMetaConverter implements IDynamicConverter<TTriEntry<String, IFieldType, String>>
    {
        INSTANCE;


        @Override
        public TTriEntry<String, IFieldType, String> convert(String option, Map<String, String> params) {
            IFieldType fieldType;
            String name = params.get("name");
            if (name.length() == 0) {
                if (!(params.containsKey("type") && params.get("type").length() != 0 || params.containsKey("source") && params.get("source").length() != 0)) {
                    return null;
                }
                throw new ParameterException("Invalid parameter \"" + this.name() + "\": sub-parameters 'name' cannot be empty");
            }
            IFieldType iFieldType = fieldType = !params.containsKey("type") || params.get("type").length() == 0 ? null : IFieldType.get(params.get("type"));
            if (!params.containsKey("source") || params.get("source").length() == 0) {
                return new TTriEntry<String, IFieldType, String>(name, fieldType, name);
            }
            return new TTriEntry<String, IFieldType, String>(name, fieldType, params.get("source"));
        }
    }
}

