/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.output;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.command.convetter.CCFMetaConverter;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.output.OutputOption;
import edu.sysu.pmglab.ccf.toolkit.output.PLINKOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.annotation.option.Available;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.DynamicOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.rangelist.VarInt32RangeList;
import edu.sysu.pmglab.gtb.command.input.StandardVariantInputCommandOptions;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKType;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public class PLINKOutputCommandOptions {
    @Option(names={"--output", "-o"}, type=FieldType.string, defaultTo={"./archive"})
    @OptionUsage(group="Output Options", description={"Set the output file path."}, defaultTo="./archive", format="--output <file>")
    String output = new File(RuntimeProperty.WORKSPACE_PATH, "archive").getPath();
    @Option(names={"--output-type", "-ot"}, available=@Available(value={"BED", "PGEN"}, upper=true), defaultTo={"BED"})
    @OptionUsage(description={"Specify the output file type."}, format="--output-type [BED/PGEN]", defaultTo="BED", group="Output Options")
    String type = "BED";
    @Option(names={"--field", "-f"}, type=FieldType.string, container=Container.SET, available=@Available(value={"ID", "QUAL", "FILTER", "INFO"}))
    @OptionUsage(group="Output Options", description={"Specify the fields to include in the output file. If this option is not specified, the fields will be determined by the first input file."}, format="--field <string> <string> ...", defaultTo="ID QUAL FILTER INFO", item={@UsageItem(key="Available", value={"ID, QUAL, FILTER, INFO"})})
    Set<String> fields = List.wrap("ID", "QUAL", "FILTER", "INFO").toSet();
    @Option(names={"--retain-meta-from"}, type=FieldType.varInt32RangeList, defaultTo={"0"})
    @OptionUsage(description={"Retain metadata from specified input files.", "To disable this functionality, use '-1'."}, format="--retain-meta-from <int>,<int>~<int>,...", group="Output Options", defaultTo="0")
    VarInt32RangeList retainMetasFrom = new VarInt32RangeList().add(0);
    @DynamicOption(names={"--add-meta"}, args={"key", "value=", "type=string"}, converter=CCFMetaConverter.class, repeated=true)
    @OptionUsage(description={"Add metadata to the output file"}, format="--add-meta <key> [value] [type=string]", group="Output Options")
    List<CCFMetaItem> metas = null;
    @Option(names={"--drop-duplicate-meta"}, type=FieldType.NULL)
    @OptionUsage(description={"Remove duplicate metadata entries from the output file."}, group="Output Options")
    boolean dropDuplicateMeta = false;

    public PLINKOutputOption getOutputOptions(StandardVariantInputCommandOptions<?, ?> inputs) throws IOException {
        OutputOption output = new PLINKOutputOption(this.output, PLINKType.valueOf(this.type)).addIndividuals(inputs.getIndividuals()).addFilter(variant -> {
            if (!this.fields.contains("ID")) {
                variant.setProperty("ID", null);
            }
            if (!this.fields.contains("QUAL")) {
                variant.setProperty("QUAL", null);
            }
            if (!this.fields.contains("INFO")) {
                variant.setProperty("INFO", null);
            }
            if (!this.fields.contains("FILTER")) {
                variant.setProperty("FILTER", null);
            }
            return true;
        });
        ICCFMeta metas = new CCFMeta().adds(this.metas);
        for (int i = 0; i < inputs.size(); ++i) {
            if (!this.retainMetasFrom.contains(i)) continue;
            metas.adds(inputs.get(i).getMeta());
        }
        if (this.dropDuplicateMeta) {
            metas.dropDuplicates();
        }
        ((PLINKOutputOption)output).addMeta(metas);
        return output;
    }
}

