/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.CCFWriter;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.loader.CCFChunk;
import edu.sysu.pmglab.ccf.loader.CCFLoader;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Available;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.Indirect;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.rule.Counter;
import edu.sysu.pmglab.commandParser.annotation.rule.Rule;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.container.entry.TIntLongEntry;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.GTBWriter;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKFile;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKReader;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKType;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFReader;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.IgnoreGenotypeParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.IgnoreINFOParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.StandardVCFGenotypeParser;
import edu.sysu.pmglab.progressbar.MultiProgressBar;
import edu.sysu.pmglab.progressbar.TextProgressRenderers;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="collect <input> <input> ... --output <output> [options]", usage_item={@UsageItem(key="About", value={"The command processes multiple GTB/VCF/PLINK files to extract all variant sites (coordinates) and individual identifiers, generating a new \"blank\" GTB file. The output GTB contains full coordinate and individual, but all genotypes are set to './.'."})}, rule=@Rule(counter={@Counter(item={"--only-site", "--only-individual"}, rule=Counter.Type.AT_MOST, count=1)}), indirect=@Indirect(enable=true))
public class CollectProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectProgram.class);
    @Option(names={"--silent"}, type=FieldType.NULL)
    @OptionUsage(description={"Suppress terminal output logs."})
    boolean silent = false;
    @Option(names={"collect"}, type=FieldType.string, container=Container.SET, required=true)
    Set<String> files;
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--type"}, available=@Available(value={"GTB", "VCF", "BED", "PGEN"}, upper=true), defaultTo={"GTB"})
    @OptionUsage(description={"Specify the input file type."}, format="--type [GTB/VCF/BED/PGEN]", defaultTo="GTB")
    String type = "GTB";
    @Option(names={"--output", "-o"}, type=FieldType.file, defaultTo={"./archive.gtb"})
    @OptionUsage(description={"Set the output file path."}, defaultTo="./archive.gtb", format="--output <file>")
    File output = new File(RuntimeProperty.WORKSPACE_PATH, "archive.gtb");
    @Option(names={"--only-site", "-os"}, type=FieldType.NULL)
    @OptionUsage(description={"Collect only variant site coordinates."})
    boolean onlySite = false;
    @Option(names={"--only-individual", "-oi"}, type=FieldType.NULL)
    @OptionUsage(description={"Collect only individual identifiers."})
    boolean onlyIndividual = false;

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        CollectProgram program = new CollectProgram();
        if (args.length == 1 && args[0].equals("collect")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (program.onlySite) {
            Variant variant;
            Closeable reader;
            Iterator<String> reader2;
            TObjectLongHashMap<String> counter = new TObjectLongHashMap<String>();
            CCFWriter writer = CCFWriter.setOutput(program.output).addFields(GTBManager.FIELDS).instance();
            BoxRecord record = writer.getRecord();
            long total = 0L;
            MultiProgressBar bar = new MultiProgressBar.Builder().setRenderers(new TextProgressRenderers().add("Done", "files", false).add("Input", "variants", true)).build();
            if (program.type.equals("GTB")) {
                CCFLoader loader = new CCFLoader(List.wrap(new CCFChunk.Type[]{CCFChunk.Type.FIELD_GROUP_META, CCFChunk.Type.FIELD_GROUP_DATA}).toSet());
                for (String file : program.files) {
                    reader2 = new CCFReader((IReaderOption<?>)new ReaderOption(loader.parse(file), new String[0]).addFields(GTBManager.FIELDS.subsetFields("CHROM", "POS", "ALLELE")));
                    Throwable throwable = null;
                    try {
                        long count = 0L;
                        while (((CCFReader)((Object)reader2)).read(record)) {
                            writer.write(record);
                            bar.step(0L, 1L);
                            ++count;
                        }
                        total += count;
                        counter.put(file, count);
                    }
                    catch (Throwable count) {
                        throwable = count;
                        throw count;
                    }
                    finally {
                        if (reader2 != null) {
                            if (throwable != null) {
                                try {
                                    ((CCFReader)((Object)reader2)).close();
                                }
                                catch (Throwable count) {
                                    throwable.addSuppressed(count);
                                }
                            } else {
                                ((CCFReader)((Object)reader2)).close();
                            }
                        }
                    }
                    bar.step(1L, 0L);
                }
            } else if (program.type.equals("VCF")) {
                for (String file : program.files) {
                    reader = VCFReader.setInput(file).setInfoParser(IgnoreINFOParser.INSTANCE).setGenotypeParser(value -> new IgnoreGenotypeParser(value, false)).instance();
                    reader2 = null;
                    try {
                        long count = 0L;
                        while ((variant = ((VCFReader)reader).read()) != null) {
                            record.set("CHROM", (Object)variant.getChromosome());
                            record.set("POS", (Object)variant.getPosition());
                            record.set("ALLELE", variant.getAlleles());
                            writer.write(record);
                            bar.step(0L, 1L);
                            ++count;
                        }
                        total += count;
                        counter.put(file, count);
                    }
                    catch (Throwable count) {
                        reader2 = count;
                        throw count;
                    }
                    finally {
                        if (reader != null) {
                            if (reader2 != null) {
                                try {
                                    ((VCFReader)reader).close();
                                }
                                catch (Throwable count) {
                                    ((Throwable)((Object)reader2)).addSuppressed(count);
                                }
                            } else {
                                ((VCFReader)reader).close();
                            }
                        }
                    }
                    bar.step(1L, 0L);
                }
            } else {
                for (String file : program.files) {
                    reader = PLINKFile.load(file, PLINKType.valueOf(program.type)).instance(false);
                    reader2 = null;
                    try {
                        long count = 0L;
                        while ((variant = ((PLINKReader)reader).read()) != null) {
                            record.set("CHROM", (Object)variant.getChromosome());
                            record.set("POS", (Object)variant.getPosition());
                            record.set("ALLELE", variant.getAlleles());
                            writer.write(record);
                            bar.step(0L, 1L);
                            ++count;
                        }
                        total += count;
                        counter.put(file, count);
                    }
                    catch (Throwable count) {
                        reader2 = count;
                        throw count;
                    }
                    finally {
                        if (reader != null) {
                            if (reader2 != null) {
                                try {
                                    ((PLINKReader)reader).close();
                                }
                                catch (Throwable count) {
                                    ((Throwable)((Object)reader2)).addSuppressed(count);
                                }
                            } else {
                                ((PLINKReader)reader).close();
                            }
                        }
                    }
                    bar.step(1L, 0L);
                }
            }
            bar.close();
            writer.close();
            GTBSorter sorter = GTBSorter.setInput(program.output, new String[0]).setListener(new SortListener("Crude Indexed", "Sorted", "variants"));
            if (!sorter.isOrdered(program.threads)) {
                sorter.sort(program.output, program.threads, false);
            }
            GTBIndexer.setInput(program.output, new String[0]).setListener(new InputListener<ReaderOption, Void>("Indexed", "variants")).save(program.threads);
            StringBuilder report = new StringBuilder();
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            report.append("\nSummary:\n");
            report.append(String.format("  - Total unique input files: %s\n", numberFormat.format(program.files.size())));
            report.append(String.format("  - Total variant sites collected: %s\n\n", numberFormat.format(total)));
            report.append("Detailed site counts per file:\n");
            for (String file : program.files) {
                report.append(String.format("  - %s: %s sites\n", file, numberFormat.format(counter.get(file))));
            }
            report.append("\nOutput file: ").append(program.output);
            LOGGER.info(report.toString());
        } else if (program.onlyIndividual) {
            TObjectLongHashMap<String> counter = new TObjectLongHashMap<String>();
            LinkedSet<String> individuals = new LinkedSet<String>();
            MultiProgressBar bar = new MultiProgressBar.Builder().setRenderers(new TextProgressRenderers().add("Done", "files", false).add("Input", "individuals", false)).build();
            if (program.type.equals("GTB")) {
                CCFLoader loader = new CCFLoader(List.wrap(new CCFChunk.Type[]{CCFChunk.Type.OPTION}).toSet());
                for (String file : program.files) {
                    IndexableSet finds = loader.parse(file).getOption("GTB_INDIVIDUAL", IndexableSet.EMPTY());
                    counter.put(file, finds.size());
                    long before = ((AbstractCollection)individuals).size();
                    individuals.addAll(finds);
                    bar.step(1L, (long)((AbstractCollection)individuals).size() - before);
                }
            } else if (program.type.equals("VCF")) {
                for (String file : program.files) {
                    VCFReader reader = VCFReader.setInput(file).instance();
                    Throwable finds = null;
                    try {
                        IndexableSet<String> finds2 = reader.getIndividuals();
                        counter.put(file, finds2.size());
                        long before = ((AbstractCollection)individuals).size();
                        individuals.addAll(finds2);
                        bar.step(1L, (long)((AbstractCollection)individuals).size() - before);
                    }
                    catch (Throwable finds2) {
                        finds = finds2;
                        throw finds2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (finds != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable finds2) {
                                finds.addSuppressed(finds2);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
            } else {
                for (String file : program.files) {
                    IndexableSet<String> finds = PLINKFile.getIndividuals(file, PLINKType.valueOf(program.type));
                    counter.put(file, finds.size());
                    long before = ((AbstractCollection)individuals).size();
                    individuals.addAll(finds);
                    bar.step(1L, (long)((AbstractCollection)individuals).size() - before);
                }
            }
            bar.close();
            GTBWriter.setOutput(program.output).addIndividuals(individuals).instance().close();
            StringBuilder report = new StringBuilder();
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            report.append("\nSummary:\n");
            report.append(String.format("  - Total unique input files: %s\n", numberFormat.format(program.files.size())));
            report.append(String.format("  - Total unique individuals collected: %s\n\n", numberFormat.format(((AbstractCollection)individuals).size())));
            report.append("Detailed individual counts per file:\n");
            for (String file : program.files) {
                report.append(String.format("  - %s: %s individuals\n", file, numberFormat.format(counter.get(file))));
            }
            report.append("\nOutput file: ").append(program.output);
            LOGGER.info(report.toString());
        } else {
            ICounter c;
            Variant variant2;
            long count;
            Throwable reader2;
            AutoCloseable reader;
            Object finds;
            HashMap<String, TIntLongEntry> counter = new HashMap<String, TIntLongEntry>();
            LinkedSet<String> individuals = new LinkedSet<String>();
            long total = 0L;
            if (program.type.equals("GTB")) {
                CCFLoader loader = new CCFLoader(List.wrap(new CCFChunk.Type[]{CCFChunk.Type.OPTION}).toSet());
                for (String file : program.files) {
                    finds = loader.parse(file).getOption("GTB_INDIVIDUAL", IndexableSet.EMPTY());
                    counter.put(file, new TIntLongEntry(((AbstractCollection)finds).size(), 0L));
                    individuals.addAll(finds);
                }
            } else if (program.type.equals("VCF")) {
                for (String file : program.files) {
                    VCFReader reader3 = VCFReader.setInput(file).instance();
                    finds = null;
                    try {
                        IndexableSet<String> finds3 = reader3.getIndividuals();
                        counter.put(file, new TIntLongEntry(finds3.size(), 0L));
                        individuals.addAll(finds3);
                    }
                    catch (Throwable finds3) {
                        finds = finds3;
                        throw finds3;
                    }
                    finally {
                        if (reader3 == null) continue;
                        if (finds != null) {
                            try {
                                reader3.close();
                            }
                            catch (Throwable finds3) {
                                ((Throwable)finds).addSuppressed(finds3);
                            }
                            continue;
                        }
                        reader3.close();
                    }
                }
            } else {
                for (String file : program.files) {
                    Iterator<String> finds4 = PLINKFile.getIndividuals(file, PLINKType.valueOf(program.type));
                    counter.put(file, new TIntLongEntry(((AbstractCollection)((Object)finds4)).size(), 0L));
                    individuals.addAll(finds4);
                }
            }
            GTBWriter writer = GTBWriter.setOutput(program.output).addIndividuals(individuals).addField(null, "AC", FieldType.varInt32).addField(null, "AN", FieldType.varInt32).addField(null, "AF", FieldType.float32).addField(null, "GT_COUNTER", FieldType.bytecode).instance();
            MultiProgressBar bar = new MultiProgressBar.Builder().setRenderers(new TextProgressRenderers().add("Done", "files", false).add("Input", "individuals", false).add("Input", "variants", true)).build();
            bar.step(0L, ((AbstractCollection)individuals).size(), 0L);
            if (program.type.equals("GTB")) {
                for (String file : program.files) {
                    reader = new GTBReader(new GTBReaderOption(file, true, false));
                    reader2 = null;
                    try {
                        count = 0L;
                        while ((variant2 = ((GTBReader)reader).read()) != null) {
                            c = variant2.getGenotypes().counter();
                            variant2.setProperty("AC", c.getAC());
                            variant2.setProperty("AN", c.getAN());
                            variant2.setProperty("AF", Float.valueOf(c.getAF()));
                            variant2.setProperty("GT_COUNTER", c.encode());
                            variant2.setGenotypes(null);
                            writer.write(variant2);
                            bar.step(0L, 0L, 1L);
                            ++count;
                        }
                        total += count;
                        counter.put(file, new TIntLongEntry(((TIntLongEntry)counter.get(file)).getKey(), count));
                    }
                    catch (Throwable variant2) {
                        reader2 = variant2;
                        throw variant2;
                    }
                    finally {
                        if (reader != null) {
                            if (reader2 != null) {
                                try {
                                    ((GTBReader)reader).close();
                                }
                                catch (Throwable variant2) {
                                    reader2.addSuppressed(variant2);
                                }
                            } else {
                                ((GTBReader)reader).close();
                            }
                        }
                    }
                    bar.step(1L, 0L, 0L);
                }
            } else if (program.type.equals("VCF")) {
                for (String file : program.files) {
                    reader = VCFReader.setInput(file).setInfoParser(IgnoreINFOParser.INSTANCE).setGenotypeParser(value -> new StandardVCFGenotypeParser(value, true)).instance();
                    reader2 = null;
                    try {
                        count = 0L;
                        while ((variant2 = ((VCFReader)reader).read()) != null) {
                            c = variant2.getGenotypes().counter();
                            variant2.setProperty("AC", c.getAC());
                            variant2.setProperty("AN", c.getAN());
                            variant2.setProperty("AF", Float.valueOf(c.getAF()));
                            variant2.setProperty("GT_COUNTER", c.encode());
                            variant2.setGenotypes(null);
                            writer.write(variant2);
                            bar.step(0L, 0L, 1L);
                            ++count;
                        }
                        total += count;
                        counter.put(file, new TIntLongEntry(((TIntLongEntry)counter.get(file)).getKey(), count));
                    }
                    catch (Throwable variant3) {
                        reader2 = variant3;
                        throw variant3;
                    }
                    finally {
                        if (reader != null) {
                            if (reader2 != null) {
                                try {
                                    ((VCFReader)reader).close();
                                }
                                catch (Throwable variant3) {
                                    reader2.addSuppressed(variant3);
                                }
                            } else {
                                ((VCFReader)reader).close();
                            }
                        }
                    }
                    bar.step(1L, 0L, 0L);
                }
            } else {
                for (String file : program.files) {
                    reader = PLINKFile.load(file, PLINKType.valueOf(program.type)).instance(true);
                    reader2 = null;
                    try {
                        count = 0L;
                        while ((variant2 = ((PLINKReader)reader).read()) != null) {
                            c = variant2.getGenotypes().counter();
                            variant2.setProperty("AC", c.getAC());
                            variant2.setProperty("AN", c.getAN());
                            variant2.setProperty("AF", Float.valueOf(c.getAF()));
                            variant2.setProperty("GT_COUNTER", c.encode());
                            variant2.setGenotypes(null);
                            writer.write(variant2);
                            bar.step(0L, 0L, 1L);
                            ++count;
                        }
                        total += count;
                        counter.put(file, new TIntLongEntry(((TIntLongEntry)counter.get(file)).getKey(), count));
                    }
                    catch (Throwable throwable) {
                        reader2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (reader != null) {
                            if (reader2 != null) {
                                try {
                                    ((PLINKReader)reader).close();
                                }
                                catch (Throwable throwable) {
                                    reader2.addSuppressed(throwable);
                                }
                            } else {
                                ((PLINKReader)reader).close();
                            }
                        }
                    }
                    bar.step(1L, 0L, 0L);
                }
            }
            bar.close();
            writer.close();
            StringBuilder report = new StringBuilder();
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            report.append("\nSummary:\n");
            report.append(String.format("  - Total unique input files: %s\n", numberFormat.format(program.files.size())));
            report.append(String.format("  - Total unique individuals collected: %s\n", numberFormat.format(((AbstractCollection)individuals).size())));
            report.append(String.format("  - Total unique variant sites collected: %s\n\n", numberFormat.format(total)));
            report.append("Detailed individual counts per file:\n");
            for (String file : program.files) {
                report.append(String.format("  - %s: %s individuals and %s variant sites\n", file, numberFormat.format(((TIntLongEntry)counter.get(file)).getKey()), numberFormat.format(((TIntLongEntry)counter.get(file)).getValue())));
            }
            report.append("\nOutput file: ").append(program.output);
            LOGGER.info(report.toString());
        }
    }
}

