/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.command.convetter.CCFMetaConverter;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.loader.CCFChunk;
import edu.sysu.pmglab.ccf.loader.CCFLoader;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.RecordConcatenator;
import edu.sysu.pmglab.ccf.toolkit.converter.Variant2Variant;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.IListener;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.option.DynamicOption;
import edu.sysu.pmglab.commandParser.annotation.option.Indirect;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.rangelist.VarInt32RangeList;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.command.IndividualsSelectionConverter;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.progressbar.MultiProgressBar;
import edu.sysu.pmglab.progressbar.ProgressConsumer;
import edu.sysu.pmglab.progressbar.TextProgressRenderers;
import edu.sysu.pmglab.progressbar.console.ConsoleConsumer;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="concat <input> <input> ... --output <output> [options]", usage_item={@UsageItem(key="API", value={"edu.sysu.pmglab.ccf.toolkit.RecordConcatenator"}), @UsageItem(key="About", value={"Concatenate multiple *.gtb files. Concatenate means adding on rows to *.gtb (e.g. re-combining split chromosomes)."})}, indirect=@Indirect(enable=true))
public class ConcatGTBCommandProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcatGTBCommandProgram.class);
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--silent"}, type=FieldType.NULL)
    @OptionUsage(description={"Suppress terminal output logs."})
    boolean silent = false;
    @Option(names={"concat"}, type=FieldType.livefile, container=Container.LIST, required=true)
    List<LiveFile> files;
    @Option(names={"--output", "-o"}, type=FieldType.file, defaultTo={"./archive.gtb"})
    @OptionUsage(description={"Set the output file path."}, defaultTo="./archive.gtb", format="--output <file>")
    File output = new File(RuntimeProperty.WORKSPACE_PATH, "archive.gtb");
    @Option(names={"--flush"}, type=FieldType.NULL)
    @OptionUsage(description={"Force full reprocessing of the GTB file even if it meets fast concatenation criteria."})
    boolean flush = false;
    @CustomOption(names={"--individual"}, converter=IndividualsSelectionConverter.class, arity={-1})
    @OptionUsage(description={"Select a subset of individuals. If this option is not specified, the individuals will be determined by all input files."}, format="--individual <string>,<string>,...")
    IndexableSet<String> individuals = null;
    @Option(names={"--field", "-f"}, type=FieldType.string, container=Container.LIST)
    @OptionUsage(description={"Select a subset of fields from the first input."}, format="--field <string> <string> ...")
    List<String> fields = null;
    @Option(names={"--disable-sort"}, type=FieldType.NULL)
    @OptionUsage(description={"Disable sorting of output variants."})
    boolean sort = true;
    @Option(names={"--ignore-index"}, type=FieldType.NULL)
    @OptionUsage(group="Output Options", description={"Disable coordinate-index table generation. By default, indexes are automatically created for optimized access."})
    boolean buildIndex = true;
    @Option(names={"--retain-meta-from"}, type=FieldType.varInt32RangeList, defaultTo={"0"})
    @OptionUsage(description={"Retain metadata from specified input files.", "To disable this functionality, use '-1'."}, format="--retain-meta-from <int>,<int>~<int>,...", defaultTo="0")
    VarInt32RangeList retainMetasFrom = new VarInt32RangeList().add(0);
    @DynamicOption(names={"--add-meta"}, args={"key", "value=", "type=string"}, converter=CCFMetaConverter.class, repeated=true)
    @OptionUsage(description={"Add metadata to the output file."}, format="--add-meta <key> [value] [type=string]")
    List<CCFMetaItem> metas = null;
    @Option(names={"--drop-duplicate-meta"}, type=FieldType.NULL)
    @OptionUsage(description={"Remove duplicate metadata entries from the output file."})
    boolean dropDuplicateMeta = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        GTBSorter sorter;
        IndexableSet<String> individuals;
        IFieldCollection fields;
        String[] stringArray;
        ConcatGTBCommandProgram program = new ConcatGTBCommandProgram();
        if (args.length == 1 && args[0].equals("concat")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (!program.silent) {
            LOGGER.info("\n{}", (Object)options);
        }
        ICCFMeta meta = new CCFMeta().adds(program.metas);
        if (program.files.size() > 0) {
            GTBManager manager = new GTBManager(program.files.fastGet(0));
            fields = program.fields == null ? ((FieldGroupMetas)((FieldGroupMetas)new FieldGroupMetas().addFields((Iterable)GTBManager.FIELDS)).addFields((Iterable)manager.getTable().getAllFields())).asUnmodifiable() : ((FieldGroupMetas)((FieldGroupMetas)new FieldGroupMetas().addFields((Iterable)GTBManager.FIELDS)).addFields((Iterable)manager.subsetFields(program.fields))).asUnmodifiable();
        } else {
            fields = GTBManager.FIELDS;
        }
        if (program.individuals == null) {
            CCFLoader loader = new CCFLoader(List.wrap(new CCFChunk.Type[]{CCFChunk.Type.OPTION}).toSet());
            individuals = new LinkedSet<String>();
            for (LiveFile file : program.files) {
                individuals.addAll(loader.parse(file).getOption("GTB_INDIVIDUAL", IndexableSet.EMPTY()));
            }
        } else {
            individuals = program.individuals.asUnmodifiable();
        }
        RecordConcatenator concatenator = new RecordConcatenator(program.output).addFields(fields).addOption(CCFMetaItem.of("GTB_INDIVIDUAL", individuals));
        try (final MultiProgressBar bar = new MultiProgressBar.Builder().setConsumer(program.silent ? ProgressConsumer.SILENT : new ConsoleConsumer()).setRenderers(new TextProgressRenderers().add("Done", "files").add("Concatenated", "variants")).build();){
            for (int index = 0; index < program.files.size(); ++index) {
                try {
                    GTBManager manager = new GTBManager(program.files.fastGet(index));
                    if (program.retainMetasFrom.contains(index)) {
                        meta.adds(manager.getMeta());
                    }
                    IntList indexes = individuals.findIndicesIn(manager.getIndividuals());
                    if (!program.flush && indexes == null && concatenator.tryAppend(manager.getTable())) {
                        bar.step(1L, manager.numOfVariants());
                        continue;
                    }
                    boolean hasOverlaps = individuals.hasOverlaps(manager.getIndividuals());
                    File temp = RuntimeProperty.createTempFile();
                    Processor.setInput(new GTBInputOption((GTBReaderOption)new GTBReaderOption(manager, hasOverlaps, false).addFields(fields))).setOutput(new GTBOutputOption(temp).addFields(fields).addIndividuals(individuals)).bridge(new Variant2Variant().setValue(variant -> {
                        variant.setGenotypes(variant.getGenotypes().subGenotypes(indexes));
                        return true;
                    })).setListener(new IListener<List<GTBInputOption>, GTBOutputOption>(){

                        @Override
                        public void step(List<GTBInputOption> input, GTBOutputOption output, long read, long write) {
                            bar.step(0L, write);
                        }
                    }).submit(program.threads);
                    concatenator.append(new CCFTable(temp));
                    bar.step(1L, 0L);
                    FileUtils.delete(temp);
                    continue;
                }
                finally {
                    CCFTable.gc();
                }
            }
        }
        concatenator.addMeta(program.dropDuplicateMeta ? meta.dropDuplicates() : meta);
        concatenator.finish();
        if (program.sort && !(sorter = GTBSorter.setInput(program.output, new String[0]).setListener(program.silent ? null : new SortListener("Crude Indexed", "Sorted", "variants"))).isOrdered(program.threads)) {
            sorter.sort(program.output, program.threads, false);
        }
        if (program.buildIndex) {
            GTBIndexer.setInput(program.output, new String[0]).setListener(program.silent ? null : new InputListener("Indexed", "variants")).save(program.threads);
        }
    }
}

