/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.EntryOption;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.gtb.command.program.GTB2GTBCommandProgram;
import edu.sysu.pmglab.gtb.command.program.GTB2PLINKCommandProgram;
import edu.sysu.pmglab.gtb.command.program.GTB2VCFCommandProgram;
import edu.sysu.pmglab.gtb.command.program.MAF2GTBCommandProgram;
import edu.sysu.pmglab.gtb.command.program.PLINK2GTBCommandProgram;
import edu.sysu.pmglab.gtb.command.program.PLINK2PLINKCommandProgram;
import edu.sysu.pmglab.gtb.command.program.PLINK2VCFCommandProgram;
import edu.sysu.pmglab.gtb.command.program.TEXT2GTBCommandProgram;
import edu.sysu.pmglab.gtb.command.program.TEXT2VCFCommandProgram;
import edu.sysu.pmglab.gtb.command.program.VCF2GTBCommandProgram;
import edu.sysu.pmglab.gtb.command.program.VCF2PLINKCommandProgram;
import edu.sysu.pmglab.gtb.command.program.VCF2VCFCommandProgram;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="convert [options]", usage_item={@UsageItem(key="About", value={"The GenoType Block Compressor (GBC) offers a unified framework for converting, filtering, and subsetting genotype data across multiple formats.  With the convert subcommand, you can efficiently perform parallelized transformations between VCF, MAF, TEXT, GTB, and PLINK formats.  These operations leverage the Variant object as a common intermediary, enabling smooth, standardized data handling across formats."})})
public class ConverterEntry
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConverterEntry.class);
    @EntryOption(value={"vcf2gtb"}, retain=true)
    @OptionUsage(group="Convert to GTB Options", description={"Convert VCF format to GTB format."})
    String[] vcf2gtb;
    @EntryOption(value={"plink2gtb"}, retain=true)
    @OptionUsage(group="Convert to GTB Options", description={"Convert PLINK format to GTB format."})
    String[] plink2gtb;
    @EntryOption(value={"maf2gtb"}, retain=true)
    @OptionUsage(group="Convert to GTB Options", description={"Convert MAF format to GTB format."})
    String[] maf2gtb;
    @EntryOption(value={"text2gtb"}, retain=true)
    @OptionUsage(group="Convert to GTB Options", description={"Convert TEXT format to GTB format."})
    String[] text2gtb;
    @EntryOption(value={"gtb2gtb"}, retain=true)
    @OptionUsage(group="Convert to GTB Options", description={"Convert GTB format to GTB format."})
    String[] gtb2gtb;
    @EntryOption(value={"vcf2vcf"}, retain=true)
    @OptionUsage(group="Convert to VCF Options", description={"Convert VCF format to VCF format."})
    String[] vcf2vcf;
    @EntryOption(value={"plink2vcf"}, retain=true)
    @OptionUsage(group="Convert to VCF Options", description={"Convert PLINK format to VCF format."})
    String[] plink2vcf;
    @EntryOption(value={"text2vcf"}, retain=true)
    @OptionUsage(group="Convert to VCF Options", description={"Convert TEXT format to VCF format."})
    String[] text2vcf;
    @EntryOption(value={"gtb2vcf"}, retain=true)
    @OptionUsage(group="Convert to VCF Options", description={"Convert GTB format to VCF format."})
    String[] gtb2vcf;
    @EntryOption(value={"vcf2plink"}, retain=true)
    @OptionUsage(group="Convert to PLINK Options", description={"Convert VCF format to PLINK format."})
    String[] vcf2plink;
    @EntryOption(value={"plink2plink"}, retain=true)
    @OptionUsage(group="Convert to PLINK Options", description={"Convert PLINK format to PLINK format."})
    String[] plink2plink;
    @EntryOption(value={"gtb2plink"}, retain=true)
    @OptionUsage(group="Convert to PLINK Options", description={"Convert GTB format to PLINK format."})
    String[] gtb2plink;

    public static void main(String[] args) throws IOException {
        ConverterEntry program = new ConverterEntry();
        CommandOptions options = program.parse(args);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (options.passed("vcf2gtb")) {
            VCF2GTBCommandProgram.main(program.vcf2gtb);
            return;
        }
        if (options.passed("plink2gtb")) {
            PLINK2GTBCommandProgram.main(program.plink2gtb);
            return;
        }
        if (options.passed("maf2gtb")) {
            MAF2GTBCommandProgram.main(program.maf2gtb);
            return;
        }
        if (options.passed("text2gtb")) {
            TEXT2GTBCommandProgram.main(program.text2gtb);
            return;
        }
        if (options.passed("gtb2gtb")) {
            GTB2GTBCommandProgram.main(program.gtb2gtb);
            return;
        }
        if (options.passed("vcf2vcf")) {
            VCF2VCFCommandProgram.main(program.vcf2vcf);
            return;
        }
        if (options.passed("plink2vcf")) {
            PLINK2VCFCommandProgram.main(program.plink2vcf);
            return;
        }
        if (options.passed("text2vcf")) {
            TEXT2VCFCommandProgram.main(program.text2vcf);
            return;
        }
        if (options.passed("gtb2vcf")) {
            GTB2VCFCommandProgram.main(program.gtb2vcf);
            return;
        }
        if (options.passed("vcf2plink")) {
            VCF2PLINKCommandProgram.main(program.vcf2plink);
            return;
        }
        if (options.passed("plink2plink")) {
            PLINK2PLINKCommandProgram.main(program.plink2plink);
            return;
        }
        if (options.passed("gtb2plink")) {
            GTB2PLINKCommandProgram.main(program.gtb2plink);
            return;
        }
    }
}

