/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.converter.IConverter;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.Indirect;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.option.OptionBundle;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.container.entry.TTriEntry;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.command.VariantProcessOptions;
import edu.sysu.pmglab.gtb.command.input.GTBInputCommandOptions;
import edu.sysu.pmglab.gtb.command.input.StandardVariantInputCommandOptions;
import edu.sysu.pmglab.gtb.command.output.GTBOutputCommandOptions;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="gtb2gtb <input> <input> ... --output <output> [options]", usage_item={@UsageItem(key="API", value={"edu.sysu.pmglab.ccf.toolkit.Processor"}), @UsageItem(key="About", value={"Convert GTB format to GTB format."})}, indirect=@Indirect(enable=true))
public class GTB2GTBCommandProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(GTB2GTBCommandProgram.class);
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--silent"}, type=FieldType.NULL)
    @OptionUsage(description={"Suppress terminal output logs."})
    boolean silent = false;
    @Option(names={"gtb2gtb"}, type=FieldType.livefile, container=Container.LIST, required=true)
    List<LiveFile> files;
    @OptionBundle
    GTBInputCommandOptions input = new GTBInputCommandOptions();
    @OptionBundle
    VariantProcessOptions processor = new VariantProcessOptions();
    @OptionBundle
    GTBOutputCommandOptions output = new GTBOutputCommandOptions();

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        final GTB2GTBCommandProgram program = new GTB2GTBCommandProgram();
        if (args.length == 1 && args[0].equals("gtb2gtb")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (!program.silent) {
            LOGGER.info("\n{}", (Object)options);
        }
        StandardVariantInputCommandOptions<Variant, GTBInputOption> inputOptions = program.input.getInputOptions(program.files);
        Processor.setInputs(inputOptions).setOutput(program.output.getOutputOptions(inputOptions)).configureOption((inputs, output) -> {
            if (program.output.getAllFields() == null) {
                if (inputs.size() > 0) {
                    output.addFields(((GTBInputOption)inputs.fastGet(0)).getAllFields());
                }
            } else {
                for (TTriEntry<String, IFieldType, String> field : program.output.getAllFields()) {
                    if (field == null) continue;
                    if (field.getValue2() == null) {
                        IFieldType inferType;
                        output.addField(field.getValue1(), (inferType = ((GTBInputOption)inputs.fastGet(0)).getAllFields().getFieldType(field.getValue1())) == null ? FieldType.bytecode : inferType);
                        continue;
                    }
                    output.addField(field.getValue1(), field.getValue2());
                }
            }
        }).bridge(new IConverter<Variant, GTBInputOption, Variant, GTBOutputOption>(){
            final ILiteConverter<Variant, Iterable<Variant>> converter;
            {
                this.converter = program.processor.getVariantConverter();
            }

            @Override
            public Iterable<Variant> converter(Variant input, GTBInputOption source2, long pointer, GTBOutputOption target) throws IOException {
                if (program.output.getAllFields() != null) {
                    for (TTriEntry<String, IFieldType, String> field : program.output.getAllFields()) {
                        if (field == null) continue;
                        input.setProperty(field.getValue1(), input.getProperty(field.getValue3()));
                    }
                }
                return this.converter.converter(input);
            }
        }).setListener(program.silent ? null : new InputOutputListener("Input", "variants", "Output", "variants")).submit(program.threads);
        program.output.finish(program.silent, program.threads);
    }
}

