/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Available;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.converter.StringArrayConverter;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.toolkit.GTBMerger;
import edu.sysu.pmglab.progressbar.ProgressBar;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="merge <major> <minor> --output <output> [options]", usage_item={@UsageItem(key="API", value={"edu.sysu.pmglab.gbc.toolkit.GTBMerger"}), @UsageItem(key="About", value={"\u5408\u5e76\u4e24\u4e2a GTB \u6587\u4ef6 (\u4e0d\u540c\u961f\u5217)."})})
public class GTBMergerCommandProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(GTBMergerCommandProgram.class);
    @CustomOption(names={"merge"}, required=true, arity={2}, converter=StringArrayConverter.class)
    String[] inputs;
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--silent"}, type=FieldType.NULL)
    @OptionUsage(description={"Suppress terminal output logs."})
    boolean silent = false;
    @Option(names={"--method", "-m"}, available=@Available(value={"UNION", "INTERSECT", "MAJOR", "MINOR"}), defaultTo={"UNION"})
    @OptionUsage(description={"Specifies the file alignment method during merging."}, defaultTo="UNION", format="--method [UNION/INTERSECT/MAJOR/MINOR]")
    String method = "UNION";
    @Option(names={"--output", "-o"}, type=FieldType.file, defaultTo={"./archive.gtb"})
    @OptionUsage(description={"Set the output file path."}, defaultTo="./archive.gtb", format="--output <file>")
    File output = new File(RuntimeProperty.WORKSPACE_PATH, "archive.gtb");

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        GTBMergerCommandProgram program = new GTBMergerCommandProgram();
        if (args.length == 1 && args[0].equals("merge")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (!program.silent) {
            LOGGER.info("\n{}", (Object)options);
        }
        ProgressBar bar = new ProgressBar.Builder().build();
        GTBMerger merger = GTBMerger.setMajorManager(program.inputs[0], null).setMinorManager(program.inputs[1], null).setOutput(program.output).setConverter(input -> {
            bar.step(1L);
            return List.singleton(input);
        });
        switch (program.method) {
            case "UNION": {
                merger.union(program.threads);
                break;
            }
            case "INTERSECT": {
                merger.intersect(program.threads);
                break;
            }
            case "MAJOR": {
                merger.alignToMajor(program.threads);
                break;
            }
            case "MINOR": {
                merger.alignToMinor(program.threads);
            }
        }
        bar.close();
    }
}

