/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.header.CCFHeader;
import edu.sysu.pmglab.ccf.header.CCFHeaders;
import edu.sysu.pmglab.ccf.loader.FieldGroupDataCodec;
import edu.sysu.pmglab.ccf.loader.FieldGroupMetaCodec;
import edu.sysu.pmglab.ccf.loader.MetaCodec;
import edu.sysu.pmglab.ccf.loader.OptionCodec;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.validator.range.IRangeValidator;
import edu.sysu.pmglab.container.interval.Interval;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.writer.ChannelWriterStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="refine <input> --output <output> [options]", usage_item={@UsageItem(key="API"), @UsageItem(key="About", value={"\u4f18\u5316 GTB/CCF \u6587\u4ef6 (\u8c03\u6574\u884c\u5217\u5757\u5e03\u5c40)."})})
public class GTBRefineCommandProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(GTBRefineCommandProgram.class);
    @Option(names={"refine"}, type=FieldType.livefile, required=true)
    LiveFile file;
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--silent"}, type=FieldType.NULL)
    @OptionUsage(description={"Suppress terminal output logs."})
    boolean silent = false;
    @Option(names={"--output", "-o"}, type=FieldType.file, defaultTo={"./archive.gtb"})
    @OptionUsage(description={"Set the output file path."}, defaultTo="./archive.gtb", format="--output <file>")
    File output = new File(RuntimeProperty.WORKSPACE_PATH, "archive.gtb");

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        GTBRefineCommandProgram program = new GTBRefineCommandProgram();
        if (args.length == 1 && args[0].equals("refine")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (!program.silent) {
            LOGGER.info("\n{}", (Object)options);
        }
        CCFTable table = new CCFTable(program.file);
        ChannelWriterStream writer = new ChannelWriterStream(RuntimeProperty.createTempFile());
        MetaCodec.saveTo(table.getMeta(), writer);
        OptionCodec.saveTo(table.getOptions(), (IWriterStream)writer);
        FieldGroupMetaCodec.saveTo(table.getAllFields(), writer);
        ISeekableReaderStream reader = table.getFile().openAsBinary();
        int groupIndex = 0;
        for (String groupName : table.getAllFieldGroupNames()) {
            CCFHeaders blocks = table.getFieldGroupBlocks(groupName);
            ByteStream temp = ByteStream.getThreadInstance();
            temp.putVarInt32(groupIndex);
            temp.putVarInt32(0);
            temp.putVarInt32(blocks.numOfBlocks());
            long length = 0L;
            for (CCFHeader block : blocks) {
                temp.putVarInt32(block.numOfRecords());
                temp.putVarInt32(block.length());
                length += (long)block.length();
            }
            writer.write(FieldGroupDataCodec.getType().ordinal());
            writer.writeLong((long)temp.length() + length, 8);
            writer.write(temp.bytes(), temp.offset(), temp.length());
            for (CCFHeader block : blocks) {
                int byteToWrite;
                reader.seek(block.tell());
                for (int count = block.length(); count > 0; count -= byteToWrite) {
                    byteToWrite = reader.read(temp.bytes(), 0, Math.min(temp.capacity(), count));
                    writer.write(temp.bytes(), 0, byteToWrite);
                }
            }
            ++groupIndex;
        }
        reader.close();
        writer.close();
        FileUtils.rename(writer.getFile(), program.output);
    }

    private static enum Bucket_Size_RangeValidator implements IRangeValidator<Integer>
    {
        INSTANCE;


        @Override
        public Interval<Integer> range() {
            return new Interval<Integer>(128, 0x10000000);
        }
    }

    private static enum Buffer_Size_RangeValidator implements IRangeValidator<Integer>
    {
        INSTANCE;


        @Override
        public Interval<Integer> range() {
            return new Interval<Integer>(64, 0x10000000);
        }
    }
}

