/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.toolkit.RecordConcatenator;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Indirect;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.rule.Chain;
import edu.sysu.pmglab.commandParser.annotation.rule.Counter;
import edu.sysu.pmglab.commandParser.annotation.rule.Rule;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.validator.range.IRangeValidator;
import edu.sysu.pmglab.container.interval.Interval;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="sort <input> --output <output> [options]", usage_item={@UsageItem(key="API", value={"edu.sysu.pmglab.gbc.toolkit.GTBSorter"}), @UsageItem(key="About", value={"Sort the variants in *.gtb by coordinate fields (CHROM, POS)."})}, rule=@Rule(chain={@Chain(item={@Counter(item={"--no-crude-bucket"}), @Counter(item={"--min-refined-bucket-size", "--max-refined-bucket-size", "--buffer-size"}, count=0)})}), indirect=@Indirect(enable=true))
public class GTBSortCommandProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(GTBSortCommandProgram.class);
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--silent"}, type=FieldType.NULL)
    @OptionUsage(description={"Suppress terminal output logs."})
    boolean silent = false;
    @Option(names={"sort"}, type=FieldType.livefile, required=true)
    LiveFile file;
    @Option(names={"--output", "-o"}, type=FieldType.file, defaultTo={"./archive.gtb"})
    @OptionUsage(description={"Set the output file path."}, defaultTo="./archive.gtb", format="--output <file>")
    File output = new File(RuntimeProperty.WORKSPACE_PATH, "archive.gtb");
    @Option(names={"--ignore-index"}, type=FieldType.NULL)
    @OptionUsage(group="Output Options", description={"Disable coordinate-index table generation. By default, indexes are automatically created for optimized access."})
    boolean buildIndex = true;
    @Option(names={"--no-check"}, type=FieldType.NULL)
    @OptionUsage(description={"Do not check that the input file is in order."})
    boolean check = true;
    @Option(names={"--no-crude-bucket"}, type=FieldType.NULL)
    @OptionUsage(description={"Disable crude bucket scanning. All coordinates and pointers are loaded into memory, which is typically useful for small genomic files."})
    boolean fastSort = false;
    @Option(names={"--buffer-size"}, type=FieldType.int32, defaultTo={"65536"}, validator=Buffer_Size_RangeValidator.class)
    @OptionUsage(defaultTo="65536", format="--buffer-size <int>", description={"Batch size for in-memory sorting (controls variants processed per batch)."})
    int bufferSize = 65536;
    @Option(names={"--min-refined-bucket-size"}, type=FieldType.int32, defaultTo={"1024"}, validator=Bucket_Size_RangeValidator.class)
    @OptionUsage(defaultTo="1024", format="--min-refined-bucket-size <int>", description={"Minimum refined bucket size during merging (avoids tiny buckets harming I/O)."})
    int minRefinedBucketSize = 1024;
    @Option(names={"--max-refined-bucket-size"}, type=FieldType.int32, defaultTo={"2097152"}, validator=Bucket_Size_RangeValidator.class)
    @OptionUsage(defaultTo="2097152", format="--max-refined-bucket-size <int>", description={"Maximum refined bucket size during merging (balances memory and disk efficiency)."})
    int maxRefinedBucketSize = 0x200000;

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        GTBSortCommandProgram program = new GTBSortCommandProgram();
        if (args.length == 1 && args[0].equals("sort")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (!program.silent) {
            LOGGER.info("\n{}", (Object)options);
        }
        GTBManager gtb = new GTBManager(program.file);
        GTBSorter sorter = GTBSorter.setInput(gtb).setBufferSize(program.bufferSize).setMinRefinedBucketSize(program.minRefinedBucketSize).setMaxRefinedBucketSize(program.maxRefinedBucketSize).setListener(program.silent ? null : new SortListener("Crude Indexed", "Sorted", "variants"));
        if (!program.check || !sorter.isOrdered(program.threads)) {
            sorter.sort(program.output, program.threads, program.fastSort);
        } else {
            RecordConcatenator concatenator = new RecordConcatenator(program.output);
            concatenator.addFields(gtb.getTable().getAllFields()).addMeta(gtb.getMeta()).addOptions(gtb.getTable().getOptions().filter(item -> !item.getKey().equals("INDEXER"))).append(gtb.getTable()).finish();
        }
        if (program.buildIndex) {
            GTBIndexer.setInput(program.output, new String[0]).setListener(program.silent ? null : new InputListener("Indexed", "variants")).save(program.threads);
        }
    }

    private static enum Bucket_Size_RangeValidator implements IRangeValidator<Integer>
    {
        INSTANCE;


        @Override
        public Interval<Integer> range() {
            return new Interval<Integer>(128, 0x10000000);
        }
    }

    private static enum Buffer_Size_RangeValidator implements IRangeValidator<Integer>
    {
        INSTANCE;


        @Override
        public Interval<Integer> range() {
            return new Interval<Integer>(64, 0x10000000);
        }
    }
}

