/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.filter.CCFFilter;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.viewer.CCFViewer;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.validator.range.Int_0_RangeValidator;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.viewer.GTBViewerReader;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="gui <file> [options]", usage_item={@UsageItem(key="About", value={"Display the *.gtb file in the visualization software window."})})
public class GUIProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(GUIProgram.class);
    @Option(names={"gui"}, type=FieldType.livefile, required=true)
    LiveFile input;
    @Option(names={"--field", "-f"}, type=FieldType.string, container=Container.LIST)
    @OptionUsage(description={"Specify the fields to be read from the input file.", "If not specified, all fields will be read."}, format="--field <field> <field> ...")
    List<String> fields = null;
    @Option(names={"--index-range", "-ir"}, type=FieldType.longInterval)
    @OptionUsage(description={"Retrieve variants within a specified range of variant indices from 'min' (inclusive) to 'max' (exclusive)."}, format="--index-range <min>~<max>")
    LongInterval range = null;
    @Option(names={"--page-size", "-s"}, type=FieldType.varInt32, validator=Int_0_RangeValidator.class)
    @OptionUsage(description={"Set the number of variants displayed per page."}, format="--page-size <int, >=10>")
    int pagesize = 100;
    @Option(names={"--compat-mode", "-c"}, type=FieldType.NULL)
    @OptionUsage(description={"Display the graphical window in compatibility mode (use when the table layout is abnormal)."})
    boolean compat = false;

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        GUIProgram program = new GUIProgram();
        if (args.length == 1 && args[0].equals("gui")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        GTBManager manager = new GTBManager(program.input);
        CCFFilter filter = null;
        if (program.range != null) {
            filter = new CCFFilter(new ReaderOption(manager.getTable(), false)).limit(program.range);
        }
        if (program.fields == null) {
            new CCFViewer(new GTBViewerReader((GTBReaderOption)new GTBReaderOption(manager).addAllFields(), filter), program.pagesize, program.compat);
        } else {
            new CCFViewer(new GTBViewerReader((GTBReaderOption)new GTBReaderOption(manager, true, false).addFields(program.fields), filter), program.pagesize, program.compat);
        }
    }
}

