/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.toolkit.CCFSlidingPairwiseCalculator;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.output.CCFOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.type.basic.VarInt32Box;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.rule.Counter;
import edu.sysu.pmglab.commandParser.annotation.rule.Rule;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.validator.range.Float_0_1_RangeValidator;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.interval.FloatInterval;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.command.GenomicCoordinatesSelectionConverter;
import edu.sysu.pmglab.gtb.command.IndividualsSelectionConverter;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.genotype.BitwiseGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.ConstantGenotypes;
import edu.sysu.pmglab.gtb.linkagedisequilibrium.EntropyLD;
import edu.sysu.pmglab.gtb.linkagedisequilibrium.GenotypeLD;
import edu.sysu.pmglab.gtb.linkagedisequilibrium.HaplotypeLD;
import edu.sysu.pmglab.gtb.linkagedisequilibrium.ILDModel;
import edu.sysu.pmglab.gtb.linkagedisequilibrium.LDProperty;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.objectpool.GenericObjectPool;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="ld <input> [options]", usage_item={@UsageItem(key="About", value={"Calculate pairwise the linkage disequilibrium or genotypic correlation.", "GBC-LDCalculator performs linkage disequilibrium calculations for biallelic variants, which is a common processing strategy. For multi-allelic variants, GBC-LDCalculator designates the highest frequency ALLELE as reference ALLELE, treating others as alternative ALLELE during computation. For multiple variants with the same coordinates, GBC selects the variant with the maximum MAF for calculation and discards the others."})}, rule=@Rule(counter={@Counter(item={"--hap-ld", "--geno-ld", "--entropy-ld"}, rule=Counter.Type.EQUAL, count=1)}))
public class LDCalculatorProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(LDCalculatorProgram.class);
    @Option(names={"ld"}, type=FieldType.livefile, required=true)
    LiveFile input;
    @Option(names={"--output", "-o"}, type=FieldType.file, defaultTo={"./archive.ld.ccf"})
    @OptionUsage(defaultTo="./archive.ld.ccf", description={"Specify the output file path."})
    File output = new File(RuntimeProperty.WORKSPACE_PATH, "./archive.ld.ccf");
    @Option(names={"--silent"}, type=FieldType.NULL)
    @OptionUsage(description={"Suppress terminal output logs."})
    boolean silent = false;
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--hap-ld"}, type=FieldType.NULL)
    @OptionUsage(group="LD Model Options", description={"Calculate the linkage disequilibrium coefficient for paired variants using D' method."})
    boolean hapLd = false;
    @Option(names={"--geno-ld"}, type=FieldType.NULL)
    @OptionUsage(group="LD Model Options", description={"Calculate the linkage disequilibrium coefficient for paired variants using the Pearson correlation coefficient method applied to the mutation genotype counts."})
    boolean genoLd = false;
    @Option(names={"--entropy-ld"}, type=FieldType.NULL)
    @OptionUsage(group="LD Model Options", description={"Calculate the linkage disequilibrium coefficient for paired variants using mutual information (MI) method."})
    boolean entropyLd = false;
    @Option(names={"--window-bp", "-bp"}, type=FieldType.varInt32, defaultTo={"10000"})
    @OptionUsage(group="LD Model Options", defaultTo="10000", format="--window-bp <int>", description={"Set the maximum number of physical bases between the variants being calculated for LD. "})
    int windows = 10000;
    @Option(names={"--min-assoc"}, type=FieldType.float32, validator=Float_0_1_RangeValidator.class, defaultTo={"0.2"})
    @OptionUsage(group="LD Model Options", defaultTo="0.2", format="--min-assoc <float>", description={"Exclude pairs with R2/NMI values less than --min-assoc."})
    float minAssoc = 0.2f;
    @CustomOption(names={"--individual"}, converter=IndividualsSelectionConverter.class)
    @OptionUsage(description={"Select a subset of individuals. Individuals not found in the inputs will have their genotype filled with './.'."}, format="--individual <string>,<string>,...", group="Subset Selection Options")
    IndexableSet<String> individuals = null;
    @CustomOption(names={"--pos"}, converter=GenomicCoordinatesSelectionConverter.class, arity={-1})
    @OptionUsage(description={"Retrieve the variants by the specified coordinate expression of variant.", "The expression can follow one of three formats: '<chr>' for the entire chromosome, '<chr>:<pos>,<pos>,...' for specific positions, or '<chr>:<start>-<end>,<start>-<end>,...' for coordinate ranges."}, format="--pos [expression] [expression] ...", group="Subset Selection Options")
    Map<Chromosome, List<IntInterval>> poses = null;
    @Option(names={"--seq-ac"}, type=FieldType.intInterval, defaultTo={"1~"})
    @OptionUsage(group="Subset Selection Options", defaultTo="1~", format="--seq-ac <minAc>~<maxAc>", description={"Exclude variants with the alternate allele count (AC) per variant outside the range [minAc, maxAc].", "If a subset selection occurs, this filter applies to the genotype sequences after selection."})
    IntInterval ac = new IntInterval(1, Integer.MAX_VALUE);
    @Option(names={"--seq-an"}, type=FieldType.intInterval, defaultTo={"50~"})
    @OptionUsage(group="Subset Selection Options", defaultTo="50~", format="--seq-an <minAn>~<maxAn>", description={"Exclude variants with the non-missing allele number (AN) per variant outside the range [minAn, maxAn].", "If a subset selection occurs, this filter applies to the genotype sequences after selection."})
    IntInterval an = new IntInterval(50, Integer.MAX_VALUE);
    @Option(names={"--seq-af"}, type=FieldType.floatInterval, defaultTo={"0.05~0.95"})
    @OptionUsage(group="Subset Selection Options", defaultTo="0.05~0.95", format="--seq-af <minAf>~<maxAf>", description={"Exclude variants with the alternate allele frequency (AF) per variant outside the range [minAf, maxAf].", "If a subset selection occurs, this filter applies to the genotype sequences after selection."})
    FloatInterval af = new FloatInterval(0.05f, 0.95f);

    public static void main(String[] args) throws IOException {
        IndexableSet<String> individuals;
        IFieldCollection fields;
        Enum model;
        String[] stringArray;
        LDCalculatorProgram program = new LDCalculatorProgram();
        if (args.length == 1 && args[0].equals("ld")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        LOGGER.info("\n{}", (Object)options);
        GTBManager input = new GTBManager(program.input);
        if (program.hapLd) {
            model = HaplotypeLD.INSTANCE;
            fields = HaplotypeLD.SCORE;
        } else if (program.genoLd) {
            model = GenotypeLD.INSTANCE;
            fields = GenotypeLD.SCORE;
        } else if (program.entropyLd) {
            model = EntropyLD.INSTANCE;
            fields = EntropyLD.SCORE;
        } else {
            model = null;
            fields = null;
        }
        if (program.individuals == null) {
            individuals = new LinkedSet<String>();
            individuals.addAll(input.getIndividuals());
        } else {
            individuals = program.individuals;
        }
        Map<Chromosome, IntIntervalTree<Void>> trees = GenomicCoordinatesSelectionConverter.toIntervalTree(program.poses);
        IntList relativeIndexes = input.getIndividuals().findIndicesIn(individuals);
        GenericObjectPool<LDProperty> properties = new GenericObjectPool<LDProperty>(() -> new LDProperty(individuals.size()));
        CCFSlidingPairwiseCalculator.setInput(new GTBReaderOption(input, true, false), record -> {
            VarInt32Box posBox = (VarInt32Box)record.getBox(null, "POS");
            Coordinate coordinate = new Coordinate((Chromosome)record.get(null, "CHROM"), posBox.intValue());
            if (trees != null) {
                if (!trees.containsKey(coordinate.getChromosome())) {
                    return null;
                }
                IntIntervalTree tree = (IntIntervalTree)trees.get(coordinate.getChromosome());
                if (tree != null && !tree.contains(coordinate.getPosition())) {
                    return null;
                }
            }
            Variant variant = new Variant(coordinate);
            if (record.containsKey(null, "ALLELE", FieldType.stringIndexableSet)) {
                variant.addAlleles((IndexableSet)record.get("ALLELE"));
            }
            if (record.containsKey(null, "GT", FieldType.bytecode)) {
                variant.setGenotypes(IGenotypes.load((Bytes)record.get(null, "GT")).map(BitwiseGenotypes.BIALLELIC).subGenotypes(relativeIndexes));
            } else {
                variant.setGenotypes(new ConstantGenotypes(individuals.size()).map(BitwiseGenotypes.BIALLELIC));
            }
            if (program.ac != null && !program.ac.contains(variant.getGenotypes().counter().getAC())) {
                return null;
            }
            if (program.an != null && !program.an.contains(variant.getGenotypes().counter().getAN())) {
                return null;
            }
            if (program.af != null && !program.af.contains(variant.getGenotypes().counter().getAF())) {
                return null;
            }
            return List.singleton(variant);
        }).calculate(new BiFunction<Variant, Variant, IRecord>((ILDModel)((Object)model), program){
            final ThreadLocal<IRecord> records = ThreadLocal.withInitial(() -> new BoxRecord(fields));
            final /* synthetic */ ILDModel val$model;
            final /* synthetic */ LDCalculatorProgram val$program;
            {
                this.val$model = iLDModel;
                this.val$program = lDCalculatorProgram;
            }

            @Override
            public IRecord apply(Variant variant1, Variant variant2) {
                IRecord record = this.records.get();
                if (this.val$model.apply(variant1, variant2, this.val$program.minAssoc, this.records.get())) {
                    return record;
                }
                return null;
            }
        }).setOutput(new CCFOutputOption(program.output).addFields(fields)).makeWindowsIf((variant1, variant2) -> {
            if (variant1.getChromosome() != variant2.getChromosome()) {
                return false;
            }
            return Math.abs(variant1.getPosition() - variant2.getPosition()) <= program.windows;
        }).init(variant -> variant.setProperty(LDProperty.class.getName(), ((LDProperty)properties.borrowObject()).reload((Variant)variant))).destroy(variant -> properties.returnObject((LDProperty)variant.getProperty(LDProperty.class.getName()))).setListener(program.silent ? null : new InputOutputListener("Input", "variants", "Calculated", "pairs")).submit(program.threads);
    }
}

