/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.bytecode.ASCIIUtility;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.toolkit.input.GTBInputOption;
import edu.sysu.pmglab.ccf.toolkit.input.InputProducer;
import edu.sysu.pmglab.ccf.toolkit.input.PLINKInputOption;
import edu.sysu.pmglab.ccf.toolkit.input.VCFInputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Available;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.option.DynamicOption;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.rule.Chain;
import edu.sysu.pmglab.commandParser.annotation.rule.Counter;
import edu.sysu.pmglab.commandParser.annotation.rule.Rule;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.converter.IConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.rangelist.VarInt32RangeList;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.command.GenomicCoordinatesSelectionConverter;
import edu.sysu.pmglab.gtb.command.LiftoverConverter;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKFile;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKType;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFReader;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.IgnoreGenotypeParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.StandardVCFGenotypeParser;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.writer.IWriterStream;
import edu.sysu.pmglab.io.writer.StdoutStream;
import edu.sysu.pmglab.io.writer.WriterStream;
import edu.sysu.pmglab.progressbar.unit.DataLengthUnit;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="less <file> [options]", usage_item={@UsageItem(key="About", value={"Display basic metadata and genotype statistics for various genotype formats. Supports GTB, VCF, PLINK BED/PGEN formats.  Can list individuals or extract variant-level information."})}, rule=@Rule(counter={@Counter(item={"--individual", "--site"}, rule=Counter.Type.AT_MOST, count=1)}, chain={@Chain(item={@Counter(item={"--shuffle", "--select-individual"}, rule=Counter.Type.AT_LEAST), @Counter(item={"--individual"})}, description="'--shuffle' and '--select-individual' options can only be used in conjunction with '--individual'"), @Chain(item={@Counter(item={"--liftover", "--index-range", "--pos"}, rule=Counter.Type.AT_LEAST), @Counter(item={"--site"})}, description="'--liftover', '--index-range' and '--pos' options can only be used in conjunction with '--site'")}))
public class LessProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(LessProgram.class);
    @Option(names={"less"}, type=FieldType.string, required=true)
    String input;
    @Option(names={"--type", "-t"}, available=@Available(value={"GTB", "VCF", "BED", "PGEN"}, upper=true), defaultTo={"GTB"})
    @OptionUsage(description={"Specify the input file type."}, format="--type [GTB/VCF/BED/PGEN]", defaultTo="GTB")
    String type = "GTB";
    @Option(names={"--output", "-o"}, type=FieldType.file)
    @OptionUsage(description={"Set the output file path. By default, outputs to standard output (terminal).", "If the provided path ends with '.gz' or '.bgz', BGZIP compression will be used."}, format="--output <file>")
    File output = null;
    @CustomOption(names={"--individual", "-i"}, arity={0, 1}, converter=IndividualConverter.class)
    @OptionUsage(description={"List individuals in the input file using the specified delimiter."}, format="--individual [COMMA/TAB/BLANK/SEMICOLON/LINE]", group="Individual-Level Options")
    String individual = null;
    @Option(names={"--select-individual", "-si"}, type=FieldType.varInt32RangeList)
    @OptionUsage(group="Individual-Level Options", description={"Retrieve the individuals by the specified index expression."}, format="--individual-index <int>,<start>~<end>,...")
    VarInt32RangeList individualIndex = null;
    @DynamicOption(names={"--shuffle"}, args={"seed=0"})
    @OptionUsage(group="Individual-Level Options", description={"Shuffle all individuals using the specified random seed."}, format="--shuffle [seed=0]")
    Map<String, String> shuffle;
    @CustomOption(names={"--site", "-s"}, arity={-1}, converter=SiteConverter.class)
    @OptionUsage(description={"List site information from the input file using specified fields."}, defaultTo="CHROM,POS,REF,ALT,AC,AN,AF,GT,ACs", format="'--site <field>,<field>,...' or '--site <field> <field> ...", group="Variant-Level Options")
    TextRecord sites = null;
    @CustomOption(names={"--liftover"}, converter=LiftoverConverter.class)
    @OptionUsage(description={"Lift over variants from one reference genome version to another.", "Chain files are auto-downloaded from http://hgdownload.cse.ucsc.edu/goldenPath/<version>/liftOver"}, format="--liftover <chain>", item={@UsageItem(key="Available", value={"hg19ToHg38, hg38ToHg19, hg18ToHg19, hg18ToHg38"})}, group="Variant-Level Options")
    LiftOver liftover = LiftOver.ITSELF;
    @Option(names={"--index-range", "-ir"}, type=FieldType.longInterval)
    @OptionUsage(description={"Retrieve variants within a specified range of variant indices from 'min' (inclusive) to 'max' (exclusive)."}, format="--index-range <min>~<max>", group="Variant-Level Options")
    LongInterval range = null;
    @CustomOption(names={"--pos", "-p"}, converter=GenomicCoordinatesSelectionConverter.class, arity={-1})
    @OptionUsage(description={"Retrieve the variants by the specified coordinate expression of variant.", "The expression can follow one of three formats: '<chr>' for the entire chromosome, '<chr>:<pos>,<pos>,...' for specific positions, or '<chr>:<start>-<end>,<start>-<end>,...' for coordinate ranges."}, format="--pos [expression] [expression] ...", group="Variant-Level Options")
    Map<Chromosome, List<IntInterval>> poses = null;

    public static void main(String[] args) throws IOException {
        block95: {
            String[] stringArray;
            LessProgram program = new LessProgram();
            if (args.length == 1 && args[0].equals("less")) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "--help";
            } else {
                stringArray = args;
            }
            CommandOptions options = program.parse(stringArray);
            if (options.isHelp()) {
                LOGGER.info("\n{}", (Object)options.usage());
                return;
            }
            try (IWriterStream stdout = program.output == null ? new StdoutStream() : new WriterStream(program.output, FileUtils.withExtension(program.output, ".gz", ".bgz") ? WriterStream.Option.BGZIP : WriterStream.Option.DEFAULT);){
                if (program.individual != null) {
                    int c;
                    IndexableSet<String> individuals;
                    if (program.type.equals("GTB")) {
                        individuals = new GTBManager(program.input).getIndividuals();
                    } else if (program.type.equals("VCF")) {
                        try (VCFReader reader = VCFReader.setInput(program.input).instance();){
                            individuals = reader.getIndividuals();
                        }
                    } else if (program.type.equals("BED")) {
                        individuals = PLINKFile.getIndividuals(program.input, PLINKType.BED);
                    } else if (program.type.equals("PGEN")) {
                        individuals = PLINKFile.getIndividuals(program.input, PLINKType.PGEN);
                    } else {
                        throw new ParameterException(program.type);
                    }
                    if (program.shuffle != null || program.individualIndex != null) {
                        List<String> UIDs;
                        if (program.individualIndex == null) {
                            UIDs = List.wrap(individuals);
                        } else {
                            UIDs = new List();
                            for (int i = 0; i < individuals.size(); ++i) {
                                if (!program.individualIndex.contains(i)) continue;
                                UIDs.add(individuals.valueOf(i));
                            }
                        }
                        if (program.shuffle != null) {
                            UIDs.shuffle(Long.parseLong(program.shuffle.get("seed")));
                        }
                        individuals = UIDs.toIndexableSet();
                    }
                    boolean empty = true;
                    switch (program.individual) {
                        case "COMMA": 
                        case ",": {
                            c = 44;
                            break;
                        }
                        case "TAB": 
                        case "\t": {
                            c = 9;
                            break;
                        }
                        case "BLANK": 
                        case " ": {
                            c = 32;
                            break;
                        }
                        case "SEMICOLON": 
                        case ";": {
                            c = 59;
                            break;
                        }
                        case "LINE": 
                        case "\n": {
                            c = 10;
                            break;
                        }
                        default: {
                            throw new ParameterException(program.individual);
                        }
                    }
                    for (String individual : individuals) {
                        if (!empty) {
                            stdout.write(c);
                        }
                        stdout.write(ASCIIUtility.toASCII(individual, StandardCharsets.UTF_8));
                        empty = false;
                    }
                    break block95;
                }
                if (program.sites != null) {
                    Variant variant;
                    InputProducer<Variant> reader;
                    boolean loadGT;
                    stdout.write(35);
                    boolean empty = true;
                    for (String field : program.sites.keys()) {
                        if (!empty) {
                            stdout.write(9);
                        }
                        stdout.write(ASCIIUtility.toASCII(field, StandardCharsets.UTF_8));
                        empty = false;
                    }
                    TextRecord record = program.sites;
                    boolean bl = loadGT = record.containsKey("AC") || record.containsKey("AN") || record.containsKey("AF") || record.containsKey("GT") || record.containsKey("ACs");
                    if (program.type.equals("GTB")) {
                        reader = new GTBInputOption((GTBReaderOption)new GTBReaderOption(program.input, loadGT, false).addFields(program.sites.keys())).getReaders(1).fastGet(0);
                    } else if (program.type.equals("VCF")) {
                        reader = new VCFInputOption(program.input).setGenotypeParser(value -> {
                            if (loadGT) {
                                return new StandardVCFGenotypeParser(value, true);
                            }
                            return new IgnoreGenotypeParser(value, false);
                        }).getReaders(1).fastGet(0);
                    } else if (program.type.equals("BED")) {
                        reader = new PLINKInputOption(program.input, PLINKType.BED, loadGT).getReaders(1).fastGet(0);
                    } else if (program.type.equals("PGEN")) {
                        reader = new PLINKInputOption(program.input, PLINKType.PGEN, loadGT).getReaders(1).fastGet(0);
                    } else {
                        throw new ParameterException(program.type);
                    }
                    BiConsumer<Variant, TextRecord> consumer = LessProgram.getConverter(record.keys());
                    Map<Chromosome, IntIntervalTree<Void>> coordinates = GenomicCoordinatesSelectionConverter.toIntervalTree(program.poses);
                    long pointer = -1L;
                    while ((variant = reader.read()) != null) {
                        IntIntervalTree<Void> tree;
                        ++pointer;
                        if ((variant = program.liftover.convert(variant)) == null || coordinates != null && (!coordinates.containsKey(variant.getChromosome()) || (tree = coordinates.get(variant.getChromosome())) != null && !tree.contains(variant.getPosition()))) continue;
                        if (program.range != null) {
                            if (program.range.end() <= pointer) break;
                            if (!program.range.contains(pointer)) continue;
                        }
                        stdout.write(10);
                        consumer.accept(variant, record);
                        empty = true;
                        for (int i = 0; i < record.size(); ++i) {
                            Bytes value2;
                            if (!empty) {
                                stdout.write(9);
                            }
                            if ((value2 = record.get(i)) == null) {
                                stdout.write(46);
                            } else {
                                stdout.write(value2);
                            }
                            empty = false;
                        }
                    }
                    reader.close();
                    break block95;
                }
                if (program.type.equals("GTB")) {
                    GTBManager manager = new GTBManager(program.input);
                    stdout.writeChar(manager.toString());
                    break block95;
                }
                if (program.type.equals("VCF")) {
                    IndexableSet<String> individuals;
                    LiveFile file = LiveFile.of(program.input);
                    try (VCFReader reader = VCFReader.setInput(program.input).instance();){
                        individuals = reader.getIndividuals();
                    }
                    stdout.writeChar("Summary of VCF File:");
                    stdout.writeChar("\n    VCF File Name: " + file.getName());
                    stdout.writeChar("\n    File Type: VCF" + (file.isBGZCompressed() ? " (BGZIP-compressed)" : (file.isGZCompressed() ? " (GZIP-compressed)" : " (TEXT)")));
                    stdout.writeChar("\n    VCF File Size: " + file.formatLength("#.###"));
                    stdout.writeChar("\n    VCF File Last Modify Time: " + file.formatLastModifyTime(null));
                    stdout.writeChar("\n    Number of Individuals: " + individuals.size() + " individual" + (individuals.size() <= 1 ? "" : "s"));
                    break block95;
                }
                if (program.type.equals("BED")) {
                    PLINKFile file = PLINKFile.load(program.input, PLINKType.BED);
                    stdout.writeChar("Summary of BED File:");
                    stdout.writeChar("\n    BED File Name: " + program.input);
                    stdout.writeChar("\n    BED File Size: " + DataLengthUnit.B.convert(LiveFile.of(program.input + ".bed").length() + LiveFile.of(program.input + ".fam").length() + LiveFile.of(program.input + ".bim").length(), new DecimalFormat("#.###")));
                    stdout.writeChar("\n    Dimension of Genotype: " + file.numOfVariants() + " variant" + (file.numOfVariants() <= 1L ? "" : "s") + " and " + file.numOfIndividuals() + " individual" + (file.numOfIndividuals() <= 1 ? "" : "s"));
                    break block95;
                }
                if (program.type.equals("PGEN")) {
                    PLINKFile file = PLINKFile.load(program.input, PLINKType.PGEN);
                    stdout.writeChar("Summary of PGEN File:");
                    stdout.writeChar("\n    PGEN File Name: " + program.input);
                    stdout.writeChar("\n    PGEN File Size: " + DataLengthUnit.B.convert(LiveFile.of(program.input + ".pgen").length() + LiveFile.of(program.input + ".pvar").length() + LiveFile.of(program.input + ".psam").length(), new DecimalFormat("#.###")));
                    stdout.writeChar("\n    Dimension of Genotype: " + file.numOfVariants() + " variant" + (file.numOfVariants() <= 1L ? "" : "s") + " and " + file.numOfIndividuals() + " individual" + (file.numOfIndividuals() <= 1 ? "" : "s"));
                    break block95;
                }
                throw new ParameterException(program.type);
            }
        }
    }

    static BiConsumer<Variant, TextRecord> getConverter(Set<String> fields) {
        List<BiConsumer<Variant, TextRecord>> converters = new List<BiConsumer<Variant, TextRecord>>();
        ByteStream container = new ByteStream();
        for (String field : fields) {
            if (field.equalsIgnoreCase("CHROM") || field.equalsIgnoreCase("CHR") || field.equalsIgnoreCase("CHROMOSOME")) {
                converters.add((variant, record) -> record.set(field, variant.getChromosome().toBytes()));
                continue;
            }
            if (field.equalsIgnoreCase("POS") || field.equalsIgnoreCase("BP") || field.equalsIgnoreCase("base_pair_location")) {
                converters.add((variant, record) -> record.set(field, variant.getPosition()));
                continue;
            }
            if (field.equalsIgnoreCase("REF")) {
                converters.add((variant, record) -> {
                    if (variant.numOfAlleles() == 0) {
                        record.set(field, ".");
                    } else if (variant.numOfAlleles() >= 1) {
                        record.set(field, variant.alleleOfIndex(0));
                    }
                });
                continue;
            }
            if (field.equalsIgnoreCase("ALT")) {
                converters.add((variant, record) -> {
                    if (variant.numOfAlleles() <= 1) {
                        record.set(field, ".");
                    } else if (variant.numOfAlleles() == 2) {
                        record.set(field, variant.alleleOfIndex(1));
                    } else {
                        container.clear();
                        container.writeChar(variant.alleleOfIndex(1));
                        int l = variant.numOfAlleles();
                        for (int i = 2; i < l; ++i) {
                            container.write(44);
                            container.writeChar(variant.alleleOfIndex(i));
                        }
                        record.set(field, container.toBytes(true));
                    }
                });
                continue;
            }
            if (field.equalsIgnoreCase("ALLELE")) {
                converters.add((variant, record) -> {
                    if (variant.numOfAlleles() == 0) {
                        record.set(field, ".");
                    } else {
                        container.clear();
                        container.writeChar(variant.alleleOfIndex(0));
                        int l = variant.numOfAlleles();
                        for (int i = 1; i < l; ++i) {
                            container.write(44);
                            container.writeChar(variant.alleleOfIndex(i));
                        }
                        record.set(field, container.toBytes(true));
                    }
                });
                continue;
            }
            if (field.equalsIgnoreCase("AC")) {
                converters.add((variant, record) -> {
                    container.clear();
                    container.writeChar(variant.getGenotypes().counter().getAC());
                    record.set(field, container.toBytes(true));
                });
                continue;
            }
            if (field.equalsIgnoreCase("AN")) {
                converters.add((variant, record) -> {
                    container.clear();
                    container.writeChar(variant.getGenotypes().counter().getAN());
                    record.set(field, container.toBytes(true));
                });
                continue;
            }
            if (field.equalsIgnoreCase("AF")) {
                converters.add((variant, record) -> {
                    container.clear();
                    container.writeChar(variant.getGenotypes().counter().getAF());
                    record.set(field, container.toBytes(true));
                });
                continue;
            }
            if (field.equalsIgnoreCase("GT")) {
                converters.add((variant, record) -> {
                    container.clear();
                    container.writeChar(variant.getGenotypes().counter().toString());
                    record.set(field, container.toBytes(true));
                });
                continue;
            }
            if (field.equalsIgnoreCase("ACs")) {
                converters.add((variant, record) -> {
                    container.clear();
                    boolean empty = true;
                    int l = variant.numOfAlleles();
                    for (int i = 0; i < l; ++i) {
                        if (!empty) {
                            container.write(44);
                        }
                        container.writeChar(variant.getGenotypes().counter().count(i));
                        empty = false;
                    }
                    record.set(field, container.toBytes(true));
                });
                continue;
            }
            converters.add((variant, record) -> {
                if (record.containsKey(field)) {
                    record.set(field, variant.getPropertyAsString(field));
                } else {
                    record.set(field, ".");
                }
            });
        }
        return (variant, record) -> {
            for (BiConsumer consumer : converters) {
                consumer.accept(variant, record);
            }
        };
    }

    static enum SiteConverter implements IConverter<TextRecord>
    {
        INSTANCE;


        @Override
        public TextRecord convert(String name, String ... values2) {
            if (values2.length == 0) {
                values2 = new String[]{"CHROM", "POS", "REF", "ALT", "AC", "AN", "AF", "GT", "ACs"};
            }
            LinkedSet<String> fields = new LinkedSet<String>();
            for (String token : values2) {
                for (String field : token.split(",")) {
                    if (((IndexableSet)fields).contains(field)) {
                        throw new ParameterException("Invalid parameter: \"" + name + "\" contains duplicated field '" + field + "'");
                    }
                    ((AbstractCollection)fields).add(field);
                }
            }
            return new TextRecord(fields);
        }
    }

    static enum IndividualConverter implements IConverter<String>
    {
        INSTANCE;

        final List<String> FIELDS = List.wrap("COMMA", "TAB", "BLANK", "SEMICOLON", "LINE", ",", "\t", " ", ";", "\n").asUnmodifiable();

        @Override
        public String convert(String name, String ... values2) {
            if (values2.length == 0) {
                return "COMMA";
            }
            if (values2.length > 2) {
                throw new ParameterException(Arrays.toString(values2));
            }
            String type = values2[0].toUpperCase();
            if (this.FIELDS.contains(type)) {
                return type;
            }
            throw new ParameterException("Invalid parameter: \"" + name + "\" should be one of the following: COMMA, TAB, BLANK, SEMICOLON, LINE (" + values2[0] + " given)");
        }
    }
}

