/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.converter.IConverter;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.toolkit.input.MAFInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.Indirect;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.option.OptionBundle;
import edu.sysu.pmglab.commandParser.annotation.rule.Counter;
import edu.sysu.pmglab.commandParser.annotation.rule.Rule;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.container.entry.TTriEntry;
import edu.sysu.pmglab.container.iterator.SingletonIterable;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.GTBWriter;
import edu.sysu.pmglab.gtb.command.VariantProcessOptions;
import edu.sysu.pmglab.gtb.command.input.MAFInputCommandOptions;
import edu.sysu.pmglab.gtb.command.input.StandardVariantInputCommandOptions;
import edu.sysu.pmglab.gtb.command.output.GTBOutputCommandOptions;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.Genotypes;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.progressbar.ProgressBar;
import edu.sysu.pmglab.progressbar.ProgressConsumer;
import java.io.IOException;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="maf2gtb <input> <input> ... --output <output> [options]", usage_item={@UsageItem(key="API", value={"edu.sysu.pmglab.ccf.toolkit.Processor"}), @UsageItem(key="About", value={"Convert mutation annotation format (MAF) to GTB format.", "MAF follows the MAF specification (https://docs.gdc.cancer.gov/Data/File_Formats/MAF_Format/).", "To convert output to mutation-level records, add '--collect-mutation' option."})}, rule=@Rule(counter={@Counter(item={"--collect-mutation", "--field"}, count=1, rule=Counter.Type.AT_MOST)}), indirect=@Indirect(enable=true))
public class MAF2GTBCommandProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(MAF2GTBCommandProgram.class);
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--silent"}, type=FieldType.NULL)
    @OptionUsage(description={"Suppress terminal output logs."})
    boolean silent = false;
    @Option(names={"maf2gtb"}, type=FieldType.livefile, container=Container.LIST, required=true)
    List<LiveFile> files;
    @OptionBundle
    MAFInputCommandOptions input = new MAFInputCommandOptions();
    @OptionBundle
    VariantProcessOptions processor = new VariantProcessOptions();
    @OptionBundle
    GTBOutputCommandOptions output = new GTBOutputCommandOptions();

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        final MAF2GTBCommandProgram program = new MAF2GTBCommandProgram();
        if (args.length == 1 && args[0].equals("maf2gtb")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (!program.silent) {
            LOGGER.info("\n{}", (Object)options);
        }
        StandardVariantInputCommandOptions<Variant, MAFInputOption> inputOptions = program.input.getInputOptions(program.files);
        Processor.setInputs(inputOptions).setOutput(program.output.getOutputOptions(inputOptions)).configureOption((inputs, output) -> {
            if (program.output.getAllFields() == null) {
                if (inputs.size() > 0 && !program.input.requireCollectMutation()) {
                    output.addFields(((MAFInputOption)inputs.fastGet(0)).getAllFields());
                }
            } else {
                for (TTriEntry<String, IFieldType, String> field : program.output.getAllFields()) {
                    if (field == null) continue;
                    output.addField(field.getValue1(), field.getValue2() == null ? FieldType.bytecode : field.getValue2());
                }
            }
        }).bridge(new IConverter<Variant, MAFInputOption, Variant, GTBOutputOption>(){
            final ILiteConverter<Variant, Iterable<Variant>> converter;
            {
                this.converter = program.input.requireCollectMutation() ? null : program.processor.getVariantConverter();
            }

            @Override
            public Iterable<Variant> converter(Variant input, MAFInputOption source2, long pointer, GTBOutputOption target) throws IOException {
                if (program.output.getAllFields() != null) {
                    for (TTriEntry<String, IFieldType, String> field : program.output.getAllFields()) {
                        if (field == null) continue;
                        input.setProperty(field.getValue1(), input.getProperty(field.getValue3()));
                    }
                }
                return this.converter == null ? new SingletonIterable<Variant>(input) : this.converter.converter(input);
            }
        }).setListener(program.silent ? null : new InputOutputListener("Input", "variants", "Output", "variants")).submit(program.threads);
        if (program.input.requireCollectMutation()) {
            GTBSorter sorter = GTBSorter.setInput(program.output.getFile(), new String[0]).setListener(program.silent ? null : new SortListener("Crude Indexed", "Sorted", "variants"));
            if (!sorter.isOrdered(program.threads)) {
                sorter.sort(program.output.getFile(), program.threads, false);
            }
            ILiteConverter<Variant, Iterable<Variant>> converter = program.processor.getVariantConverter();
            GTBManager manager = new GTBManager(program.output.getFile());
            Comparator<Variant> comparator = Comparator.comparing(o -> o.alleleOfIndex(0));
            List<GTBReader> readers = new GTBReader(new GTBReaderOption(manager, true, true)).part(program.threads);
            GTBWriter writers = GTBWriter.setOutput(program.output.getFile()).addIndividuals(manager.getIndividuals()).instance(program.threads).addMeta(manager.getMeta());
            ThreadQueue queue = new ThreadQueue(program.threads);
            ProgressBar bar = new ProgressBar.Builder().setTextRenderer("Merge", "records").setInitialMax(manager.numOfVariants()).setConsumer(program.silent ? ProgressConsumer.SILENT : null).build();
            int i = 0;
            while (i < readers.size()) {
                int partIndex = i++;
                queue.addTask((status, context) -> {
                    List<Variant> variants;
                    GTBReader reader = (GTBReader)readers.fastGet(partIndex);
                    Genotypes genotypes = new Genotypes(manager.numOfIndividuals());
                    while ((variants = reader.reads()).size() > 0) {
                        Variant targetVariant;
                        bar.step(variants.size());
                        if (variants.size() == 1) {
                            writers.write(partIndex, (Iterable)converter.converter(variants.fastGet(0)));
                            continue;
                        }
                        if (variants.size() < 2) continue;
                        Variant firstVariant = variants.get(0);
                        boolean allRefEquals = true;
                        for (int variantIndex = 0; variantIndex < variants.size(); ++variantIndex) {
                            Variant variant = variants.get(variantIndex);
                            if (variant.alleleOfIndex(0).equals(firstVariant.alleleOfIndex(0))) continue;
                            allRefEquals = false;
                            break;
                        }
                        genotypes.clear();
                        if (allRefEquals) {
                            targetVariant = new Variant(variants.fastGet(0).getCoordinate()).setGenotypes(genotypes);
                            for (Variant variant : variants) {
                                targetVariant.addAlleles(variant.getAlleles());
                                MAF2GTBCommandProgram.flushGenotypes(variant, targetVariant);
                            }
                            writers.write(partIndex, (Iterable)converter.converter(targetVariant));
                            continue;
                        }
                        variants.sort(comparator);
                        targetVariant = new Variant(variants.fastGet(0).getCoordinate()).setGenotypes(genotypes);
                        int count = 0;
                        while (variants.size() > 0) {
                            Variant variant;
                            variant = variants.popFirst();
                            if (count != 0 && !variant.alleleOfIndex(0).equals(targetVariant.alleleOfIndex(0))) {
                                writers.write(partIndex, (Iterable)converter.converter(targetVariant));
                                count = 0;
                                targetVariant.clearAlleles();
                                genotypes.clear();
                            }
                            targetVariant.addAlleles(variant.getAlleles());
                            MAF2GTBCommandProgram.flushGenotypes(variant, targetVariant);
                            ++count;
                        }
                        if (count <= 0) continue;
                        writers.write(partIndex, (Iterable)converter.converter(targetVariant));
                    }
                    reader.close();
                    writers.finish(partIndex);
                });
            }
            queue.close();
            bar.close();
            readers.close();
            writers.close();
        }
        program.output.finish(program.silent, program.threads);
    }

    private static void flushGenotypes(Variant source2, Variant target) {
        IGenotypes sourceGenotypes = source2.getGenotypes();
        IGenotypes targetGenotypes = target.getGenotypes();
        for (int j = 0; j < sourceGenotypes.size(); ++j) {
            Genotype genotype = sourceGenotypes.get(j);
            if (genotype.intcode() == 0) continue;
            int left = genotype.left();
            int right = genotype.right();
            if (left != -1) {
                left = target.indexOfAllele(source2.alleleOfIndex(left));
            }
            if (right != -1) {
                right = target.indexOfAllele(source2.alleleOfIndex(right));
            }
            targetGenotypes.set(j, Genotype.of(left, right).toUnPhased());
            break;
        }
    }
}

