/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.converter.IConverter;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.toolkit.input.PLINKInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.output.VCFOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.Indirect;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.option.OptionBundle;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.command.VariantProcessOptions;
import edu.sysu.pmglab.gtb.command.input.PLINKInputCommandOptions;
import edu.sysu.pmglab.gtb.command.input.StandardVariantInputCommandOptions;
import edu.sysu.pmglab.gtb.command.output.VCFOutputCommandOptions;
import edu.sysu.pmglab.gtb.genome.Variant;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="plink2vcf <input> <input> ... --output <output> [options]", usage_item={@UsageItem(key="API", value={"edu.sysu.pmglab.ccf.toolkit.Processor"}), @UsageItem(key="About", value={"Convert PLINK BED/PGEN format to VCF format.", "The input file path should exclude the extension, and the corresponding file will be detected based on the '--input-type' option.", "PLINK BED is a pure Java implementation, while PLINK PGEN requires Python packages jep, zstandard, Cython and pgenlib."})}, indirect=@Indirect(enable=true))
public class PLINK2VCFCommandProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(PLINK2VCFCommandProgram.class);
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--silent"}, type=FieldType.NULL)
    @OptionUsage(description={"Suppress terminal output logs."})
    boolean silent = false;
    @Option(names={"plink2vcf"}, type=FieldType.string, container=Container.LIST, required=true)
    List<String> files;
    @OptionBundle
    PLINKInputCommandOptions input = new PLINKInputCommandOptions();
    @OptionBundle
    VariantProcessOptions processor = new VariantProcessOptions();
    @OptionBundle
    VCFOutputCommandOptions output = new VCFOutputCommandOptions();

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        final PLINK2VCFCommandProgram program = new PLINK2VCFCommandProgram();
        if (args.length == 1 && args[0].equals("plink2vcf")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (program.output.isStdout()) {
            program.silent = true;
        }
        if (!program.silent) {
            LOGGER.info("\n{}", (Object)options);
        }
        StandardVariantInputCommandOptions<Variant, PLINKInputOption> inputOptions = program.input.getInputOptions(program.files);
        Processor.setInputs(inputOptions).setOutput(program.output.getOutputOptions(inputOptions)).bridge(new IConverter<Variant, PLINKInputOption, Variant, VCFOutputOption>(){
            final ILiteConverter<Variant, Iterable<Variant>> converter;
            {
                this.converter = program.processor.getVariantConverter();
            }

            @Override
            public Iterable<Variant> converter(Variant variant, PLINKInputOption source2, long pointer, VCFOutputOption target) throws IOException {
                return this.converter.converter(variant);
            }
        }).setListener(program.silent ? null : new InputOutputListener("Input", "variants", "Output", "variants")).submit(program.threads);
    }
}

