/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.option.Indirect;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.validator.range.Long_1_RangeValidator;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.GTBWriter;
import edu.sysu.pmglab.gtb.command.IndividualsSelectionConverter;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.progressbar.ProgressBar;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="split <input> --output <output> [options]", usage_item={@UsageItem(key="About", value={"Split a genotype dataset into smaller subsets based on variant blocks."})}, indirect=@Indirect(enable=true))
public class SplitGTBCommandProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(SplitGTBCommandProgram.class);
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--silent"}, type=FieldType.NULL)
    @OptionUsage(description={"Suppress terminal output logs."})
    boolean silent = false;
    @Option(names={"split"}, type=FieldType.livefile, required=true)
    LiveFile file;
    @Option(names={"--output", "-o"}, type=FieldType.string, defaultTo={"./archive"})
    @OptionUsage(description={"Set the output file path."}, defaultTo="./archive", format="--output <file>")
    String output = "archive";
    @Option(names={"--split-var"}, type=FieldType.int64, validator=Long_1_RangeValidator.class, required=true)
    @OptionUsage(format="--split-var <int>", description={"Split the input file into blocks of a specified number of variants."})
    long splitVar = 0L;
    @CustomOption(names={"--individual"}, converter=IndividualsSelectionConverter.class, arity={-1})
    @OptionUsage(description={"Select a subset of individuals. If this option is not specified, the individuals will be determined by all input files."}, format="--individual <string>,<string>,...")
    IndexableSet<String> individuals = null;
    @Option(names={"--ignore-index"}, type=FieldType.NULL)
    @OptionUsage(group="Output Options", description={"Disable coordinate-index table generation. By default, indexes are automatically created for optimized access."})
    boolean buildIndex = true;

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        SplitGTBCommandProgram program = new SplitGTBCommandProgram();
        if (args.length == 1 && args[0].equals("split")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (!program.silent) {
            LOGGER.info("\n{}", (Object)options);
        }
        GTBManager manager = new GTBManager(program.file);
        ThreadQueue queue = new ThreadQueue(program.threads);
        GTBReaderOption option = new GTBReaderOption(manager, program.individuals == null || program.individuals.hasOverlaps(manager.getIndividuals()), true);
        ProgressBar bar = new ProgressBar.Builder().setTextRenderer("Split", "variants").build();
        int index = 0;
        for (long processed = 0L; processed < option.numOfRecords(); processed += program.splitVar) {
            int taskId = index++;
            queue.addTask((status, context) -> {
                Variant variant;
                GTBReader reader = new GTBReader(option).limit((long)taskId * program.splitVar, (long)(taskId + 1) * program.splitVar);
                GTBWriter writer = GTBWriter.setOutput(program.output + "_" + (taskId + 1) + ".gtb").addIndividuals(option.getIndividuals()).addFields(option.getAllSupplementaryFields()).instance().addMeta(option.getGTBManager().getMeta());
                while ((variant = reader.read()) != null) {
                    writer.write(variant);
                    bar.step(1L);
                }
                writer.close();
                reader.close();
                if (program.buildIndex) {
                    GTBIndexer.setInput(writer.getFile(), new String[0]).save(1);
                }
            });
        }
        queue.close();
        bar.close();
    }
}

