/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.input.TextInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.Indirect;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.option.OptionBundle;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.container.entry.TTriEntry;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.command.input.StandardVariantInputCommandOptions;
import edu.sysu.pmglab.gtb.command.input.TEXTInputCommandOptions;
import edu.sysu.pmglab.gtb.command.output.GTBOutputCommandOptions;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.TextRecord;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="text2gtb <input> <input> ... --output <output> [options]", usage_item={@UsageItem(key="API", value={"edu.sysu.pmglab.ccf.toolkit.Processor"}), @UsageItem(key="About", value={"Convert TEXT format to GTB format."})}, indirect=@Indirect(enable=true))
public class TEXT2GTBCommandProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(TEXT2GTBCommandProgram.class);
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--silent"}, type=FieldType.NULL)
    @OptionUsage(description={"Suppress terminal output logs."})
    boolean silent = false;
    @Option(names={"text2gtb"}, type=FieldType.livefile, container=Container.LIST, required=true)
    List<LiveFile> files;
    @OptionBundle
    TEXTInputCommandOptions input = new TEXTInputCommandOptions();
    @OptionBundle
    GTBOutputCommandOptions output = new GTBOutputCommandOptions();

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        TEXT2GTBCommandProgram program = new TEXT2GTBCommandProgram();
        if (args.length == 1 && args[0].equals("text2gtb")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (!program.silent) {
            LOGGER.info("\n{}", (Object)options);
        }
        StandardVariantInputCommandOptions<TextRecord, TextInputOption> inputOptions = program.input.getInputOptions(program.files);
        Processor.setInputs(inputOptions).setOutput(program.output.getOutputOptions(inputOptions)).configureOption((inputs, output) -> {
            block3: {
                block2: {
                    if (program.output.getAllFields() != null) break block2;
                    if (inputs.size() <= 0) break block3;
                    Set<String> excludes = program.input.excludeFields();
                    for (String field : ((TextInputOption)inputs.fastGet(0)).getAllFields()) {
                        if (excludes.contains(field)) continue;
                        output.addField(field, FieldType.bytecode);
                    }
                    break block3;
                }
                for (TTriEntry<String, IFieldType, String> field : program.output.getAllFields()) {
                    if (field == null) continue;
                    output.addField(field.getValue1(), field.getValue2() == null ? FieldType.bytecode : field.getValue2());
                }
            }
        }).bridge(input -> {
            Variant variant = inputOptions.convert((TextRecord)input);
            if (program.output.getAllFields() != null) {
                for (TTriEntry<String, IFieldType, String> field : program.output.getAllFields()) {
                    if (field == null) continue;
                    variant.setProperty(field.getValue1(), variant.getProperty(field.getValue3()));
                }
            }
            return variant;
        }).setListener(program.silent ? null : new InputOutputListener("Input", "variants", "Output", "variants")).submit(program.threads);
        program.output.finish(program.silent, program.threads);
    }
}

