/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.input.TextInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.Indirect;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.option.OptionBundle;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.command.input.StandardVariantInputCommandOptions;
import edu.sysu.pmglab.gtb.command.input.TEXTInputCommandOptions;
import edu.sysu.pmglab.gtb.command.output.VCFOutputCommandOptions;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.TextRecord;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="text2vcf <input> <input> ... --output <output> [options]", usage_item={@UsageItem(key="API", value={"edu.sysu.pmglab.ccf.toolkit.Processor"}), @UsageItem(key="About", value={"Convert TEXT format to VCF format."})}, indirect=@Indirect(enable=true))
public class TEXT2VCFCommandProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(TEXT2VCFCommandProgram.class);
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--silent"}, type=FieldType.NULL)
    @OptionUsage(description={"Suppress terminal output logs."})
    boolean silent = false;
    @Option(names={"text2vcf"}, type=FieldType.livefile, container=Container.LIST, required=true)
    List<LiveFile> files;
    @OptionBundle
    TEXTInputCommandOptions input = new TEXTInputCommandOptions();
    @OptionBundle
    VCFOutputCommandOptions output = new VCFOutputCommandOptions();

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        TEXT2VCFCommandProgram program = new TEXT2VCFCommandProgram();
        if (args.length == 1 && args[0].equals("text2gtb")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (program.output.isStdout()) {
            program.silent = true;
        }
        if (!program.silent) {
            LOGGER.info("\n{}", (Object)options);
        }
        StandardVariantInputCommandOptions<TextRecord, TextInputOption> inputOptions = program.input.getInputOptions(program.files);
        Processor.setInputs(inputOptions).setOutput(program.output.getOutputOptions(inputOptions)).bridge(inputOptions::convert).setListener(program.silent ? null : new InputOutputListener("Input", "variants", "Output", "variants")).submit(program.threads);
    }
}

