/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.command.program;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.converter.IConverter;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.toolkit.input.VCFInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.Indirect;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.option.OptionBundle;
import edu.sysu.pmglab.commandParser.annotation.rule.Functional;
import edu.sysu.pmglab.commandParser.annotation.rule.Rule;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.container.entry.TTriEntry;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.command.VariantProcessOptions;
import edu.sysu.pmglab.gtb.command.input.StandardVariantInputCommandOptions;
import edu.sysu.pmglab.gtb.command.input.VCFInputCommandOptions;
import edu.sysu.pmglab.gtb.command.output.GTBOutputCommandOptions;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="vcf2gtb <input> <input> ... --output <output> [options]", usage_item={@UsageItem(key="API", value={"edu.sysu.pmglab.ccf.toolkit.Processor"}), @UsageItem(key="About", value={"Convert VCF format to GTB format.", "By default, genotypes in the VCF file undergoes quality control, where low-quality genotypes are replaced with ./. and genotype quality information is discarded.", "VCF follows the VCFv4.5 specification (https://samtools.github.io/hts-specs/VCFv4.5.pdf). Genotypes are parsed from the 'GT' field in the FORMAT column, so outputs like Strelka's cannot be correctly parsed.", "Use the options '--field --prune --seq-an 1~ --seq-af 0.000001~0.999999' to retain a minimal subset of genotypes containing only variant sites."})}, summary_filter={VCFInputCommandOptions.VCFQCOptionsSummaryDisplayFilter.class}, rule=@Rule(function={@Functional(item=VCFInputCommandOptions.VCFQCOptionPassedRule.class)}), indirect=@Indirect(enable=true))
public class VCF2GTBCommandProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCF2GTBCommandProgram.class);
    @Option(names={"--threads", "-t"}, type=FieldType.varInt32, defaultTo={"4"})
    @OptionUsage(format="--threads <int>", defaultTo="4", description={"Configure the number of concurrent threads."})
    int threads = RuntimeProperty.INIT_THREADS;
    @Option(names={"--silent"}, type=FieldType.NULL)
    @OptionUsage(description={"Suppress terminal output logs."})
    boolean silent = false;
    @Option(names={"vcf2gtb"}, type=FieldType.livefile, container=Container.LIST, required=true)
    List<LiveFile> files;
    @OptionBundle
    VCFInputCommandOptions input = new VCFInputCommandOptions();
    @OptionBundle
    VariantProcessOptions processor = new VariantProcessOptions();
    @OptionBundle
    GTBOutputCommandOptions output = new GTBOutputCommandOptions();

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        final VCF2GTBCommandProgram program = new VCF2GTBCommandProgram();
        if (args.length == 1 && args[0].equals("vcf2gtb")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (!program.silent) {
            LOGGER.info("\n{}", (Object)options);
        }
        StandardVariantInputCommandOptions<Variant, VCFInputOption> inputOptions = program.input.getInputOptions(program.files);
        Processor.setInputs(inputOptions).setOutput(program.output.getOutputOptions(inputOptions)).configureOption((inputs, output) -> {
            if (program.output.getAllFields() == null) {
                output.addField("ID", FieldType.string).addField("QUAL", FieldType.string).addField("FILTER", FieldType.string).addField("INFO", FieldType.stringBytecodeMap);
            } else {
                block12: for (TTriEntry<String, IFieldType, String> field : program.output.getAllFields()) {
                    if (field == null) continue;
                    switch (field.getValue1()) {
                        case "ID": {
                            output.addField(null, "ID", field.getValue2() == null ? FieldType.string : field.getValue2());
                            continue block12;
                        }
                        case "QUAL": {
                            output.addField(null, "QUAL", field.getValue2() == null ? FieldType.string : field.getValue2());
                            continue block12;
                        }
                        case "FILTER": {
                            output.addField(null, "FILTER", field.getValue2() == null ? FieldType.string : field.getValue2());
                            continue block12;
                        }
                        case "INFO": {
                            output.addField(null, "INFO", field.getValue2() == null ? FieldType.stringBytecodeMap : field.getValue2());
                            continue block12;
                        }
                    }
                    output.addField(field.getValue1(), field.getValue2() == null ? FieldType.bytecode : field.getValue2());
                }
            }
        }).bridge(new IConverter<Variant, VCFInputOption, Variant, GTBOutputOption>(){
            final ILiteConverter<Variant, Iterable<Variant>> converter;
            {
                this.converter = program.processor.getVariantConverter();
            }

            @Override
            public Iterable<Variant> converter(Variant variant, VCFInputOption source2, long pointer, GTBOutputOption target) throws IOException {
                if (program.output.getAllFields() != null) {
                    for (TTriEntry<String, IFieldType, String> field : program.output.getAllFields()) {
                        if (field == null) continue;
                        variant.setProperty(field.getValue1(), variant.getProperty(field.getValue3()));
                    }
                }
                return this.converter.converter(variant);
            }
        }).setListener(program.silent ? null : new InputOutputListener("Input", "variants", "Output", "variants")).submit(program.threads);
        program.output.finish(program.silent, program.threads);
    }
}

